/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.pdf;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.common.util.docparse.ReadPdfUtil;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.pdf.AnalysePDFTextRGConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="analysePDFTextArrayRGChannelExtractor")
public class AnalysePDFTextArrayRGExtractor
extends AbstractChannelExtractor<FileBytesInfo, AnalysePDFTextRGConfig> {
    private static final Logger log = LoggerFactory.getLogger(AnalysePDFTextArrayRGExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.ANALYSE_PDF_TEXT_RG_ARRAY.getCode(), GroupLevel3Enum.ANALYSE_PDF_TEXT_RG_ARRAY.getName(), 4);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.ANALYSE_PDF_TEXT_RG_ARRAY.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return AnalysePDFTextRGConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.TABLE.getKey());
        return list;
    }

    @Override
    public void before(FileBytesInfo wordInfo, AnalysePDFTextRGConfig wordTableConfig) {
    }

    @Override
    public List<ExtractResult> extract(FileBytesInfo fileBytesInfo, AnalysePDFTextRGConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010AnalysePDFTextArrayRGExtractor.extract\u3011" + fileBytesInfo.getFileName());
        JSONObject structureInfo = ReadPdfUtil.getPDFTable((FileBytesInfo)fileBytesInfo, (String)"line");
        ArrayList<Object> result = new ArrayList<Object>();
        JSONArray textBlocks = structureInfo.getJSONArray("textBlocks");
        int k = 0;
        boolean start = false;
        if (!StringUtils.isEmpty((String)config.getKeyword())) {
            k = this.findIndex(textBlocks, config.getKeyword());
            start = true;
            if (k == -1) {
                return this.getResultTable(result);
            }
        }
        boolean s = false;
        int maxKeyLengh = 0;
        boolean tablekey = !CollectionUtils.isEmpty((Collection)config.getTableKey()) && config.getTableKey().get(0) != null && !((String)config.getTableKey().get(0)).isEmpty();
        StringBuilder regex = new StringBuilder("(.*?)");
        StringBuilder rowRegex = new StringBuilder(")(.*?)(?=(");
        if (tablekey) {
            int j = config.getTableKey().size();
            for (int i = 0; i < j; ++i) {
                String tableKey = (String)config.getTableKey().get(i);
                regex.append(tableKey).append("[\uff1a:](.*?)");
                if (i > 0) {
                    rowRegex.append("|");
                }
                rowRegex.append(tableKey);
                if (tableKey.length() > maxKeyLengh) {
                    maxKeyLengh = tableKey.length();
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("row", (Object)0);
                jsonObject.put("col", (Object)i);
                jsonObject.put("text", (Object)tableKey);
                result.add(jsonObject);
            }
        } else {
            return this.getResultTable(result);
        }
        rowRegex.append("))");
        String text = AnalysePDFTextArrayRGExtractor.findMatchStr(k, textBlocks, config, regex.toString());
        if (StringUtils.isBlank((CharSequence)text)) {
            return this.getResultTable(new ArrayList<Object>());
        }
        String[] infos = text.replaceAll("\\n", "").split((String)config.getTableKey().get(0));
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(infos));
        list.removeIf(StringUtils::isEmpty);
        int m = list.size();
        for (int l = 0; l < m; ++l) {
            String info = (String)config.getTableKey().get(0) + (String)list.get(l);
            int b = config.getTableKey().size();
            for (int n = 0; n < b; ++n) {
                String tableKey = (String)config.getTableKey().get(n);
                String r = "(?<=" + tableKey + "[:\uff1a]" + rowRegex;
                if (MatchTextUtil.isMatch((String)r, (String)info).booleanValue()) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("row", (Object)(l + 1));
                    jsonObject.put("col", (Object)n);
                    jsonObject.put("text", (Object)MatchTextUtil.matchOne((String)r, (String)info).trim());
                    result.add(jsonObject);
                }
                if (n + 1 != b || MatchTextUtil.isMatch((String)r, (String)info).booleanValue()) continue;
                String a = "(?<=" + tableKey + "[:\uff1a])(.*)";
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("row", (Object)(l + 1));
                jsonObject.put("col", (Object)n);
                jsonObject.put("text", (Object)MatchTextUtil.matchOne((String)a, (String)info).trim());
                result.add(jsonObject);
            }
        }
        return this.getResultTable(result);
    }

    private static String findMatchStr(int start, JSONArray textBlocks, AnalysePDFTextRGConfig config, String regex) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder strCache = new StringBuilder();
        int s = 0;
        for (int i = start; i < textBlocks.size(); ++i) {
            JSONObject textBlock = textBlocks.getJSONObject(i);
            if (!StringUtils.isEmpty((String)config.getStopKey()) && MatchTextUtil.isMatch((String)config.getStopKey(), (String)textBlock.getString("text")).booleanValue()) {
                return stringBuilder.toString();
            }
            String text = textBlock.getString("text");
            if (StringUtils.isNotBlank((CharSequence)strCache)) {
                text = strCache + text;
                strCache = new StringBuilder();
            }
            if (!MatchTextUtil.isMatch((String)regex, (String)text).booleanValue()) {
                if (++s >= config.getStopLine()) {
                    return stringBuilder.toString();
                }
                strCache.append(text);
                continue;
            }
            stringBuilder.append(text);
        }
        return stringBuilder.toString();
    }

    private List<ExtractResult> getResultTable(List<Object> result) {
        ArrayList<ExtractResult> ll = new ArrayList<ExtractResult>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("cells", result);
        ll.add(new ExtractResult((Object)jsonObject, ReturnTypeEnum.TABLE.getKey(), this.implCodeDto().getImplCode()));
        return ll;
    }

    private JSONObject textToJSONObject(String text) {
        String[] chinese;
        JSONObject jsonObject = new JSONObject();
        String[] english = text.split(":");
        if (english.length + (chinese = text.split("\uff1a")).length == 2) {
            return jsonObject;
        }
        String[] texts = english.length > chinese.length ? english : chinese;
        String key = texts[0];
        int j = texts.length - 1;
        for (int i = 1; i < j; ++i) {
            String t = texts[i];
            String k = t.substring(t.trim().lastIndexOf(" ") + 1).trim();
            String v = t.substring(0, t.trim().lastIndexOf(" ")).trim();
            jsonObject.put(key, (Object)v);
            key = k;
        }
        jsonObject.put(key, (Object)texts[texts.length - 1]);
        return jsonObject;
    }

    private int findIndex(JSONArray textBlocks, String keyword) {
        int j = textBlocks.size();
        for (int i = 0; i < j; ++i) {
            JSONObject textBlock = textBlocks.getJSONObject(i);
            if (!MatchTextUtil.isMatch((String)keyword, (String)textBlock.getString("text")).booleanValue()) continue;
            return i + 1;
        }
        return -1;
    }
}

