/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.pdf;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.Cell;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.Table;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.common.util.docparse.ReadPdfUtil;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.pdf.AnalysePDFTableConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.location.TempLocation;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="analysePDFTableChannelExtractor")
public class AnalysePDFTableExtractor
extends AbstractChannelExtractor<FileBytesInfo, AnalysePDFTableConfig> {
    private static final Logger log = LoggerFactory.getLogger(AnalysePDFTableExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.ANALYSE_PDF_TABLE.getCode(), GroupLevel3Enum.ANALYSE_PDF_TABLE.getName(), 2);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.ANALYSE_PDF_TABLE.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return AnalysePDFTableConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.TABLE.getKey());
        return list;
    }

    @Override
    public void before(FileBytesInfo wordInfo, AnalysePDFTableConfig wordTableConfig) {
    }

    @Override
    public List<ExtractResult> extract(FileBytesInfo fileBytesInfo, AnalysePDFTableConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010AnalysePDFTableExtractor.extract\u3011" + fileBytesInfo.getFileName());
        String tableRecStrategy = config.getTableRecStrategy();
        tableRecStrategy = "1".equals(tableRecStrategy) ? "strict" : "line";
        JSONObject structureInfo = ReadPdfUtil.getPDFTable((FileBytesInfo)fileBytesInfo, (String)tableRecStrategy);
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        if (structureInfo == null) {
            log.info("\u8868\u683c\u63d0\u53d6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5python\u811a\u672c\u662f\u5426\u6b63\u5e38\u6267\u884c");
            return result;
        }
        log.info("\u3010AnalysePDFTableExtractor.extract\u3011\u5f00\u59cb\u89e3\u6790pdf\u8868\u683c");
        if (!ObjectUtil.isNull((Object)structureInfo.get((Object)"code"))) {
            log.error("\u3010AnalysePDFTableExtractor.extract\u3011\u89e3\u6790\u5931\u8d25,\u539f\u56e0{}", structureInfo.get((Object)"info"));
            return result;
        }
        JSONArray tables = structureInfo.getJSONArray("tables");
        if (ObjectUtil.isNotNull((Object)config.getTableIndex())) {
            int j = tables.size();
            for (int i = 0; i < j; ++i) {
                if (!Objects.equals(tables.getJSONObject(i).getInteger("index"), config.getTableIndex())) continue;
                ArrayList<JSONObject> resultArr = new ArrayList<JSONObject>();
                resultArr.add(tables.getJSONObject(i));
                TempLocation tempLocation = new TempLocation();
                tempLocation.setFileId(fileBytesInfo.getFileId());
                result.add(new ExtractResult(resultArr, (Location)tempLocation, ReturnTypeEnum.TABLE.getKey(), this.implCodeDto().getImplCode()));
            }
        }
        if (CollUtil.isNotEmpty((Collection)config.getTableKey()) && StringUtils.isNotEmpty((String)((String)config.getTableKey().get(0)))) {
            for (String tableKeys : config.getTableKey()) {
                String[] tableKey = tableKeys.split(";");
                block2: for (int i = 0; i < tables.size(); ++i) {
                    JSONObject table = tables.getJSONObject(i);
                    JSONArray cells = table.getJSONArray("cells");
                    if (cells.isEmpty()) continue;
                    int cellIndex = 0;
                    JSONObject cell = cells.getJSONObject(cellIndex);
                    for (int j = 0; j < tableKey.length; ++j) {
                        String head = tableKey[j];
                        while (!MatchTextUtil.isMatch((String)head, (String)(cell.getString("text") == null ? "" : cell.getString("text"))).booleanValue()) {
                            if (cell.getInteger("row") + 1 >= ReadPdfUtil.tablekeyLineStatic || ++cellIndex >= cells.size()) continue block2;
                            cell = cells.getJSONObject(cellIndex);
                        }
                        if (j != tableKey.length - 1) continue;
                        ArrayList<JSONObject> resultArr = new ArrayList<JSONObject>();
                        resultArr.add(table);
                        TempLocation tempLocation = new TempLocation();
                        tempLocation.setFileId(fileBytesInfo.getFileId());
                        result.add(new ExtractResult(resultArr, (Location)tempLocation, ReturnTypeEnum.TABLE.getKey(), this.implCodeDto().getImplCode()));
                    }
                }
            }
        }
        log.info("\u3010AnalysePDFTableExtractor.extract\u3011\u8868\u683c\u63d0\u53d6\u7ed3\u675f");
        return result;
    }

    @Override
    public ExtractResult after(List<ExtractResult> list, AnalysePDFTableConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010AnalysePDFTableExtractor.after\u3011");
        ExtractResult result = this.dealData(list, config);
        if (result != null) {
            result.setResult(this.afterHandler(result.getResult(), config));
        }
        return result;
    }

    private ExtractResult dealData(List<ExtractResult> list, AnalysePDFTableConfig config) {
        ExtractResult extractResult = this.getResultByMatchStrategy(list, config);
        if (extractResult == null) {
            return null;
        }
        Object tableList = extractResult.getResult();
        if (tableList instanceof List) {
            List result = Collections.singletonList(((List)tableList).get(0));
            StringBuilder headText = new StringBuilder();
            int pageNum = -99;
            ArrayList<Table> tables = new ArrayList<Table>();
            for (Object o : result) {
                JSONObject table = (JSONObject)o;
                JSONArray cells = table.getJSONArray("cells");
                Table table1 = new Table();
                tables.add(table1);
                table1.setCells(new ArrayList());
                int l = cells.size();
                for (int k = 0; k < l; ++k) {
                    JSONObject cell = cells.getJSONObject(k);
                    Cell cell1 = new Cell();
                    cell1.setText(cell.getString("text"));
                    cell1.setCol(cell.getInteger("col"));
                    cell1.setRow(cell.getInteger("row"));
                    cell1.setColSpan(cell.getInteger("col_span"));
                    cell1.setRowSpan(cell.getInteger("row_span"));
                    table1.getCells().add(cell1);
                    if (cell.getInteger("row") != 0) continue;
                    headText.append(cell.getString("text"));
                    pageNum = cell.getString("pagenum") == null ? -99 : cell.getInteger("pagenum");
                }
            }
            TempLocation location = new TempLocation();
            location.setPageNum(Integer.valueOf(pageNum));
            location.setContext(headText.toString());
            location.setText(headText.toString());
            location.setFileId(extractResult.getLocation() != null ? extractResult.getLocation().getFileId() : null);
            extractResult.setLocation((Location)location);
            extractResult.setResult(tables);
            log.info("\u63d0\u53d6>>\u3010AnalysePDFTableExtractor.after\u3011\u7ed3\u675f,\u8868\u5934\uff1a" + headText);
        }
        return extractResult;
    }
}

