/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.ocr;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ocr.OcrSignConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.extractor.ocr.OcrObjects;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.OcrPageInfo;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.OcrPageResponse;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.location.LocationList;
import com.jxdinfo.idp.extract.domain.location.TempLocation;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigOcrResponse;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="ocrWritedateListChannelExtractor")
public class OcrWritedateListExtractor
extends AbstractChannelExtractor<ConfigOcrResponse, OcrSignConfig> {
    private static final Logger log = LoggerFactory.getLogger(OcrWritedateListExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.OCR_WRITE_DATE_LIST.getCode(), GroupLevel3Enum.OCR_WRITE_DATE_LIST.getName(), 7);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.OCR_WRITE_DATE_LIST.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return OcrSignConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.DOUBLE.getKey());
        list.add(ReturnTypeEnum.WRITEDATELIST.getKey());
        return list;
    }

    @Override
    public void before(ConfigOcrResponse ocrResponse, OcrSignConfig config) {
    }

    @Override
    public List<ExtractResult> extract(ConfigOcrResponse ocrResponse, OcrSignConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010OcrWritedateListExtractor.extract\u3011");
        String returnType = config.getDataType();
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        ArrayList objectsList = new ArrayList();
        List ocrList = ocrResponse.getOcrGenericList();
        if (ocrList == null || ocrList.isEmpty()) {
            return result;
        }
        int pageCount = ocrList.size();
        ArrayList<TempLocation> locations = new ArrayList<TempLocation>();
        for (OcrPageResponse ocr : ocrList) {
            List writeDateObjectList = ocr.getObjects().stream().filter(ocrObjects -> ocrObjects.getLabel().equals("writedate")).collect(Collectors.toList());
            if (writeDateObjectList.isEmpty()) continue;
            if (StringUtils.isNotBlank((CharSequence)config.getDetectPageStr()) && !"0".equals(config.getDetectPageStr())) {
                String[] pageNums = String.valueOf(config.getDetectPageStr()).split(",");
                writeDateObjectList = writeDateObjectList.stream().filter(ocrObjects -> {
                    for (String pageNum : pageNums) {
                        int page = Integer.parseInt(pageNum);
                        if (page < 0) {
                            page = pageCount + page + 1;
                        }
                        if (ocrObjects.getPage_id() != page - 1) continue;
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
            }
            if (writeDateObjectList.isEmpty()) continue;
            for (int i = 0; i < writeDateObjectList.size(); ++i) {
                OcrObjects writeDateObject = (OcrObjects)writeDateObjectList.get(i);
                writeDateObject.setObj_box(writeDateObject.getBox());
                writeDateObject.setObj_text(writeDateObject.getText());
                writeDateObjectList.set(i, writeDateObject);
                TempLocation location = new TempLocation();
                location.setFileId(ocrResponse.getFileId());
                location.setPageNum(Integer.valueOf(writeDateObject.getPage_id() + 1));
                location.setTextBox(writeDateObject.getBox());
                OcrPageInfo pageInfo = new OcrPageInfo();
                try {
                    BeanUtil.copyProperties((Object)ocr.getPage_info(), (Object)pageInfo, (String[])new String[0]);
                }
                catch (Exception e) {
                    log.error("ocr\u5370\u7ae0\u6570\u7ec4\u590d\u5236pageInfo\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                }
                location.setPageInfo(pageInfo);
                String resultTxt = JSON.toJSONString((Object)writeDateObject);
                location.setContext(resultTxt);
                location.setText(resultTxt);
                locations.add(location);
            }
            objectsList.addAll(writeDateObjectList);
        }
        if (ReturnTypeEnum.DOUBLE.getKey().equals(returnType)) {
            result.add(new ExtractResult((Object)objectsList.size(), returnType, this.implCodeDto().getImplCode()));
        } else {
            result.add(new ExtractResult(objectsList, (Location)new LocationList(locations), ReturnTypeEnum.WRITEDATELIST.getKey(), this.implCodeDto().getImplCode()));
        }
        return result;
    }
}

