/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.ocr;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ocr.OcrSignConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.OcrPageInfo;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.SingleWriteDataInfo;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.location.TempLocation;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigOcrResponse;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="ocrWritedateChannelExtractor")
public class OcrWritedateExtractor
extends AbstractChannelExtractor<ConfigOcrResponse, OcrSignConfig> {
    private static final Logger log = LoggerFactory.getLogger(OcrWritedateExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.OCR_WRITE_DATE.getCode(), GroupLevel3Enum.OCR_WRITE_DATE.getName(), 6);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.OCR_WRITE_DATE.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return OcrSignConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.WRITEDATE.getKey());
        return list;
    }

    @Override
    public void before(ConfigOcrResponse ocrResponse, OcrSignConfig config) {
    }

    @Override
    public List<ExtractResult> extract(ConfigOcrResponse ocrResponse, OcrSignConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010OcrWritedateExtractor.extract\u3011");
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        if (ocrResponse == null) {
            return result;
        }
        SingleWriteDataInfo writedate = (SingleWriteDataInfo)ocrResponse.getWritedate().get(config.getElement_name());
        if (writedate == null) {
            return result;
        }
        TempLocation location = new TempLocation();
        location.setPageNum(Integer.valueOf(writedate.getPage_id() + 1));
        location.setTextBox(writedate.getObj_box());
        location.setPageInfo((OcrPageInfo)ocrResponse.getPage_info().get(writedate.getPage_id()));
        String resultTxt = JSON.toJSONString((Object)writedate);
        location.setContext(resultTxt);
        location.setText(resultTxt);
        location.setFileId(ocrResponse.getFileId());
        result.add(new ExtractResult((Object)writedate, (Location)location, ReturnTypeEnum.WRITEDATE.getKey(), GroupLevel3Enum.OCR_WRITE_DATE.getCode()));
        return result;
    }
}

