/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.ocr;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.Cell;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.Table;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ocr.OcrTableConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.location.TempLocation;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigOcrResponse;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="ocrTableChannelExtractor")
public class OcrTableExtractor
extends AbstractChannelExtractor<ConfigOcrResponse, OcrTableConfig> {
    private static final Logger log = LoggerFactory.getLogger(OcrTableExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.OCR_TABLE.getCode(), GroupLevel3Enum.OCR_TABLE.getName(), 3);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.OCR_TABLE.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return OcrTableConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.TABLE.getKey());
        return list;
    }

    @Override
    public void before(ConfigOcrResponse ocrResponse, OcrTableConfig config) {
    }

    @Override
    public List<ExtractResult> extract(ConfigOcrResponse ocrResponse, OcrTableConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010OcrTableExtractor.extract\u3011");
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        if (ocrResponse == null) {
            return result;
        }
        List ocrResult = ocrResponse.getTable().get((Object)config.getElement_name());
        if (ocrResult == null) {
            return result;
        }
        TempLocation location = new TempLocation();
        List tableResult = ocrResult;
        if (!tableResult.isEmpty()) {
            Map<String, Object> resetTable = this.resetTable(tableResult);
            List tableList = (List)resetTable.get("table");
            if (tableList != null && !tableList.isEmpty()) {
                ocrResult = tableList;
            }
            String tableTitle = String.valueOf(resetTable.get("tableTitle"));
            location.setContext(tableTitle);
            location.setText(tableTitle);
        }
        location.setFileId(ocrResponse.getFileId());
        result.add(new ExtractResult((Object)ocrResult, (Location)location, ReturnTypeEnum.TABLE.getKey(), this.implCodeDto().getImplCode()));
        return result;
    }

    private Map<String, Object> resetTable(List<Object> list) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010OcrItemExtractor.resetTable\u3011");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<Table> result = new ArrayList<Table>();
        Table table = new Table();
        table.setCells(new ArrayList());
        String tableTitle = "";
        int rowIndex = 0;
        for (Object item : list) {
            if (item instanceof JSONArray) {
                JSONArray tableResultItemJson = (JSONArray)item;
                for (int i = 0; i < tableResultItemJson.size(); ++i) {
                    Cell cell = new Cell();
                    cell.setText(tableResultItemJson.get(i).toString());
                    cell.setRow(Integer.valueOf(rowIndex));
                    cell.setCol(Integer.valueOf(i));
                    cell.setRowSpan(Integer.valueOf(1));
                    cell.setColSpan(Integer.valueOf(1));
                    table.getCells().add(cell);
                    if (rowIndex != 0) continue;
                    tableTitle = tableTitle + tableResultItemJson.get(i).toString();
                }
            }
            ++rowIndex;
        }
        result.add(table);
        resultMap.put("table", result);
        resultMap.put("tableTitle", tableTitle);
        return resultMap;
    }
}

