/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.ocr;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ocr.OcrTextConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.location.TempLocation;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigOcrResponse;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="ocrSimpleChannelExtractor")
public class OcrSimpleExtractor
extends AbstractChannelExtractor<ConfigOcrResponse, OcrTextConfig> {
    private static final Logger log = LoggerFactory.getLogger(OcrSimpleExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.OCR_SIMPLE.getCode(), GroupLevel3Enum.OCR_SIMPLE.getName(), 1);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.OCR_SIMPLE.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return OcrTextConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.STRING.getKey());
        return list;
    }

    @Override
    public void before(ConfigOcrResponse ocrResponse, OcrTextConfig ocrTextConfig) {
    }

    @Override
    public List<ExtractResult> extract(ConfigOcrResponse ocrResponse, OcrTextConfig ocrTextConfig) {
        List regexes;
        JSONObject textLocation;
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010OcrSimpleExtractor.extract\u3011");
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        if (ocrResponse == null) {
            return result;
        }
        TempLocation location = new TempLocation();
        location.setFileId(ocrResponse.getFileId());
        Object ocrResult = null;
        if (ocrTextConfig != null && ocrTextConfig.getFromTabFlag() != null && ocrTextConfig.getFromTabFlag().equals("2")) {
            ocrResult = ocrResponse.getFullText();
        } else if (ocrResponse.getText() != null && (ocrResult = ocrResponse.getText().get((Object)ocrTextConfig.getElement_name())) != null && (textLocation = ocrResponse.getText().getJSONObject(ocrTextConfig.getElement_name() + "_location")) != null) {
            location.setPageNum(Integer.valueOf(textLocation.getInteger("page_id") + 1));
        }
        if (ocrResult == null) {
            return result;
        }
        if (ocrTextConfig.getFromTabFlag() != null && "1".equals(ocrTextConfig.getFromTabFlag())) {
            regexes = ocrTextConfig.getCell_pattern();
            if (CollUtil.isNotEmpty((Collection)regexes)) {
                for (String regex : regexes) {
                    String matchOne;
                    if (!StringUtils.isNotEmpty((String)regex) || !(ocrResult instanceof String) || StringUtils.isEmpty((String)(matchOne = MatchTextUtil.matchOne((String)regex, (String)ocrResult.toString())))) continue;
                    location.setContext(ocrResult.toString());
                    location.setText(matchOne);
                    result.add(new ExtractResult((Object)matchOne, (Location)location, ReturnTypeEnum.STRING.getKey(), GroupLevel3Enum.OCR_SIMPLE.getCode()));
                    return result;
                }
            } else {
                location.setContext(ocrResult.toString());
                location.setText(ocrResult.toString());
                result.add(new ExtractResult(ocrResult, (Location)location, ReturnTypeEnum.STRING.getKey(), GroupLevel3Enum.OCR_SIMPLE.getCode()));
            }
        } else {
            regexes = ocrTextConfig.getPattern();
            if (CollUtil.isNotEmpty((Collection)regexes)) {
                for (String regex : regexes) {
                    String matchOne;
                    if (!StringUtils.isNotEmpty((String)regex) || !(ocrResult instanceof String) || StringUtils.isEmpty((String)(matchOne = MatchTextUtil.matchOne((String)regex, (String)ocrResult.toString())))) continue;
                    location.setContext(ocrResult.toString());
                    location.setText(matchOne);
                    result.add(new ExtractResult((Object)matchOne, (Location)location, ReturnTypeEnum.STRING.getKey(), GroupLevel3Enum.OCR_SIMPLE.getCode()));
                    return result;
                }
            } else {
                location.setContext(ocrResult.toString());
                location.setText(ocrResult.toString());
                result.add(new ExtractResult(ocrResult, (Location)location, ReturnTypeEnum.STRING.getKey(), GroupLevel3Enum.OCR_SIMPLE.getCode()));
            }
        }
        return result;
    }
}

