/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.ocr;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ocr.OcrSignConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.OcrPageInfo;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.SingleSignInfo;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.location.TempLocation;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigOcrResponse;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="ocrSignChannelExtractor")
public class OcrSignExtractor
extends AbstractChannelExtractor<ConfigOcrResponse, OcrSignConfig> {
    private static final Logger log = LoggerFactory.getLogger(OcrSignExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.OCR_SIGN.getCode(), GroupLevel3Enum.OCR_SIGN.getName(), 2);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.OCR_SIGN.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return OcrSignConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.SING.getKey());
        return list;
    }

    @Override
    public void before(ConfigOcrResponse ocrResponse, OcrSignConfig config) {
    }

    @Override
    public List<ExtractResult> extract(ConfigOcrResponse ocrResponse, OcrSignConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010OcrSignExtractor.extract\u3011");
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        if (ocrResponse == null) {
            return result;
        }
        SingleSignInfo sign = (SingleSignInfo)ocrResponse.getSign().get(config.getElement_name());
        if (sign == null) {
            return result;
        }
        TempLocation location = new TempLocation();
        location.setPageNum(Integer.valueOf(sign.getPage_id() + 1));
        location.setTextBox(sign.getObj_box());
        location.setPageInfo((OcrPageInfo)ocrResponse.getPage_info().get(sign.getPage_id()));
        String resultTxt = JSON.toJSONString((Object)sign);
        location.setContext(resultTxt);
        location.setText(resultTxt);
        location.setFileId(ocrResponse.getFileId());
        result.add(new ExtractResult((Object)sign, (Location)location, ReturnTypeEnum.SING.getKey(), GroupLevel3Enum.OCR_SIGN.getCode()));
        return result;
    }
}

