/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.ocr;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ocr.OcrSignConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.OcrPageInfo;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.location.LocationList;
import com.jxdinfo.idp.extract.domain.location.TempLocation;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigOcrResponse;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="ocrSealListChannelExtractor")
public class OcrSealListExtractor
extends AbstractChannelExtractor<ConfigOcrResponse, OcrSignConfig> {
    private static final Logger log = LoggerFactory.getLogger(OcrSealListExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.OCR_SEAL_LIST.getCode(), GroupLevel3Enum.OCR_SEAL_LIST.getName(), 5);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.OCR_SEAL_LIST.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return OcrSignConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.SEALList.getKey());
        list.add(ReturnTypeEnum.DOUBLE.getKey());
        return list;
    }

    @Override
    public void before(ConfigOcrResponse ocrResponse, OcrSignConfig config) {
    }

    @Override
    public List<ExtractResult> extract(ConfigOcrResponse ocrResponse, OcrSignConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010OcrSimpleExtractor.extract\u3011");
        String returnType = config.getDataType();
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        List<Object> fullSeal = new ArrayList(ocrResponse.getFullSeal());
        int pageCount = ocrResponse.getPage_info().size();
        if (!fullSeal.isEmpty()) {
            if (StringUtils.isNotBlank((CharSequence)config.getDetectPageStr()) && !"0".equals(config.getDetectPageStr())) {
                String[] pageNums = String.valueOf(config.getDetectPageStr()).split(",");
                fullSeal = fullSeal.stream().filter(singleSignInfo -> {
                    for (String pageNum : pageNums) {
                        int page = Integer.parseInt(pageNum);
                        if (page < 0) {
                            page = pageCount + page + 1;
                        }
                        if (singleSignInfo.getPage_id() != page - 1) continue;
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
            }
            if (config.getObjectType() != null && !config.getObjectType().isEmpty()) {
                fullSeal = fullSeal.stream().filter(singleSignInfo -> config.getObjectType().contains(singleSignInfo.getObj_type())).collect(Collectors.toList());
            }
            if (config.getObjectConfidence() != null) {
                fullSeal = fullSeal.stream().filter(singleSignInfo -> singleSignInfo.getScore() >= config.getObjectConfidence()).collect(Collectors.toList());
            }
            if (ReturnTypeEnum.DOUBLE.getKey().equals(returnType)) {
                result.add(new ExtractResult((Object)fullSeal.size(), returnType, this.implCodeDto().getImplCode()));
            } else {
                ArrayList locations = new ArrayList();
                fullSeal.forEach(seal -> {
                    TempLocation location = new TempLocation();
                    location.setPageNum(Integer.valueOf(seal.getPage_id() + 1));
                    location.setTextBox(seal.getObj_box());
                    OcrPageInfo pageInfo = new OcrPageInfo();
                    try {
                        BeanUtil.copyProperties(ocrResponse.getPage_info().get(seal.getPage_id()), (Object)pageInfo, (String[])new String[0]);
                    }
                    catch (Exception e) {
                        log.error("ocr\u5370\u7ae0\u6570\u7ec4\u590d\u5236pageInfo\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                    }
                    location.setPageInfo(pageInfo);
                    String resultTxt = JSON.toJSONString((Object)seal);
                    location.setContext(resultTxt);
                    location.setText(resultTxt);
                    location.setFileId(ocrResponse.getFileId());
                    locations.add(location);
                });
                result.add(new ExtractResult(fullSeal, (Location)new LocationList(locations), ReturnTypeEnum.SEALList.getKey(), this.implCodeDto().getImplCode()));
            }
        } else if (ReturnTypeEnum.DOUBLE.getKey().equals(returnType)) {
            result.add(new ExtractResult((Object)0, returnType, this.implCodeDto().getImplCode()));
        } else {
            result.add(new ExtractResult(new ArrayList(), ReturnTypeEnum.SEALList.getKey(), this.implCodeDto().getImplCode()));
        }
        return result;
    }
}

