/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.llm;

import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.threepartapi.llm.ILLMChatServe;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.nlp.NlpChatConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigDocMarkTemplate;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="mllmChannelExtract")
public class MLLMExtractor
extends AbstractChannelExtractor<List<ConfigDocMarkTemplate>, NlpChatConfig> {
    private static final Logger log = LoggerFactory.getLogger(MLLMExtractor.class);
    @Autowired
    private ILLMChatServe llmChatServe;

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.NLP_CONTRACT_CHAT.getCode(), GroupLevel3Enum.NLP_CONTRACT_CHAT.getName(), 1);
    }

    @Override
    public String belongExtractorImplCode() {
        return "mllm";
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return NlpChatConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.STRING.getKey());
        return list;
    }

    @Override
    public void before(List<ConfigDocMarkTemplate> markTemplates, NlpChatConfig config) {
    }

    @Override
    public List<ExtractResult> extract(List<ConfigDocMarkTemplate> markTemplates, NlpChatConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010MLLMExtractor.extract\u3011");
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        try {
            ArrayList<String> pictures = new ArrayList<String>();
            int pageCount = config.getPageNum() > 0 ? config.getPageNum().intValue() : markTemplates.size();
            pageCount = Math.min(pageCount, markTemplates.size());
            for (int i = 0; i < pageCount; ++i) {
                pictures.add(markTemplates.get(i).getImgBase64());
            }
            String answer = this.llmChatServe.llmChatRecall(pictures, config.getQuestion());
            log.info("\u591a\u6a21\u6001\u5927\u6a21\u578b\u54cd\u5e94\uff1a{}", (Object)answer);
            if (!StringUtils.isEmpty((Object)answer) && !StringUtils.isEmpty((Object)config.getRegex())) {
                List match = MatchTextUtil.match((String)config.getRegex(), (String)answer);
                StringBuilder answerAfter = new StringBuilder();
                for (int i = 0; i < match.size(); ++i) {
                    answerAfter.append((String)match.get(i));
                    if (i == match.size() - 1) continue;
                    answerAfter.append(" ");
                }
                answer = answerAfter.toString();
            }
            result.add(new ExtractResult((Object)answer, ReturnTypeEnum.STRING.getKey(), this.implCodeDto().getImplCode()));
        }
        catch (Exception e) {
            log.error("\u591a\u6a21\u6001\u5927\u6a21\u578b\u63d0\u53d6\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }
}

