/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.llm;

import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.threepartapi.rag.Knowledge;
import com.jxdinfo.idp.common.threepartapi.rag.IKnowledgeBaseServer;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.nlp.NlpOldConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="llmChannelExtract")
public class LLMExtractor
extends AbstractChannelExtractor<Knowledge, NlpOldConfig> {
    private static final Logger log = LoggerFactory.getLogger(LLMExtractor.class);
    @Autowired
    private IKnowledgeBaseServer server;

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.NLP_CONTRACT_RISK.getCode(), GroupLevel3Enum.NLP_CONTRACT_RISK.getName(), 1);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.NLP_CONTRACT_RISK.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return NlpOldConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.STRING.getKey());
        return list;
    }

    @Override
    public void before(Knowledge obj, NlpOldConfig config) {
    }

    @Override
    public List<ExtractResult> extract(Knowledge knowledge, NlpOldConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010LLMExtractor.extract\u3011");
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        Knowledge askKnowledge = new Knowledge();
        BeanUtils.copyProperties((Object)knowledge, (Object)askKnowledge);
        config.knowledge(askKnowledge);
        try {
            askKnowledge.setSystem("\u4f60\u662f\u4e00\u540d\u6587\u6863\u5ba1\u67e5\u4eba\u5458\uff0c\u9700\u8981\u4ece\u6587\u672c\u4e2d\u63d0\u53d6\u5173\u952e\u4fe1\u606f\uff0c\u5e76\u6839\u636e\u8981\u6c42\u8fdb\u884c\u63a8\u7406\u5224\u65ad\uff0c\u7ed9\u51fa\u81ea\u5df1\u7684\u7ed3\u8bba\u3002");
            String answer = this.server.chat(askKnowledge);
            if (!StringUtils.isEmpty((Object)config.getRegex())) {
                List match = MatchTextUtil.match((String)config.getRegex(), (String)answer);
                StringBuilder answerAfter = new StringBuilder();
                for (int i = 0; i < match.size(); ++i) {
                    answerAfter.append((String)match.get(i));
                    if (i == match.size() - 1) continue;
                    answerAfter.append(" ");
                }
                answer = answerAfter.toString();
            }
            result.add(new ExtractResult((Object)answer, ReturnTypeEnum.STRING.getKey(), this.implCodeDto().getImplCode()));
        }
        catch (Exception e) {
            log.error("LLM\u63d0\u53d6\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }
}

