/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.json.JsonPathExtractor;
import com.jxdinfo.idp.extract.core.entity.dto.JsonInfo;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.json.JsonExtractConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="jsonInfoChannelExtractor")
public class JSONExtractor
extends AbstractChannelExtractor<JsonInfo, JsonExtractConfig> {
    private static final Logger log = LoggerFactory.getLogger(JSONExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.JSON_OBJECT.getCode(), GroupLevel3Enum.JSON_OBJECT.getName(), 1);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.JSON_OBJECT.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return JsonExtractConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.OBJECT.getKey());
        return list;
    }

    @Override
    public void before(JsonInfo jsonObject, JsonExtractConfig config) {
    }

    @Override
    public List<ExtractResult> extract(JsonInfo jsonInfo, JsonExtractConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010JSONExtractor.extract\u3011");
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        if (config.getJsonKey() == null || config.getJsonKey().trim().isEmpty()) {
            return result;
        }
        Object jsonObjet = JsonPathExtractor.extractValue((Object)jsonInfo.getJsonObject(), (String)config.getJsonKey());
        log.info("json\u63d0\u53d6\u5668\u3010JSONExtractor.extract\u3011\uff0c\u63d0\u53d6\u5185\u5bb9\uff1a{}", jsonObjet);
        if (jsonObjet != null) {
            result.add(new ExtractResult(jsonObjet, ReturnTypeEnum.OBJECT.getKey(), this.implCodeDto().getImplCode()));
        }
        return result;
    }

    public static Object getNestedValue(JSON info, String jsonKey) {
        String[] keys = jsonKey.split("\\.");
        Object current = info;
        for (String key : keys) {
            if (!(current instanceof JSONObject)) {
                return null;
            }
            current = ((JSONObject)current).get((Object)key);
        }
        return current;
    }
}

