/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.excel;

import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelCellInfo;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelInfo;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelSheetInfo;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.Cell;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.Table;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.excel.ExcelObjectConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.location.ExcelLocationInfo;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.location.TempLocation;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="excelObjectChannelExtractor")
public class ExcelObjectExtractor
extends AbstractChannelExtractor<ExcelInfo, ExcelObjectConfig> {
    private static final Logger log = LoggerFactory.getLogger(ExcelObjectExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.EXCEL_OBJECT.getCode(), GroupLevel3Enum.EXCEL_OBJECT.getName(), 2);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.EXCEL_OBJECT.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return ExcelObjectConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.TABLE.getKey());
        return list;
    }

    @Override
    public void before(ExcelInfo excelInfo, ExcelObjectConfig excelObjectConfig) {
    }

    @Override
    public List<ExtractResult> extract(ExcelInfo excelInfo, ExcelObjectConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010ExcelObjectExtractor.extract\u3011");
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        List sheetInfos = excelInfo.getSheetInfos();
        if (sheetInfos == null || sheetInfos.isEmpty()) {
            log.info("ExcelObjectExtractor\u63d0\u53d6>>sheetInfos\u4e3a\u7a7a");
            return result;
        }
        ExcelSheetInfo targetSheet = null;
        for (ExcelSheetInfo sheetInfo : sheetInfos) {
            if (!MatchTextUtil.isRegMatched((String)config.getSheetName(), (String)sheetInfo.getName())) continue;
            targetSheet = sheetInfo;
            ExcelCellInfo[][] cellArray2D = targetSheet.getCellArray2D();
            int resultSize = result.size();
            String x = "";
            String y = "";
            if (0 == config.getExtractType()) {
                ExcelLocationInfo excelLocationInfo = new ExcelLocationInfo();
                excelLocationInfo.setSheetName(sheetInfo.getName());
                excelLocationInfo.setSheetIndex(sheetInfo.getIndex().intValue());
                TempLocation location = new TempLocation();
                location.setFileId(excelInfo.getFileId());
                location.setExcelLocationInfo(excelLocationInfo);
                result.add(new ExtractResult(this.transTable(cellArray2D), (Location)location, config.getDataType(), GroupLevel3Enum.EXCEL_OBJECT.getCode()));
                continue;
            }
            List<Map<String, Object>> cols = this.getCol(config.getHeadName(), cellArray2D, config.getExtractType());
            String lastx = "";
            String lasty = "";
            if (!cols.isEmpty()) {
                lastx = cols.get(cols.size() - 1).get("x") + "";
                lasty = cols.get(cols.size() - 1).get("y") + "";
            }
            x = cols.get(0).get("x") + "," + lastx;
            y = cols.get(0).get("y") + "," + lasty;
            ExcelLocationInfo excelLocationInfo = new ExcelLocationInfo();
            excelLocationInfo.setSheetName(sheetInfo.getName());
            excelLocationInfo.setSheetIndex(sheetInfo.getIndex().intValue());
            excelLocationInfo.setX(x);
            excelLocationInfo.setY(y);
            excelLocationInfo.setDirection(config.getExtractType() == 1 ? "line" : "column");
            TempLocation location = new TempLocation();
            location.setFileId(excelInfo.getFileId());
            location.setExcelLocationInfo(excelLocationInfo);
            result.add(new ExtractResult(this.transTable(cols), (Location)location, config.getDataType(), GroupLevel3Enum.EXCEL_OBJECT.getCode()));
        }
        return result;
    }

    private List<Object> transTable(ExcelCellInfo[][] cellArray2D) {
        Table table = new Table();
        table.setCells(new ArrayList());
        for (int y = 0; y < cellArray2D.length; ++y) {
            for (int x = 0; x < cellArray2D[y].length; ++x) {
                ExcelCellInfo cellInfo = cellArray2D[y][x];
                if (cellInfo == null) continue;
                Cell cell = new Cell();
                cell.setCol(Integer.valueOf(x));
                cell.setRow(Integer.valueOf(y));
                cell.setRowSpan(Integer.valueOf(1));
                cell.setColSpan(Integer.valueOf(1));
                cell.setText(cellInfo.getValueStr());
                table.getCells().add(cell);
            }
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(table);
        return list;
    }

    private List<Object> transTable(List<Map<String, Object>> cols) {
        Table table = new Table();
        table.setCells(new ArrayList());
        AtomicReference<Integer> targetY = new AtomicReference<Integer>(0);
        cols.forEach(col -> {
            Cell cell = new Cell();
            cell.setCol(Integer.valueOf(0));
            cell.setRowSpan(Integer.valueOf(1));
            cell.setColSpan(Integer.valueOf(1));
            cell.setRow(targetY.getAndSet((Integer)targetY.get() + 1));
            cell.setText(col.get("value") + "");
            table.getCells().add(cell);
        });
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(table);
        return list;
    }

    private List<Map<String, Object>> getCol(String headName, ExcelCellInfo[][] cellArray2D, int type) {
        ArrayList<Map<String, Object>> result;
        block6: {
            ExcelCellInfo cellInfo;
            Integer targetY = null;
            Integer targetX = null;
            block0: for (int y = 0; y < cellArray2D.length; ++y) {
                if (cellArray2D[y] == null) continue;
                for (int x = 0; x < cellArray2D[y].length; ++x) {
                    cellInfo = cellArray2D[y][x];
                    if (cellInfo == null || !MatchTextUtil.isRegMatched((String)headName, (String)cellInfo.getValueStr())) continue;
                    targetY = y;
                    targetX = x;
                    break block0;
                }
            }
            result = new ArrayList<Map<String, Object>>();
            if (targetY == null) break block6;
            if (1 == type) {
                ExcelCellInfo[] cellArray = cellArray2D[targetY];
                for (int x = targetX + 1; x < cellArray.length; ++x) {
                    ExcelCellInfo cellInfo2 = cellArray[x];
                    if (cellInfo2 == null) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("value", cellInfo2.getValue());
                    map.put("x", x);
                    map.put("y", targetY);
                    result.add(map);
                }
            } else {
                for (int y = targetY + 1; y < cellArray2D.length; ++y) {
                    if (cellArray2D[y] == null || cellArray2D[y][targetX] == null || (cellInfo = cellArray2D[y][targetX]) == null) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("value", cellInfo.getValue());
                    map.put("x", targetX);
                    map.put("y", y);
                    result.add(map);
                }
            }
        }
        return result;
    }
}

