/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel.excel;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelCellInfo;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelInfo;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelSheetInfo;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.core.extractor.channel.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.excel.ExcelBasicTypeConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import com.jxdinfo.idp.extract.domain.location.ExcelLocationInfo;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.domain.location.TempLocation;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="excelBasicTypeChannelExtractor")
public class ExcelBasicTypeExtractor
extends AbstractChannelExtractor<ExcelInfo, ExcelBasicTypeConfig> {
    private static final Logger log = LoggerFactory.getLogger(ExcelBasicTypeExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.EXCEL_BASIC_TYPE.getCode(), GroupLevel3Enum.EXCEL_BASIC_TYPE.getName(), 1);
    }

    @Override
    public String belongExtractorImplCode() {
        return GroupLevel3Enum.EXCEL_BASIC_TYPE.getLevel2Enum().getCode();
    }

    @Override
    public Class<? extends ExtractConfig> getConfigClass() {
        return ExcelBasicTypeConfig.class;
    }

    @Override
    public List<String> supportDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReturnTypeEnum.STRING.getKey());
        return list;
    }

    @Override
    public void before(ExcelInfo excelInfo, ExcelBasicTypeConfig excelBasicTypeConfig) {
    }

    @Override
    public List<ExtractResult> extract(ExcelInfo excelInfo, ExcelBasicTypeConfig config) {
        log.info("\u63d0\u53d6>>\u8fdb\u5165\u3010ExcelBasicTypeExtractor.extract\u3011");
        List sheetInfos = excelInfo.getSheetInfos();
        if (config.getSheetName() == null && config.getSheetIndex() == null) {
            return this.extractFromSheets(sheetInfos, config, excelInfo.getFileId());
        }
        List<ExcelSheetInfo> targetSheetInfos = sheetInfos.stream().filter(sheetInfo -> MatchTextUtil.isRegMatched((String)config.getSheetName(), (String)sheetInfo.getName())).collect(Collectors.toList());
        return this.extractFromSheets(targetSheetInfos, config, excelInfo.getFileId());
    }

    private List<ExtractResult> extractFromSheets(List<ExcelSheetInfo> sheetInfos, ExcelBasicTypeConfig config, Long fileId) {
        ArrayList<ExtractResult> result = new ArrayList<ExtractResult>();
        if (StringUtils.isEmpty((Object)config.getBasicText())) {
            return result;
        }
        for (ExcelSheetInfo sheetInfo : sheetInfos) {
            ExcelCellInfo[][] cellArray2D = sheetInfo.getCellArray2D();
            for (int y = 0; y < cellArray2D.length; ++y) {
                ExcelCellInfo[] cellArray = cellArray2D[y];
                if (cellArray == null) continue;
                for (int x = 0; x < cellArray.length; ++x) {
                    ExcelCellInfo cellInfo = cellArray[x];
                    if (cellInfo == null || cellInfo.getValue() == null || !MatchTextUtil.isRegMatched((String)config.getBasicText(), (String)cellInfo.getValueStr())) continue;
                    try {
                        int newY;
                        int newX = x + config.getXOffset();
                        if (newX < 0 || newX >= cellArray2D[0].length || (newY = y + config.getYOffset()) < 0 || newY >= cellArray2D.length) continue;
                        ExcelCellInfo target = cellArray2D[newY][newX];
                        List<Object> match = this.match(config.getRegex(), target.getValue());
                        if (CollUtil.isEmpty(match)) continue;
                        match.forEach(matchObj -> {
                            ExcelLocationInfo excelLocationInfo = new ExcelLocationInfo();
                            excelLocationInfo.setSheetName(sheetInfo.getName());
                            excelLocationInfo.setSheetIndex(sheetInfo.getIndex().intValue());
                            excelLocationInfo.setX(newX + "," + newX);
                            excelLocationInfo.setY(newY + "," + newY);
                            TempLocation location = new TempLocation("", matchObj.toString());
                            location.setFileId(fileId);
                            location.setExcelLocationInfo(excelLocationInfo);
                            ExtractResult matchResult = new ExtractResult(matchObj, (Location)location, ReturnTypeEnum.STRING.getKey(), this.implCodeDto().getImplCode());
                            result.add(matchResult);
                        });
                        continue;
                    }
                    catch (Exception e) {
                        log.error("excel\u6587\u672c\u63d0\u53d6\u5931\u8d25ExcelBasicTypeExtractor.extract\uff1a" + e.getMessage());
                    }
                }
            }
        }
        return result;
    }
}

