/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.extractor.channel;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.extract.core.afterhandler.DataHandlerManager;
import com.jxdinfo.idp.extract.core.api.IChannelExtractor;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractResult;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractChannelExtractor<E, K extends ExtractConfig>
implements IChannelExtractor<E, K> {
    @Override
    public ExtractResult execute(E initInfo, K extractConfig) {
        this.before(initInfo, extractConfig);
        return this.after(this.extract(initInfo, extractConfig), extractConfig);
    }

    protected List<Object> match(String regex, Object text) {
        ArrayList<Object> result = new ArrayList<Object>();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text.toString());
        if (StringUtils.isEmpty((CharSequence)regex)) {
            result.add(text);
            return result;
        }
        while (matcher.find()) {
            int groupCount = matcher.groupCount();
            if (groupCount == 0) {
                result.add(matcher.group());
                continue;
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 1; i <= groupCount; ++i) {
                if (matcher.group(i) == null) continue;
                builder.append(matcher.group(i));
                if (i >= groupCount) continue;
                builder.append("\t");
            }
            if (!StringUtils.isNotEmpty((CharSequence)builder.toString())) continue;
            result.add(builder.toString());
        }
        return result;
    }

    public ExtractResult after(List<ExtractResult> list, K config) {
        ExtractResult result = this.getResultByMatchStrategy(list, config);
        if (result != null) {
            result.setResult(this.afterHandler(result.getResult(), config));
        }
        return result;
    }

    public Object afterHandler(Object data, K config) {
        return DataHandlerManager.handle(data, config.getHandlerConfig());
    }

    public ExtractResult getResultByMatchStrategy(List<ExtractResult> list, K config) {
        ExtractResult result = null;
        if (CollUtil.isNotEmpty(list)) {
            result = 1 == config.getMatchStrategy() ? list.get(list.size() - 1) : list.get(0);
        }
        return result;
    }
}

