/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core.afterhandler;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.extract.core.afterhandler.IDataHandler;
import com.jxdinfo.idp.extract.domain.afterhandle.HandlerConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataHandlerManager {
    private static final Logger log = LoggerFactory.getLogger(DataHandlerManager.class);
    private static Map<String, IDataHandler> dataHandlerMap = new HashMap<String, IDataHandler>();
    private static List<IDataHandler> dataHandlers = new ArrayList<IDataHandler>();

    public static void register(IDataHandler dataHandler) {
        dataHandlerMap.put(dataHandler.getInterfaceCode(), dataHandler);
        dataHandlers.add(dataHandler);
    }

    public static IDataHandler get(String interfaceCode) {
        return dataHandlerMap.get(interfaceCode);
    }

    public static List<Map<String, Object>> getHandlerList() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List sorted = dataHandlers.stream().sorted(Comparator.comparing(IDataHandler::getInterfaceName)).sorted(Comparator.comparing(IDataHandler::sortNum, Comparator.reverseOrder())).collect(Collectors.toList());
        for (IDataHandler dataHandler : sorted) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("interfaceName", dataHandler.getInterfaceName());
            map.put("interfaceCode", dataHandler.getInterfaceCode());
            map.put("supportTypes", dataHandler.getSupportTypes());
            map.put("paramInfo", dataHandler.getParamInfo());
            list.add(map);
        }
        return list;
    }

    public static Object handle(Object data, HandlerConfig config) {
        if (data == null || config == null || StringUtils.isBlank((CharSequence)config.getInterfaceCode()) || StringUtils.isBlank((CharSequence)config.getConfig())) {
            return data;
        }
        IDataHandler dataHandler = DataHandlerManager.get(config.getInterfaceCode());
        if (dataHandler != null) {
            try {
                Object newConfig = JSON.parseObject((String)config.getConfig(), dataHandler.getConfigClass());
                return dataHandler.handle(data, (HandlerConfig)newConfig);
            }
            catch (Exception e) {
                log.info("\u540e\u5904\u7406\u6267\u884c\u5931\u8d25\uff1a{}", (Object)config.getConfig(), (Object)e);
            }
        }
        return data;
    }
}

