/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.core;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.extract.core.api.IExtractor;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.GroupLevel;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExtractorActuator
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ExtractorActuator.class);
    private final Map<String, IExtractor> EXTRACTOR_MAP = new LinkedHashMap<String, IExtractor>();
    @Autowired(required=false)
    private List<IExtractor> extractorList;

    public void afterPropertiesSet() {
        if (CollUtil.isNotEmpty(this.extractorList)) {
            List extractors = this.extractorList.stream().sorted(Comparator.comparingInt(o -> o.implCodeDto().getSortNum())).collect(Collectors.toList());
            for (IExtractor extractor : extractors) {
                this.EXTRACTOR_MAP.put(extractor.implCodeDto().getImplCode(), extractor);
                log.info("\u6ce8\u518c\u63d0\u53d6\u6267\u884c\u5668\uff1a{}", (Object)extractor.implCodeDto().getImplName());
            }
        }
    }

    public List<GroupLevel> getExtractorList() {
        ArrayList<GroupLevel> list = new ArrayList<GroupLevel>();
        this.EXTRACTOR_MAP.forEach((methodExtractorImplCode, extractor) -> {
            GroupLevel groupLevel = new GroupLevel(extractor.implCodeDto().getImplCode(), extractor.implCodeDto().getImplName());
            groupLevel.setChildren(extractor.getExtractorList());
            list.add(groupLevel);
        });
        return list;
    }

    public List<ExtractRecord> execute(List<ExtractItemDto> itemList, Object info) {
        ArrayList result = new ArrayList();
        this.EXTRACTOR_MAP.forEach((methodExtractorImplCode, extractor) -> {
            List<ExtractItemDto> extractItemDtos = itemList.stream().filter(item -> item.getTypeInfoList().stream().anyMatch(typeInfo -> typeInfo.getType().equals(methodExtractorImplCode))).collect(Collectors.toList());
            extractItemDtos = extractItemDtos.stream().filter(item -> result.stream().noneMatch(extractRecord -> extractRecord.getExtractItemId().equals(item.getId()))).collect(Collectors.toList());
            try {
                if (extractor.supportInputParam(info) && !extractItemDtos.isEmpty()) {
                    result.addAll(extractor.execute(extractItemDtos, info));
                }
            }
            catch (Exception e) {
                log.error("{}\u6267\u884c\u63d0\u53d6\u5668\u5f02\u5e38\uff1a", (Object)extractor.implCodeDto().getImplCode(), (Object)e);
            }
        });
        Map<Long, List<ExtractRecord>> extractResult = result.stream().collect(Collectors.groupingBy(ExtractRecord::getExtractItemId));
        extractResult.forEach((extractItemId, extractRecordList) -> {
            if (extractRecordList.size() > 1) {
                for (int i = extractRecordList.size() - 1; i >= 0; --i) {
                    ExtractRecord extractRecord = (ExtractRecord)extractRecordList.get(i);
                    if (extractRecordList.size() <= 1 || !StringUtils.isBlank((CharSequence)extractRecord.getResult()) && !"\"\"".equals(extractRecord.getResult()) && extractRecord.getResultObject() != null && (!(extractRecord.getResultObject() instanceof List) || !CollUtil.isEmpty((Collection)((List)extractRecord.getResultObject())))) continue;
                    extractRecordList.remove(i);
                }
            }
        });
        List<ExtractRecord> itemResult = extractResult.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (result.size() != itemList.size()) {
            itemList.forEach(item -> {
                if (extractResult.get(item.getId()) == null) {
                    ExtractRecord empty = new ExtractRecord();
                    empty.setExtractItemId(item.getId());
                    empty.setItemName(item.getName());
                    if (ReturnTypeEnum.STRING.getKey().equals(item.getReturnType())) {
                        if (StringUtils.isNotBlank((CharSequence)item.getExceptionValue())) {
                            empty.setResult(item.getExceptionValue());
                            empty.setResultObject((Object)item.getExceptionValue());
                        } else {
                            empty.setResult("");
                            empty.setResultObject((Object)"");
                        }
                    } else {
                        empty.setResult(null);
                        empty.setResultObject(null);
                    }
                    itemResult.add(empty);
                }
            });
        }
        return itemResult;
    }
}

