/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ThreadPoolUtil {
    @Value(value="${nlp.nThreads:5}")
    private int nThreads;
    private static ThreadPoolUtil INSTANCE;
    private ExecutorService executorService;

    public ThreadPoolUtil() {
    }

    private ThreadPoolUtil(int nThreads) {
        this.executorService = Executors.newFixedThreadPool(nThreads, new CustomThreadFactory());
    }

    @PostConstruct
    private void init() {
        INSTANCE = new ThreadPoolUtil(this.nThreads);
    }

    public static ThreadPoolUtil getInstance() {
        return INSTANCE;
    }

    public void execute(Runnable task) {
        this.executorService.execute(task);
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public static void main(String[] args) {
        ThreadPoolUtil threadPoolUtil = ThreadPoolUtil.getInstance();
        int i = 0;
        while (i < 10) {
            int taskId = i++;
            threadPoolUtil.execute(() -> {
                System.out.println(Thread.currentThread().getName() + " is executing task " + taskId);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
        }
        threadPoolUtil.shutdown();
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        private CustomThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "CustomThreadPool-Thread-" + this.threadNumber.getAndIncrement());
            thread.setDaemon(false);
            return thread;
        }
    }
}

