/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.domain.extractor;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.extract.domain.location.Location;
import java.util.ArrayList;
import java.util.List;

public class ExtractorCarrier<O> {
    private Long categoryId;
    private List<O> data;
    private List<Location> locations;
    private List<JSONObject> jsonList;

    public ExtractorCarrier() {
        this.locations = new ArrayList<Location>();
        this.jsonList = new ArrayList<JSONObject>();
    }

    public ExtractorCarrier(List<O> data) {
        this.data = data;
    }

    public ExtractorCarrier(Long categoryId, List<O> data, List<Location> locations) {
        this.categoryId = categoryId;
        this.data = data;
        this.locations = locations;
        this.jsonList = new ArrayList<JSONObject>();
        for (O o : data) {
            JSONObject jsonObject;
            if (o instanceof String) {
                jsonObject = new JSONObject();
                jsonObject.put("value", o);
            } else {
                jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(o));
            }
            this.jsonList.add(jsonObject);
        }
    }

    public ExtractorCarrier<O> toJsonList() {
        for (O o : this.data) {
            JSONObject jsonObject;
            if (o instanceof String) {
                jsonObject = new JSONObject();
                jsonObject.put("value", o);
            } else {
                jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(o));
            }
            this.jsonList.add(jsonObject);
        }
        return this;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public List<O> getData() {
        return this.data;
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public List<JSONObject> getJsonList() {
        return this.jsonList;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public void setData(List<O> data) {
        this.data = data;
    }

    public void setLocations(List<Location> locations) {
        this.locations = locations;
    }

    public void setJsonList(List<JSONObject> jsonList) {
        this.jsonList = jsonList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtractorCarrier)) {
            return false;
        }
        ExtractorCarrier other = (ExtractorCarrier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$categoryId = this.getCategoryId();
        Long other$categoryId = other.getCategoryId();
        if (this$categoryId == null ? other$categoryId != null : !((Object)this$categoryId).equals(other$categoryId)) {
            return false;
        }
        List<O> this$data = this.getData();
        List<O> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        List<Location> this$locations = this.getLocations();
        List<Location> other$locations = other.getLocations();
        if (this$locations == null ? other$locations != null : !((Object)this$locations).equals(other$locations)) {
            return false;
        }
        List<JSONObject> this$jsonList = this.getJsonList();
        List<JSONObject> other$jsonList = other.getJsonList();
        return !(this$jsonList == null ? other$jsonList != null : !((Object)this$jsonList).equals(other$jsonList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExtractorCarrier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $categoryId = this.getCategoryId();
        result = result * 59 + ($categoryId == null ? 43 : ((Object)$categoryId).hashCode());
        List<O> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        List<Location> $locations = this.getLocations();
        result = result * 59 + ($locations == null ? 43 : ((Object)$locations).hashCode());
        List<JSONObject> $jsonList = this.getJsonList();
        result = result * 59 + ($jsonList == null ? 43 : ((Object)$jsonList).hashCode());
        return result;
    }

    public String toString() {
        return "ExtractorCarrier(categoryId=" + this.getCategoryId() + ", data=" + this.getData() + ", locations=" + this.getLocations() + ", jsonList=" + this.getJsonList() + ")";
    }

    public ExtractorCarrier(Long categoryId, List<O> data, List<Location> locations, List<JSONObject> jsonList) {
        this.categoryId = categoryId;
        this.data = data;
        this.locations = locations;
        this.jsonList = jsonList;
    }
}

