/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.enums;

import java.util.Arrays;

public enum ExtractorEnum {
    FILE_BYTES_INFO("fileBytesInfo", "\u6587\u4ef6\u6d41", null, null),
    NULL("null", "null", null, null),
    FILE_INFO("fileInfo", "\u6587\u4ef6\u4fe1\u606f", 1L, FILE_BYTES_INFO),
    WORD_INFO("wordInfo", "Word\u4fe1\u606f", 10000L, FILE_BYTES_INFO),
    WORD_CHAPTER("wordChapter", "\u7ae0\u8282", 11000L, WORD_INFO),
    WORD_TABLE("wordTable", "\u8868\u683c", 12000L, WORD_INFO),
    WORD_PARA("wordPara", "\u6bb5\u843d", 13000L, WORD_INFO),
    WORD_TEXT_FROM_PARA("wordTextFromPara", "\u6587\u672c", 14000L, WORD_PARA),
    EXCEL_INFO("excel_info", "Excel\u4fe1\u606f", 20000L, FILE_BYTES_INFO),
    EXCEL_SHEET("excel_sheet", "sheet\u4fe1\u606f", 21000L, EXCEL_INFO),
    EXCEL_TEXT("excel_text", "\u6587\u672c", 21100L, EXCEL_SHEET),
    OCR_INFO("ocr_info", "PDF\u4fe1\u606f", null, FILE_BYTES_INFO),
    OCR_PARA("ocr_para", "\u6bb5\u843d", null, OCR_INFO),
    OCR_TABLE("ocr_table", "\u8868\u683c", null, OCR_INFO),
    OCR_TEXT("ocr_TEXT", "\u6587\u672c", null, OCR_PARA),
    DATASOURCE("datasource_extract", "\u6570\u636e\u6e90", 30000L, NULL),
    API("api_extract", "API", 40000L, NULL),
    NlP("nlp_extract", "\u81ea\u7136\u8bed\u8a00\u8bc6\u522b", 50000L, FILE_BYTES_INFO),
    OCR_TEXT_OLD("ocr_text_old", "\u6587\u672c", -70000L, OCR_PARA),
    OCR_SEAL_OLD("ocr_seal_old", "\u5370\u7ae0", -70001L, OCR_PARA),
    OCR_SIGN_OLD("ocr_sign_old", "\u7b7e\u5b57", -70002L, OCR_PARA);

    private final String code;
    private final String name;
    private final Long categoryId;
    private final ExtractorEnum input;

    public static ExtractorEnum getByCode(String code) {
        return Arrays.stream(ExtractorEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(null);
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public ExtractorEnum getInput() {
        return this.input;
    }

    private ExtractorEnum(String code, String name, Long categoryId, ExtractorEnum input) {
        this.code = code;
        this.name = name;
        this.categoryId = categoryId;
        this.input = input;
    }
}

