/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckTemplateProject;
import com.jxdinfo.idp.icpac.mapper.DuplicateCheckTemplateProjectMapper;
import com.jxdinfo.idp.icpac.service.DuplicateCheckTemplateProjectService;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DuplicateCheckTemplateProjectServiceImpl
extends ServiceImpl<DuplicateCheckTemplateProjectMapper, DuplicateCheckTemplateProject>
implements DuplicateCheckTemplateProjectService {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckTemplateProjectServiceImpl.class);
    @Resource
    private DuplicateCheckTemplateProjectMapper mapper;

    @Override
    public DuplicateCheckTemplateProject insert(DuplicateCheckTemplateProject duplicateCheckTemplateProject) {
        if (duplicateCheckTemplateProject == null) {
            throw new IllegalArgumentException("duplicateCheckTemplateProject is null");
        }
        String projectId = duplicateCheckTemplateProject.getProjectId();
        if (StringUtils.isEmpty((String)projectId)) {
            throw new IllegalArgumentException("\u67e5\u91cd\u6a21\u7248\u5e93\uff0c\u5173\u8054\u7684projectId is null");
        }
        long id = SnowFlakeUtil.getFlowIdInstance().nextId();
        duplicateCheckTemplateProject.setId(String.valueOf(id));
        duplicateCheckTemplateProject.setIsUse("1");
        duplicateCheckTemplateProject.setCreateTime(LocalDateTime.now());
        this.save(duplicateCheckTemplateProject);
        return duplicateCheckTemplateProject;
    }

    @Override
    public DuplicateCheckTemplateProject getTemplateLibraryByProjectId(String projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DuplicateCheckTemplateProject::getProjectId, (Object)projectId);
        List templateProjectList = this.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)templateProjectList)) {
            log.warn("\u67e5\u91cd\u6a21\u7248\u5e93\uff0c\u5173\u8054\u7684projectId:{} \u4e0d\u5b58\u5728", (Object)projectId);
            return null;
        }
        if (templateProjectList.size() > 1) {
            log.warn("\u67e5\u91cd\u6a21\u7248\u5e93\uff0c\u5173\u8054\u7684projectId:{} \u4e0d\u552f\u4e00", (Object)projectId);
        }
        return (DuplicateCheckTemplateProject)templateProjectList.get(0);
    }
}

