/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.dio.service.DocInfoIoService;
import com.jxdinfo.idp.duplicatecheck.api.call.DuplicatecheckOverInterface;
import com.jxdinfo.idp.duplicatecheck.api.call.DuplicatecheckProduceInterface;
import com.jxdinfo.idp.duplicatecheck.api.call.DuplicatecheckThirdInterface;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocumentGroup;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckIgnoreLibraryDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckProjectDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckDoc;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckIgnoreLibrary;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckProject;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckTemplateDoc;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckTemplateProject;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckGroupInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckTask;
import com.jxdinfo.idp.icpac.core.executor.task.DuplicateCheckTaskGroupExecutor;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckResultHandler;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckOperationEnum;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckUpdateModelEnum;
import com.jxdinfo.idp.icpac.custom.resulthandler.DefaultResultHandler;
import com.jxdinfo.idp.icpac.custom.resulthandler.IgnoreResultHandler;
import com.jxdinfo.idp.icpac.custom.resulthandler.NotifyResultHandler;
import com.jxdinfo.idp.icpac.custom.resulthandler.TemplateDocumentResultHandler;
import com.jxdinfo.idp.icpac.custom.sentencehandler.SentenceHandlerManagement;
import com.jxdinfo.idp.icpac.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckExecutorService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckProjectService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckTemplateDocService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckTemplateProjectService;
import com.jxdinfo.idp.icpac.utils.DuplicateCheckProgress;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DuplicateCheckExecutorServiceImpl
implements DuplicateCheckExecutorService {
    @Resource
    private DuplicateCheckDocService docService;
    private List<DuplicatecheckOverInterface> censorOverInterfaces;
    @Resource
    private DuplicateCheckProjectService projectService;
    @Resource
    private DuplicateCheckTemplateProjectService templateProjectService;
    @Resource
    private DuplicateCheckTemplateDocService templateDocService;
    @Resource
    private DocInfoIoService ioService;

    private DuplicateCheckInfo prepareCheckDuplicate(String documentId) {
        return this.prepareCheckDuplicate(documentId, null);
    }

    public DuplicateCheckExecutorServiceImpl() {
        Map overInterfaceMap = SpringUtil.getBeansOfType(DuplicatecheckOverInterface.class);
        if (overInterfaceMap == null) {
            return;
        }
        this.censorOverInterfaces = new ArrayList(overInterfaceMap.values());
    }

    private DuplicateCheckInfo prepareCheckDuplicate(String documentId, DuplicateCheckResultHandler resultHandler) {
        if (StringUtils.isEmpty((CharSequence)documentId)) {
            throw new RuntimeException("\u6ca1\u6709\u7ed9\u5b9adocId\uff0c\u65e0\u6cd5\u9884\u652f\u6267\u884c\u67d0\u4e2a\u67e5\u91cd");
        }
        DuplicateCheckProgress.setProgress(documentId, 0);
        DuplicateCheckDocDto docInfo = this.docService.simpleDetail(documentId);
        FileBytesInfo fileBytesInfo = this.ioService.getFileBytesInfo(docInfo.getFileId());
        String fileName = fileBytesInfo.getFileName() + "." + fileBytesInfo.getFileFormat();
        MockMultipartFile file = new MockMultipartFile(fileName, fileName, null, fileBytesInfo.getFileBytes());
        DuplicateCheckProjectDto projectDto = this.projectService.detailWithConfigInfo(docInfo.getProjectId());
        String taskStatus = docInfo.getTaskStatus();
        String updateLib = docInfo.getUpdateLib();
        if (Objects.equals(taskStatus, "1")) {
            updateLib = DuplicateCheckUpdateModelEnum.NO_UPDATE.getFlag();
        }
        DuplicateCheckUpdateModelEnum updateModel = DuplicateCheckUpdateModelEnum.getUpdateModel(updateLib);
        if (resultHandler == null) {
            if (updateModel == DuplicateCheckUpdateModelEnum.NO_UPDATE || updateModel == DuplicateCheckUpdateModelEnum.CHECK_UPDATE) {
                resultHandler = new DefaultResultHandler(this.docService);
            } else if (updateModel == DuplicateCheckUpdateModelEnum.NO_CHECK_UPDATE) {
                resultHandler = new NotifyResultHandler(this.docService);
            } else {
                throw new RuntimeException("\u6839\u636eupdateLib\u672a\u627e\u5230\u5408\u9002\u7684\u7c7b\u53bb\u89e3\u51b3\u8be5\u95ee\u9898");
            }
        }
        DuplicateCheckTemplateProject templateProject = this.templateProjectService.getTemplateLibraryByProjectId(projectDto.getId());
        String templateProjectId = "";
        if (templateProject != null && Objects.equals(templateProject.getIsUse(), "1")) {
            templateProjectId = String.valueOf(templateProject.getId());
        }
        DuplicateCheckInfo checkInfo = new DuplicateCheckInfo(documentId, projectDto.getId(), (MultipartFile)file, updateLib, projectDto.getSimilarityBounds(), projectDto.getWordLength(), projectDto.getTableWordLength(), SentenceHandlerManagement.get((MultipartFile)file), resultHandler, templateProjectId);
        checkInfo.addAttachment("chapterConfig", projectDto.getChapterList());
        if (Objects.equals(taskStatus, "2")) {
            checkInfo.setMaybeExist(true);
        }
        return checkInfo;
    }

    @Override
    public void asyncCheckDuplicate(DuplicateCheckDocDto docInfo) {
        DuplicateCheckInfo duplicateCheckInfo = this.prepareCheckDuplicate(docInfo.getId());
        DuplicateCheckGroupInfo checkInfoGroup = new DuplicateCheckGroupInfo(IdUtil.simpleUUID(), Arrays.asList(duplicateCheckInfo), new ArrayList<String>(), DuplicateCheckOperationEnum.CHECK);
        DuplicateCheckTask checkTask = new DuplicateCheckTask(checkInfoGroup, false);
        DuplicateCheckTaskGroupExecutor taskGroup = new DuplicateCheckTaskGroupExecutor(checkTask);
        taskGroup.call();
    }

    @Override
    public void syncCheckDuplicate(DuplicateCheckDocDto docInfo) {
        DuplicateCheckInfo duplicateCheckInfo = this.prepareCheckDuplicate(docInfo.getId());
        DuplicateCheckGroupInfo checkInfoGroup = new DuplicateCheckGroupInfo(IdUtil.simpleUUID(), Arrays.asList(duplicateCheckInfo), new ArrayList<String>(), DuplicateCheckOperationEnum.CHECK);
        DuplicateCheckTask checkTask = new DuplicateCheckTask(checkInfoGroup, true);
        DuplicateCheckTaskGroupExecutor taskGroup = new DuplicateCheckTaskGroupExecutor(checkTask);
        taskGroup.call();
    }

    @Override
    public void batchCheckDuplicate(List<DuplicateCheckDocumentGroup> documentGroupList, Boolean immediate) throws Exception {
        String projectId = "";
        ArrayList<DuplicateCheckGroupInfo> infoGroupList = new ArrayList<DuplicateCheckGroupInfo>();
        for (DuplicateCheckDocumentGroup documentGroup : documentGroupList) {
            ArrayList<DuplicateCheckInfo> infoList = new ArrayList<DuplicateCheckInfo>();
            DuplicateCheckGroupInfo infoGroup = new DuplicateCheckGroupInfo();
            infoGroup.setExcludeDocumentIdList(documentGroup.getExcludeDocumentIdList());
            for (String documentId : documentGroup.getDocumentIdList()) {
                DuplicateCheckInfo checkInfo = this.prepareCheckDuplicate(documentId);
                checkInfo.setSegmentation(documentGroup.isSegmentation());
                if (Objects.equals(projectId, "")) {
                    projectId = checkInfo.getLibId();
                }
                infoList.add(checkInfo);
            }
            infoGroupList.add(new DuplicateCheckGroupInfo(documentGroup.getGroupId(), infoList, documentGroup.getExcludeDocumentIdList(), DuplicateCheckOperationEnum.CHECK));
        }
        List<DuplicatecheckOverInterface> duplicatecheckOverInterfaces = this.getCallback(projectId);
        DuplicateCheckTask checkTask = new DuplicateCheckTask(infoGroupList, immediate, duplicatecheckOverInterfaces);
        DuplicateCheckTaskGroupExecutor duplicateCheckTaskGroupExecutor = new DuplicateCheckTaskGroupExecutor(checkTask);
        duplicateCheckTaskGroupExecutor.call();
    }

    private List<DuplicatecheckOverInterface> getCallback(String projectId) {
        ArrayList<DuplicatecheckOverInterface> callbackList;
        block3: {
            String libResource;
            block2: {
                DuplicateCheckProjectDto projectDto = this.projectService.detail(projectId);
                libResource = projectDto.getLibResource();
                callbackList = new ArrayList<DuplicatecheckOverInterface>();
                if (!Objects.equals(libResource, "0")) break block2;
                for (DuplicatecheckOverInterface censorOverInterface : this.censorOverInterfaces) {
                    if (!(censorOverInterface instanceof DuplicatecheckProduceInterface)) continue;
                    callbackList.add(censorOverInterface);
                }
                break block3;
            }
            if (!Objects.equals(libResource, "1")) break block3;
            for (DuplicatecheckOverInterface censorOverInterface : this.censorOverInterfaces) {
                if (!(censorOverInterface instanceof DuplicatecheckThirdInterface)) continue;
                callbackList.add(censorOverInterface);
            }
        }
        return callbackList;
    }

    @Override
    public void addIgnoreSentence(DuplicateCheckIgnoreLibraryDto ignoreLibrary, DuplicateCheckResultHandler resultHandler) {
        DuplicateCheckInfo info = new DuplicateCheckInfo("mn_checkId", ignoreLibrary.getProjectId());
        info.addAttachment("sentence", ignoreLibrary.getSentence());
        info.addAttachment("sentenceId", ignoreLibrary.getSentenceId());
        info.setResultHandler(resultHandler);
        DuplicateCheckGroupInfo checkInfoGroup = new DuplicateCheckGroupInfo(Collections.singletonList(info), DuplicateCheckOperationEnum.IGNORE);
        DuplicateCheckTask duplicateCheckTask = new DuplicateCheckTask(checkInfoGroup, false);
        DuplicateCheckTaskGroupExecutor taskGroupExecutor = new DuplicateCheckTaskGroupExecutor(duplicateCheckTask);
        taskGroupExecutor.call();
    }

    @Override
    public void cancelIgnoreSentence(DuplicateCheckIgnoreLibrary ignoreLibrary, IgnoreResultHandler ignoreResultHandler) {
        DuplicateCheckInfo info = new DuplicateCheckInfo("mn_checkId", ignoreLibrary.getProjectId());
        info.addAttachment("aiTextId", ignoreLibrary.getAiTextId());
        DuplicateCheckGroupInfo checkInfoGroup = new DuplicateCheckGroupInfo(Collections.singletonList(info), DuplicateCheckOperationEnum.CANCEL_IGNORE);
        DuplicateCheckTask duplicateCheckTask = new DuplicateCheckTask(checkInfoGroup, false);
        DuplicateCheckTaskGroupExecutor taskGroupExecutor = new DuplicateCheckTaskGroupExecutor(duplicateCheckTask);
        taskGroupExecutor.call();
    }

    @Override
    public void deleteDocument(List<? extends DuplicateCheckDoc> documentInfoList) {
        HashMap<String, List<String>> proIdWithDocIdCollection = new HashMap<String, List<String>>();
        for (DuplicateCheckDoc duplicateCheckDoc : documentInfoList) {
            String projectId = duplicateCheckDoc.getProjectId();
            proIdWithDocIdCollection.computeIfAbsent(projectId, k -> new ArrayList()).add(duplicateCheckDoc.getId());
        }
        this.deleteCheckLibOfDocument(proIdWithDocIdCollection);
    }

    private void deleteCheckLibOfDocument(Map<String, List<String>> proIdWithDocIdCollection) {
        ArrayList<DuplicateCheckInfo> checkInfoList = new ArrayList<DuplicateCheckInfo>();
        for (Map.Entry<String, List<String>> delEntity : proIdWithDocIdCollection.entrySet()) {
            DuplicateCheckInfo checkInfo = new DuplicateCheckInfo("mn_checkId", delEntity.getKey());
            checkInfo.addAttachment("uploadIds", delEntity.getValue());
            checkInfoList.add(checkInfo);
        }
        DuplicateCheckGroupInfo checkInfoGroup = new DuplicateCheckGroupInfo(checkInfoList, DuplicateCheckOperationEnum.DELETE);
        DuplicateCheckTask duplicateCheckTask = new DuplicateCheckTask(checkInfoGroup, false);
        DuplicateCheckTaskGroupExecutor taskGroup = new DuplicateCheckTaskGroupExecutor(duplicateCheckTask);
        taskGroup.call();
    }

    @Override
    public void deleteTemplateDocument(List<DuplicateCheckTemplateDoc> templateDocList) {
        HashMap<String, List<String>> proIdWithDocIdCollection = new HashMap<String, List<String>>();
        for (DuplicateCheckTemplateDoc templateDoc : templateDocList) {
            String templateProjectId = templateDoc.getTemplateProjectId();
            proIdWithDocIdCollection.computeIfAbsent(templateProjectId, k -> new ArrayList()).add(templateDoc.getId());
        }
        this.deleteCheckLibOfDocument(proIdWithDocIdCollection);
    }

    @Override
    public void addTemplateDoc(DuplicateCheckTemplateDoc duplicateCheckTemplateDoc) {
        FileBytesInfo fileBytesInfo = this.ioService.getFileBytesInfo(Long.valueOf(duplicateCheckTemplateDoc.getFileId()));
        String fileName = fileBytesInfo.getFileName() + "." + fileBytesInfo.getFileFormat();
        MockMultipartFile file = new MockMultipartFile(fileName, fileName, null, fileBytesInfo.getFileBytes());
        String templateProjectId = duplicateCheckTemplateDoc.getTemplateProjectId();
        DuplicateCheckTemplateProject templateProject = (DuplicateCheckTemplateProject)this.templateProjectService.getById((Serializable)((Object)templateProjectId));
        DuplicateCheckProject projectInfo = (DuplicateCheckProject)this.projectService.getById((Serializable)((Object)templateProject.getProjectId()));
        DuplicateCheckInfo checkInfo = new DuplicateCheckInfo(String.valueOf(duplicateCheckTemplateDoc.getId()), String.valueOf(templateProjectId), (MultipartFile)file, DuplicateCheckUpdateModelEnum.NO_CHECK_UPDATE.getFlag(), projectInfo.getSimilarityBounds(), projectInfo.getWordLength(), projectInfo.getTableWordLength(), SentenceHandlerManagement.get((MultipartFile)file), new TemplateDocumentResultHandler(this.templateDocService), "");
        DuplicateCheckGroupInfo checkInfoGroup = new DuplicateCheckGroupInfo(Collections.singletonList(checkInfo), DuplicateCheckOperationEnum.ADD_TEMPLATE);
        DuplicateCheckTask duplicateCheckTask = new DuplicateCheckTask(checkInfoGroup, false);
        DuplicateCheckTaskGroupExecutor taskGroupExecutor = new DuplicateCheckTaskGroupExecutor(duplicateCheckTask);
        taskGroupExecutor.call();
    }
}

