/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.executor.task;

import cn.hutool.core.thread.ThreadUtil;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckGroupInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckTask;
import com.jxdinfo.idp.icpac.core.executor.task.DuplicateCheckTaskExecutor;
import com.jxdinfo.idp.icpac.core.executor.task.DuplicatecheckCallTaskExecutor;
import com.jxdinfo.idp.icpac.core.executor.task.impl.DuplicateCheckTaskFactory;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckExecuteModelEnum;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCheckTaskGroupExecutor
implements Callable<Object> {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckTaskGroupExecutor.class);
    private final DuplicateCheckTask task;

    public DuplicateCheckTaskGroupExecutor(DuplicateCheckTask task) {
        if (task == null) {
            throw new NullPointerException("\u7ed9\u5b9a\u7684\u67e5\u91cd\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e0b\u4e00\u6b65\u67e5\u91cd");
        }
        this.task = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() {
        try {
            ThreadPoolExecutor taskExecutors = this.task.getTaskThreadPool();
            List<DuplicateCheckGroupInfo> groupInfoList = this.task.getGroupInfoList();
            for (DuplicateCheckGroupInfo groupInfo : groupInfoList) {
                List<DuplicateCheckInfo> infoList = groupInfo.getInfoList();
                for (DuplicateCheckInfo checkInfo : infoList) {
                    DuplicateCheckTaskExecutor taskExecutor = DuplicateCheckTaskFactory.getTask(checkInfo);
                    CompletableFuture<Void> future = CompletableFuture.runAsync(taskExecutor, taskExecutors);
                    this.task.addFuture(future);
                }
            }
            DuplicateCheckExecuteModelEnum modelEnum = this.task.getModelEnum();
            if (modelEnum == DuplicateCheckExecuteModelEnum.SYNC) {
                List<CompletableFuture<?>> futureList = this.task.getFutureList();
                CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).join();
            } else {
                DuplicatecheckCallTaskExecutor taskExecutor = new DuplicatecheckCallTaskExecutor(this.task);
                ThreadUtil.execute((Runnable)taskExecutor);
            }
            Object var4_4 = null;
            return var4_4;
        }
        finally {
            DuplicateCheckExecuteModelEnum modelEnum = this.task.getModelEnum();
            if (modelEnum == DuplicateCheckExecuteModelEnum.SYNC) {
                log.info("\u7ec4\u67e5\u91cd\u4efb\u52a1\u5168\u90e8\u6267\u884c\u5b8c\u6bd5\uff0c\u8017\u65f6\u4e3a\uff1a{}\u79d2", (Object)((System.currentTimeMillis() - this.task.getStartTime()) / 1000L));
                this.task.clear();
            }
        }
    }
}

