/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.entity;

import com.jxdinfo.idp.duplicatecheck.api.call.DuplicatecheckOverInterface;
import com.jxdinfo.idp.icpac.core.context.DuplicateCheckContext;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckGroupInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.executor.pool.DefaultThreadFactory;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckExecuteModelEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCheckTask {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckTask.class);
    private List<DuplicateCheckGroupInfo> groupInfoList;
    private DuplicateCheckExecuteModelEnum modelEnum;
    private List<DuplicatecheckOverInterface> censorOverInterfaces;
    private List<CompletableFuture<?>> futureList = new ArrayList();
    private int needCheckCount = 0;
    private final ThreadPoolExecutor taskThreadPool;
    private final long startTime;

    public DuplicateCheckTask(List<DuplicateCheckGroupInfo> groupInfoList, boolean immediate, List<DuplicatecheckOverInterface> censorOverInterfaces) {
        this.groupInfoList = groupInfoList;
        this.modelEnum = immediate ? DuplicateCheckExecuteModelEnum.SYNC : DuplicateCheckExecuteModelEnum.ASYNC;
        this.censorOverInterfaces = censorOverInterfaces;
        DuplicateCheckContext checkContext = new DuplicateCheckContext(this);
        for (DuplicateCheckGroupInfo groupInfo : groupInfoList) {
            List<DuplicateCheckInfo> infoList = groupInfo.getInfoList();
            for (DuplicateCheckInfo checkInfo : infoList) {
                checkInfo.setContext(checkContext);
                ++this.needCheckCount;
            }
        }
        checkContext.init();
        this.taskThreadPool = new ThreadPoolExecutor(this.needCheckCount, this.needCheckCount, 60L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.startTime = System.currentTimeMillis();
    }

    public DuplicateCheckTask(List<DuplicateCheckGroupInfo> groupInfoList, boolean immediate) {
        this(groupInfoList, immediate, null);
    }

    public DuplicateCheckTask(DuplicateCheckGroupInfo groupInfo, boolean immediate) {
        this(Arrays.asList(groupInfo), immediate, null);
    }

    public void addFuture(CompletableFuture<?> future) {
        this.futureList.add(future);
    }

    public void clear() {
        log.info("\u6b63\u5728\u5173\u95ed\u7ebf\u7a0b\u6c60");
        this.taskThreadPool.shutdown();
        log.info("\u7ebf\u7a0b\u6c60\u5173\u95ed\u5b8c\u6210");
    }

    public List<DuplicateCheckGroupInfo> getGroupInfoList() {
        return this.groupInfoList;
    }

    public DuplicateCheckExecuteModelEnum getModelEnum() {
        return this.modelEnum;
    }

    public List<DuplicatecheckOverInterface> getCensorOverInterfaces() {
        return this.censorOverInterfaces;
    }

    public List<CompletableFuture<?>> getFutureList() {
        return this.futureList;
    }

    public int getNeedCheckCount() {
        return this.needCheckCount;
    }

    public ThreadPoolExecutor getTaskThreadPool() {
        return this.taskThreadPool;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setGroupInfoList(List<DuplicateCheckGroupInfo> groupInfoList) {
        this.groupInfoList = groupInfoList;
    }

    public void setModelEnum(DuplicateCheckExecuteModelEnum modelEnum) {
        this.modelEnum = modelEnum;
    }

    public void setCensorOverInterfaces(List<DuplicatecheckOverInterface> censorOverInterfaces) {
        this.censorOverInterfaces = censorOverInterfaces;
    }

    public void setFutureList(List<CompletableFuture<?>> futureList) {
        this.futureList = futureList;
    }

    public void setNeedCheckCount(int needCheckCount) {
        this.needCheckCount = needCheckCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DuplicateCheckTask)) {
            return false;
        }
        DuplicateCheckTask other = (DuplicateCheckTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNeedCheckCount() != other.getNeedCheckCount()) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        List<DuplicateCheckGroupInfo> this$groupInfoList = this.getGroupInfoList();
        List<DuplicateCheckGroupInfo> other$groupInfoList = other.getGroupInfoList();
        if (this$groupInfoList == null ? other$groupInfoList != null : !((Object)this$groupInfoList).equals(other$groupInfoList)) {
            return false;
        }
        DuplicateCheckExecuteModelEnum this$modelEnum = this.getModelEnum();
        DuplicateCheckExecuteModelEnum other$modelEnum = other.getModelEnum();
        if (this$modelEnum == null ? other$modelEnum != null : !((Object)((Object)this$modelEnum)).equals((Object)other$modelEnum)) {
            return false;
        }
        List<DuplicatecheckOverInterface> this$censorOverInterfaces = this.getCensorOverInterfaces();
        List<DuplicatecheckOverInterface> other$censorOverInterfaces = other.getCensorOverInterfaces();
        if (this$censorOverInterfaces == null ? other$censorOverInterfaces != null : !((Object)this$censorOverInterfaces).equals(other$censorOverInterfaces)) {
            return false;
        }
        List<CompletableFuture<?>> this$futureList = this.getFutureList();
        List<CompletableFuture<?>> other$futureList = other.getFutureList();
        if (this$futureList == null ? other$futureList != null : !((Object)this$futureList).equals(other$futureList)) {
            return false;
        }
        ThreadPoolExecutor this$taskThreadPool = this.getTaskThreadPool();
        ThreadPoolExecutor other$taskThreadPool = other.getTaskThreadPool();
        return !(this$taskThreadPool == null ? other$taskThreadPool != null : !this$taskThreadPool.equals(other$taskThreadPool));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DuplicateCheckTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNeedCheckCount();
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        List<DuplicateCheckGroupInfo> $groupInfoList = this.getGroupInfoList();
        result = result * 59 + ($groupInfoList == null ? 43 : ((Object)$groupInfoList).hashCode());
        DuplicateCheckExecuteModelEnum $modelEnum = this.getModelEnum();
        result = result * 59 + ($modelEnum == null ? 43 : ((Object)((Object)$modelEnum)).hashCode());
        List<DuplicatecheckOverInterface> $censorOverInterfaces = this.getCensorOverInterfaces();
        result = result * 59 + ($censorOverInterfaces == null ? 43 : ((Object)$censorOverInterfaces).hashCode());
        List<CompletableFuture<?>> $futureList = this.getFutureList();
        result = result * 59 + ($futureList == null ? 43 : ((Object)$futureList).hashCode());
        ThreadPoolExecutor $taskThreadPool = this.getTaskThreadPool();
        result = result * 59 + ($taskThreadPool == null ? 43 : $taskThreadPool.hashCode());
        return result;
    }

    public String toString() {
        return "DuplicateCheckTask(groupInfoList=" + this.getGroupInfoList() + ", modelEnum=" + (Object)((Object)this.getModelEnum()) + ", censorOverInterfaces=" + this.getCensorOverInterfaces() + ", futureList=" + this.getFutureList() + ", needCheckCount=" + this.getNeedCheckCount() + ", taskThreadPool=" + this.getTaskThreadPool() + ", startTime=" + this.getStartTime() + ")";
    }
}

