/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.entity;

import com.jxdinfo.hussar.platform.core.utils.file.FileNameUtil;
import com.jxdinfo.idp.icpac.core.context.DuplicateCheckContext;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckCandidateSentence;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckGroupInfo;
import com.jxdinfo.idp.icpac.core.executor.document.DuplicateCheckDocumentExecutor;
import com.jxdinfo.idp.icpac.core.executor.document.DuplicateCheckExecutorRegister;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckResultHandler;
import com.jxdinfo.idp.icpac.core.handler.SentenceHandler;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckOperationEnum;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckUpdateModelEnum;
import com.jxdinfo.idp.icpac.core.paramconfig.DefaultParamConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;

public class DuplicateCheckInfo {
    private boolean segmentation = true;
    private String documentId;
    private String libId;
    private MultipartFile file;
    private String fileName;
    private Double simThresh;
    private Map<String, Object> attachmentCollections;
    private int wordLength;
    private int tableWordLength;
    private SentenceHandler sentenceHandler;
    private int candidateSentenceNum;
    private List<DuplicateCheckCandidateSentence> candidateSentenceList;
    private String format;
    private DuplicateCheckGroupInfo groupInfo;
    private DuplicateCheckDocumentExecutor checkDocumentExecutor;
    private DuplicateCheckResultHandler resultHandler;
    private DuplicateCheckContext context;
    private DuplicateCheckUpdateModelEnum updateModel;
    private boolean maybeExist = false;
    private boolean isCheck = true;
    private String templateProjectId;

    public DuplicateCheckInfo(String documentId, String libId) {
        this.assertNoNull(documentId, "\u7ed9\u5b9a\u7684\u64cd\u4f5c\u6807\u8bc6\u7b26id\u4e3a\u7a7a");
        this.documentId = documentId;
        this.libId = libId;
        this.attachmentCollections = new HashMap<String, Object>();
        this.checkDocumentExecutor = DuplicateCheckExecutorRegister.get(this);
    }

    public DuplicateCheckInfo(String documentId, String libId, MultipartFile file, String updateLib, Double simThresh, int wordLength, int tableWordLength, SentenceHandler sentenceHandler, DuplicateCheckResultHandler resultHandler, String templateProjectId) {
        this.assertNoNull(documentId, "\u7ed9\u5b9a\u7684\u64cd\u4f5c\u6807\u8bc6\u7b26id\u4e3a\u7a7a");
        this.documentId = documentId;
        this.libId = libId;
        this.assertNoNull(file, "\u7ed9\u5b9a\u7684\u67e5\u91cd\u6587\u4ef6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u67e5");
        this.file = file;
        this.assertNoNull(simThresh, "\u76f8\u4f3c\u5ea6\u9608\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u67e5");
        if (simThresh <= 0.0) {
            throw new IllegalArgumentException("\u76f8\u4f3c\u5ea6\u9608\u503c\u4e0d\u80fd\u4e3a0\uff0c\u7ed9\u5b9a\u7684\u76f8\u4f3c\u5ea6\u9608\u503c\u4e3a\uff1a" + simThresh);
        }
        this.simThresh = simThresh;
        if (wordLength <= 0) {
            wordLength = DefaultParamConfig.wordLength;
        }
        if (tableWordLength <= 0) {
            tableWordLength = DefaultParamConfig.tableWordLength;
        }
        this.updateModel = DuplicateCheckUpdateModelEnum.getUpdateModel(updateLib);
        this.attachmentCollections = new HashMap<String, Object>();
        this.sentenceHandler = sentenceHandler;
        this.format = FileNameUtil.getSuffix((String)file.getOriginalFilename());
        this.resultHandler = resultHandler;
        this.fileName = file.getOriginalFilename() + "." + this.format;
        this.checkDocumentExecutor = DuplicateCheckExecutorRegister.get(this);
        this.wordLength = wordLength;
        this.tableWordLength = tableWordLength;
        this.templateProjectId = templateProjectId;
    }

    private void assertNoNull(Object o, String message) {
        if (this.file == o) {
            throw new NullPointerException(message);
        }
    }

    public void setContext(DuplicateCheckContext context) {
        this.context = context;
    }

    public Object addAttachment(String key, Object attachment) {
        if (key == null) {
            throw new NullPointerException("\u7ed9\u5b9a\u7684key\u4e0d\u80fd\u4e3anull");
        }
        Object oldAttachment = this.attachmentCollections.remove(key);
        this.attachmentCollections.put(key, attachment);
        return oldAttachment;
    }

    public <T> T getAttachment(String key, Class<T> type) {
        Object o = this.attachmentCollections.get(key);
        if (o == null) {
            return null;
        }
        return (T)o;
    }

    public String getFileName() {
        return this.fileName;
    }

    public DuplicateCheckOperationEnum getOperationModel() {
        return this.groupInfo.getOperationEnum();
    }

    public boolean isSegmentation() {
        return this.segmentation;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getLibId() {
        return this.libId;
    }

    public MultipartFile getFile() {
        return this.file;
    }

    public Double getSimThresh() {
        return this.simThresh;
    }

    public Map<String, Object> getAttachmentCollections() {
        return this.attachmentCollections;
    }

    public int getWordLength() {
        return this.wordLength;
    }

    public int getTableWordLength() {
        return this.tableWordLength;
    }

    public SentenceHandler getSentenceHandler() {
        return this.sentenceHandler;
    }

    public int getCandidateSentenceNum() {
        return this.candidateSentenceNum;
    }

    public List<DuplicateCheckCandidateSentence> getCandidateSentenceList() {
        return this.candidateSentenceList;
    }

    public String getFormat() {
        return this.format;
    }

    public DuplicateCheckGroupInfo getGroupInfo() {
        return this.groupInfo;
    }

    public DuplicateCheckDocumentExecutor getCheckDocumentExecutor() {
        return this.checkDocumentExecutor;
    }

    public DuplicateCheckResultHandler getResultHandler() {
        return this.resultHandler;
    }

    public DuplicateCheckContext getContext() {
        return this.context;
    }

    public DuplicateCheckUpdateModelEnum getUpdateModel() {
        return this.updateModel;
    }

    public boolean isMaybeExist() {
        return this.maybeExist;
    }

    public boolean isCheck() {
        return this.isCheck;
    }

    public String getTemplateProjectId() {
        return this.templateProjectId;
    }

    public void setSegmentation(boolean segmentation) {
        this.segmentation = segmentation;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public void setLibId(String libId) {
        this.libId = libId;
    }

    public void setFile(MultipartFile file) {
        this.file = file;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setSimThresh(Double simThresh) {
        this.simThresh = simThresh;
    }

    public void setAttachmentCollections(Map<String, Object> attachmentCollections) {
        this.attachmentCollections = attachmentCollections;
    }

    public void setWordLength(int wordLength) {
        this.wordLength = wordLength;
    }

    public void setTableWordLength(int tableWordLength) {
        this.tableWordLength = tableWordLength;
    }

    public void setSentenceHandler(SentenceHandler sentenceHandler) {
        this.sentenceHandler = sentenceHandler;
    }

    public void setCandidateSentenceNum(int candidateSentenceNum) {
        this.candidateSentenceNum = candidateSentenceNum;
    }

    public void setCandidateSentenceList(List<DuplicateCheckCandidateSentence> candidateSentenceList) {
        this.candidateSentenceList = candidateSentenceList;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setGroupInfo(DuplicateCheckGroupInfo groupInfo) {
        this.groupInfo = groupInfo;
    }

    public void setCheckDocumentExecutor(DuplicateCheckDocumentExecutor checkDocumentExecutor) {
        this.checkDocumentExecutor = checkDocumentExecutor;
    }

    public void setResultHandler(DuplicateCheckResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public void setUpdateModel(DuplicateCheckUpdateModelEnum updateModel) {
        this.updateModel = updateModel;
    }

    public void setMaybeExist(boolean maybeExist) {
        this.maybeExist = maybeExist;
    }

    public void setCheck(boolean isCheck) {
        this.isCheck = isCheck;
    }

    public void setTemplateProjectId(String templateProjectId) {
        this.templateProjectId = templateProjectId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DuplicateCheckInfo)) {
            return false;
        }
        DuplicateCheckInfo other = (DuplicateCheckInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSegmentation() != other.isSegmentation()) {
            return false;
        }
        if (this.getWordLength() != other.getWordLength()) {
            return false;
        }
        if (this.getTableWordLength() != other.getTableWordLength()) {
            return false;
        }
        if (this.getCandidateSentenceNum() != other.getCandidateSentenceNum()) {
            return false;
        }
        if (this.isMaybeExist() != other.isMaybeExist()) {
            return false;
        }
        if (this.isCheck() != other.isCheck()) {
            return false;
        }
        Double this$simThresh = this.getSimThresh();
        Double other$simThresh = other.getSimThresh();
        if (this$simThresh == null ? other$simThresh != null : !((Object)this$simThresh).equals(other$simThresh)) {
            return false;
        }
        String this$documentId = this.getDocumentId();
        String other$documentId = other.getDocumentId();
        if (this$documentId == null ? other$documentId != null : !this$documentId.equals(other$documentId)) {
            return false;
        }
        String this$libId = this.getLibId();
        String other$libId = other.getLibId();
        if (this$libId == null ? other$libId != null : !this$libId.equals(other$libId)) {
            return false;
        }
        MultipartFile this$file = this.getFile();
        MultipartFile other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        Map<String, Object> this$attachmentCollections = this.getAttachmentCollections();
        Map<String, Object> other$attachmentCollections = other.getAttachmentCollections();
        if (this$attachmentCollections == null ? other$attachmentCollections != null : !((Object)this$attachmentCollections).equals(other$attachmentCollections)) {
            return false;
        }
        SentenceHandler this$sentenceHandler = this.getSentenceHandler();
        SentenceHandler other$sentenceHandler = other.getSentenceHandler();
        if (this$sentenceHandler == null ? other$sentenceHandler != null : !this$sentenceHandler.equals(other$sentenceHandler)) {
            return false;
        }
        List<DuplicateCheckCandidateSentence> this$candidateSentenceList = this.getCandidateSentenceList();
        List<DuplicateCheckCandidateSentence> other$candidateSentenceList = other.getCandidateSentenceList();
        if (this$candidateSentenceList == null ? other$candidateSentenceList != null : !((Object)this$candidateSentenceList).equals(other$candidateSentenceList)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        DuplicateCheckGroupInfo this$groupInfo = this.getGroupInfo();
        DuplicateCheckGroupInfo other$groupInfo = other.getGroupInfo();
        if (this$groupInfo == null ? other$groupInfo != null : !((Object)this$groupInfo).equals(other$groupInfo)) {
            return false;
        }
        DuplicateCheckDocumentExecutor this$checkDocumentExecutor = this.getCheckDocumentExecutor();
        DuplicateCheckDocumentExecutor other$checkDocumentExecutor = other.getCheckDocumentExecutor();
        if (this$checkDocumentExecutor == null ? other$checkDocumentExecutor != null : !this$checkDocumentExecutor.equals(other$checkDocumentExecutor)) {
            return false;
        }
        DuplicateCheckResultHandler this$resultHandler = this.getResultHandler();
        DuplicateCheckResultHandler other$resultHandler = other.getResultHandler();
        if (this$resultHandler == null ? other$resultHandler != null : !this$resultHandler.equals(other$resultHandler)) {
            return false;
        }
        DuplicateCheckContext this$context = this.getContext();
        DuplicateCheckContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        DuplicateCheckUpdateModelEnum this$updateModel = this.getUpdateModel();
        DuplicateCheckUpdateModelEnum other$updateModel = other.getUpdateModel();
        if (this$updateModel == null ? other$updateModel != null : !((Object)((Object)this$updateModel)).equals((Object)other$updateModel)) {
            return false;
        }
        String this$templateProjectId = this.getTemplateProjectId();
        String other$templateProjectId = other.getTemplateProjectId();
        return !(this$templateProjectId == null ? other$templateProjectId != null : !this$templateProjectId.equals(other$templateProjectId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DuplicateCheckInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSegmentation() ? 79 : 97);
        result = result * 59 + this.getWordLength();
        result = result * 59 + this.getTableWordLength();
        result = result * 59 + this.getCandidateSentenceNum();
        result = result * 59 + (this.isMaybeExist() ? 79 : 97);
        result = result * 59 + (this.isCheck() ? 79 : 97);
        Double $simThresh = this.getSimThresh();
        result = result * 59 + ($simThresh == null ? 43 : ((Object)$simThresh).hashCode());
        String $documentId = this.getDocumentId();
        result = result * 59 + ($documentId == null ? 43 : $documentId.hashCode());
        String $libId = this.getLibId();
        result = result * 59 + ($libId == null ? 43 : $libId.hashCode());
        MultipartFile $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        Map<String, Object> $attachmentCollections = this.getAttachmentCollections();
        result = result * 59 + ($attachmentCollections == null ? 43 : ((Object)$attachmentCollections).hashCode());
        SentenceHandler $sentenceHandler = this.getSentenceHandler();
        result = result * 59 + ($sentenceHandler == null ? 43 : $sentenceHandler.hashCode());
        List<DuplicateCheckCandidateSentence> $candidateSentenceList = this.getCandidateSentenceList();
        result = result * 59 + ($candidateSentenceList == null ? 43 : ((Object)$candidateSentenceList).hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        DuplicateCheckGroupInfo $groupInfo = this.getGroupInfo();
        result = result * 59 + ($groupInfo == null ? 43 : ((Object)$groupInfo).hashCode());
        DuplicateCheckDocumentExecutor $checkDocumentExecutor = this.getCheckDocumentExecutor();
        result = result * 59 + ($checkDocumentExecutor == null ? 43 : $checkDocumentExecutor.hashCode());
        DuplicateCheckResultHandler $resultHandler = this.getResultHandler();
        result = result * 59 + ($resultHandler == null ? 43 : $resultHandler.hashCode());
        DuplicateCheckContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        DuplicateCheckUpdateModelEnum $updateModel = this.getUpdateModel();
        result = result * 59 + ($updateModel == null ? 43 : ((Object)((Object)$updateModel)).hashCode());
        String $templateProjectId = this.getTemplateProjectId();
        result = result * 59 + ($templateProjectId == null ? 43 : $templateProjectId.hashCode());
        return result;
    }

    public String toString() {
        return "DuplicateCheckInfo(segmentation=" + this.isSegmentation() + ", documentId=" + this.getDocumentId() + ", libId=" + this.getLibId() + ", file=" + this.getFile() + ", fileName=" + this.getFileName() + ", simThresh=" + this.getSimThresh() + ", attachmentCollections=" + this.getAttachmentCollections() + ", wordLength=" + this.getWordLength() + ", tableWordLength=" + this.getTableWordLength() + ", sentenceHandler=" + this.getSentenceHandler() + ", candidateSentenceNum=" + this.getCandidateSentenceNum() + ", candidateSentenceList=" + this.getCandidateSentenceList() + ", format=" + this.getFormat() + ", groupInfo=" + this.getGroupInfo() + ", checkDocumentExecutor=" + this.getCheckDocumentExecutor() + ", resultHandler=" + this.getResultHandler() + ", context=" + this.getContext() + ", updateModel=" + (Object)((Object)this.getUpdateModel()) + ", maybeExist=" + this.isMaybeExist() + ", isCheck=" + this.isCheck() + ", templateProjectId=" + this.getTemplateProjectId() + ")";
    }
}

