/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.executor.task;

import com.jxdinfo.idp.icpac.core.context.DuplicateCheckContext;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckGroupInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckTask;
import com.jxdinfo.idp.icpac.core.executor.task.DuplicateCheckTaskExecutor;
import com.jxdinfo.idp.icpac.core.executor.task.DuplicatecheckCallTaskExecutor;
import com.jxdinfo.idp.icpac.core.executor.task.impl.DuplicateCheckTaskFactory;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckExecuteModelEnum;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCheckTaskGroupExecutor
implements Callable<Object> {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckTaskGroupExecutor.class);
    private final DuplicateCheckTask task;

    public DuplicateCheckTaskGroupExecutor(DuplicateCheckTask task) {
        if (task == null) {
            throw new NullPointerException("\u7ed9\u5b9a\u7684\u67e5\u91cd\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e0b\u4e00\u6b65\u67e5\u91cd");
        }
        this.task = task;
    }

    @Override
    public Object call() {
        ThreadPoolExecutor taskExecutors = this.task.getTaskThreadPool();
        List<DuplicateCheckGroupInfo> groupInfoList = this.task.getGroupInfoList();
        for (DuplicateCheckGroupInfo groupInfo : groupInfoList) {
            List<DuplicateCheckInfo> infoList = groupInfo.getInfoList();
            for (DuplicateCheckInfo checkInfo : infoList) {
                try {
                    DuplicateCheckTaskExecutor taskExecutor = DuplicateCheckTaskFactory.getTask(checkInfo);
                    CompletableFuture.runAsync(taskExecutor, taskExecutors);
                }
                catch (Exception e) {
                    log.error("\u67e5\u8be2\u4efb\u52a1\u6267\u884c\u51fa\u9519");
                    DuplicateCheckContext checkContext = this.task.getCheckContext();
                    checkContext.waitOthers();
                    checkContext.waitCompleteByOperation();
                }
            }
        }
        DuplicateCheckExecuteModelEnum modelEnum = this.task.getModelEnum();
        DuplicatecheckCallTaskExecutor taskExecutor = new DuplicatecheckCallTaskExecutor(this.task);
        if (modelEnum == DuplicateCheckExecuteModelEnum.SYNC) {
            taskExecutor.run();
        } else {
            CompletableFuture.runAsync(taskExecutor);
        }
        return null;
    }
}

