/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.executor.document.impl;

import com.jxdinfo.idp.common.entity.util.docparse.word.WordChapterInfo;
import com.jxdinfo.idp.icpac.core.dochandler.impl.PdfDocumentHandler;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckCandidateSentence;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.executor.document.AbstractDuplicateCheckDocumentExecutor;
import com.jxdinfo.idp.icpac.core.handler.SentenceHandler;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PdfDuplicateCheckExecutor
extends AbstractDuplicateCheckDocumentExecutor {
    private static final Logger log = LoggerFactory.getLogger(PdfDuplicateCheckExecutor.class);

    @Override
    public boolean support(DuplicateCheckInfo info) {
        MultipartFile file = info.getFile();
        if (file == null) {
            return false;
        }
        String fileSuffix = info.getFormat();
        return Objects.equals(fileSuffix, "pdf");
    }

    @Override
    protected List<DuplicateCheckCandidateSentence> getCandidateSentence(DuplicateCheckInfo checkInfo) throws Exception {
        PdfDocumentHandler documentHandler = new PdfDocumentHandler();
        log.info("\u5f00\u59cb\u83b7\u53d6\u6587\u6863\u7684\u5f85\u67e5\u91cd\u7684\u5019\u9009\u53e5\u5b50.........");
        List<WordChapterInfo> chapterInfos = documentHandler.structuredDoc(checkInfo);
        SentenceHandler sentenceHandler = checkInfo.getSentenceHandler();
        if (sentenceHandler == null) {
            throw new RuntimeException("\u7ed9\u5b9a\u7684\u81ea\u5b9a\u4e49\u7684\u53e5\u5b50\u5904\u7406\u5668\u4e3a\u7a7a\uff0c\u6ca1\u6709\u529e\u6cd5\u83b7\u53d6\u81ea\u5b9a\u4e49\u7684\u53e5\u5b50\u5904\u7406\u5668");
        }
        List<DuplicateCheckCandidateSentence> candidateSentenceList = sentenceHandler.handleSentence(chapterInfos, checkInfo);
        if (candidateSentenceList == null) {
            log.info("\u6ca1\u6709\u83b7\u53d6\u4efb\u4f55\u7684\u5e26\u5019\u9009\u53e5\u5b50");
        } else {
            log.info("\u83b7\u53d6\u5e26\u5019\u9009\u53e5\u5b50\u7684\u603b\u6761\u6570\u4e3a\uff1a{}", (Object)candidateSentenceList.size());
        }
        return candidateSentenceList;
    }
}

