/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.custom.resulthandler;

import com.jxdinfo.idp.common.util.DoubleUtils;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckResultDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSimilarSentenceDto;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckGroupInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckResult;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckResultHandler;
import com.jxdinfo.idp.icpac.core.rmi.resp.DuplicateCheckResponse;
import com.jxdinfo.idp.icpac.core.rmi.resp.DuplicateCheckSentenceResult;
import com.jxdinfo.idp.icpac.core.rmi.resp.DuplicateCheckSimilarResult;
import com.jxdinfo.idp.icpac.core.rmi.resp.DuplicateCheckSimilarityResult;
import com.jxdinfo.idp.icpac.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.utils.DuplicateCheckProgress;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResultHandler
implements DuplicateCheckResultHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultResultHandler.class);
    private final DuplicateCheckDocService docService;
    private final Map<String, Double> similarityMap;
    private final Map<String, DuplicateCheckResultDto> resultCollection;
    private final List<DuplicateCheckSentenceDto> sentenceList;
    private Double maxSimilarity;
    private BigDecimal docSimilarity;
    private final Map<String, SimilarCalculator> docSimilarityMap = new HashMap<String, SimilarCalculator>();
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^\\d+$");
    private static final Pattern ID_CARD_PATTERN = Pattern.compile("([1-9]\\d{5}(?:19|20)\\d{2}(?:0[1-9]|1[0-2])(?:0[1-9]|[12]\\d|3[01])\\d{3}[\\dXx])");
    private static final Pattern PHONE_PATTERN = Pattern.compile("((?:\\+86[-\\s]?)?(?:1[3-9]\\d{9}|0\\d{2,3}[-\\s]?[1-9]\\d{6,7})(?:[\\s#]*(?:ext|\u5206\u673a|#)\\s*\\d+)?)");
    private static final Pattern EMAIL_PATTERN = Pattern.compile("([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,})");
    private static final Pattern COMPANY_PATTERN = Pattern.compile("(?:\u5355\u4f4d|\u6295\u6807\u5355\u4f4d|\u6295\u6807\u4eba(?:\\(\u76d6\u7ae0\\))?)\uff1a?(.*?(?:\u516c\u53f8|\u96c6\u56e2|\u5355\u4f4d))");

    public DefaultResultHandler(DuplicateCheckDocService docService) {
        this.docService = docService;
        this.similarityMap = new HashMap<String, Double>();
        this.resultCollection = new HashMap<String, DuplicateCheckResultDto>();
        this.sentenceList = new ArrayList<DuplicateCheckSentenceDto>();
        this.maxSimilarity = 0.0;
        this.docSimilarity = BigDecimal.valueOf(0.0);
    }

    public static void main(String[] args) {
        Matcher matcher = COMPANY_PATTERN.matcher("\u6295\u6807\u4eba\uff1a\u5c71\u4e1c\u5723\u5730\u8d77\u91cd\u673a\u68b0\u6709\u9650\u516c\u53f8");
        if (matcher.find()) {
            String group = matcher.group(1);
            System.out.println(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResult(DuplicateCheckResult checkResult) {
        String docId = null;
        log.info("\u5f00\u59cb\u67e5\u91cd\u7ed3\u679c\u89e3\u6790");
        DuplicateCheckInfo checkInfo = checkResult.getInfo();
        try {
            docId = checkInfo.getDocumentId();
            if (StringUtils.isEmpty((CharSequence)docId)) {
                log.error("\u5f53\u524d\u5f85\u67e5\u91cd\u7684\u6587\u6863id\u4e3a\u7a7a\u3002\u65e0\u6cd5\u5904\u7406\u7ed3\u679c");
                return;
            }
            if (!checkResult.isSuccess()) {
                log.error("\u67e5\u91cd\u7ed3\u679c\u6267\u884c\u51fa\u9519");
                this.updateDocInfo(docId, "2", checkInfo);
                return;
            }
            DuplicateCheckDocDto docInfo = this.docService.detail(docId);
            if (docInfo == null) {
                return;
            }
            Object executionResult = checkResult.getExecutionResult();
            if (executionResult == null) {
                log.error("\u5f53\u524d\u7684\u67e5\u91cd\u7ed3\u679c\u4e3a\u7a7a\u3002\u3002\u3002\u3002\u3002\u3002");
                this.updateDocInfo(docId, "1", checkInfo);
                return;
            }
            if (!(executionResult instanceof DuplicateCheckResponse)) {
                this.updateDocInfo(docId, "2", checkInfo);
                throw new RuntimeException("\u5f53\u524d\u7ed9\u5b9a\u7684\u7ed3\u679c\u7c7b\u578b\uff1a" + executionResult.getClass() + ",\u65e0\u6cd5\u8fdb\u884c\u89e3\u6790");
            }
            DuplicateCheckResponse rmiResponse = (DuplicateCheckResponse)executionResult;
            if (CollectionUtils.isEmpty(rmiResponse.getResult())) {
                log.error("\u67e5\u91cd\u670d\u52a1\u8fd4\u56de\u7684\u67e5\u91cd\u7ed3\u679c\u4e3a\u7a7a\u3002\u3002\u3002\u3002\u3002\u3002{}", rmiResponse.getResult());
                this.updateDocInfo(docId, "1", checkInfo);
                return;
            }
            List<DuplicateCheckSimilarityResult> simiResultList = rmiResponse.getSimilarity();
            if (CollectionUtils.isEmpty(simiResultList)) {
                this.updateDocInfo(docId, "1", checkInfo);
                log.warn("\u5f53\u524d\u67e5\u91cd\u7684\u76f8\u4f3c\u8bed\u53e5\u603b\u6761\u6570\u4e3a0");
                return;
            }
            this.handleResult(rmiResponse, checkResult.getInfo(), docInfo);
            for (DuplicateCheckResultDto checkResultDto : this.resultCollection.values()) {
                SimilarCalculator similarCalculator = this.docSimilarityMap.get(checkResultDto.getUploadDocId() + "_" + checkResultDto.getSimilarDocId());
                if (similarCalculator == null) continue;
                double similarity = similarCalculator.getSimilarity(checkInfo.getCandidateSentenceNum());
                checkResultDto.setSimilarity(Double.valueOf(similarity));
            }
            docInfo = this.docService.detail(docId);
            if (docInfo != null) {
                this.updateDocInfo(docId, "1", checkInfo);
                docInfo.setSentenceList(this.sentenceList);
                docInfo.setResultList(new ArrayList<DuplicateCheckResultDto>(this.resultCollection.values()));
                docInfo.setCandidateSentenceNum(checkInfo.getCandidateSentenceNum());
                this.docService.insertCheckResult(docInfo);
            }
        }
        catch (Exception e) {
            this.updateDocInfo(docId, "2", checkInfo);
            log.info("\u6587\u4ef6\u89e3\u6790\u51fa\u73b0\u95ee\u9898", (Throwable)e);
        }
        finally {
            log.info("\u6587\u6863\u89e3\u6790\u7ed3\u675f");
        }
    }

    private void handleResult(DuplicateCheckResponse rmiResponse, DuplicateCheckInfo info, DuplicateCheckDocDto docInfo) {
        Set<String> baseDocSet;
        String docId = docInfo.getId();
        String projectId = info.getLibId();
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            projectId = docInfo.getProjectId();
        }
        if ((baseDocSet = this.getBaseDocIdSet(info, docInfo, docId, projectId)) == null) {
            return;
        }
        this.similarityListForMap(rmiResponse.getSimilarity());
        log.info("\u5f53\u524d\u76f8\u4e0a\u4f20\u7684\u6587\u6863\u7684\u76f8\u4f3c\u8bed\u53e5\u603b\u6761\u6570\u4e3a\uff1a{}", (Object)rmiResponse.getResult().size());
        int size = rmiResponse.getResult().size();
        boolean count = true;
        for (DuplicateCheckSentenceResult sentenceResult : rmiResponse.getResult()) {
            Double sentenceSimilarity = 0.0;
            String documentId = sentenceResult.getDocument_id();
            DuplicateCheckProgress.setProgress(documentId, (int)Math.floor((double)count * 1.0 / (double)size * 70.0) + 20);
            DuplicateCheckSentenceDto sentenceDto = this.toSentence(sentenceResult);
            ArrayList<DuplicateCheckSimilarSentenceDto> similarSentenceList = new ArrayList<DuplicateCheckSimilarSentenceDto>();
            for (DuplicateCheckSimilarResult similarResult : sentenceResult.getSimilar_sentences()) {
                String similarDocId = similarResult.getDocument_id();
                if (!baseDocSet.contains(similarDocId) || Objects.equals(similarDocId, docId) || this.isFilter(sentenceResult, similarResult)) continue;
                DuplicateCheckResultDto resultDto = this.resultCollection.get(documentId + "_" + similarDocId);
                String key = documentId + "_" + similarDocId;
                if (resultDto == null) {
                    Double similarity = this.similarityMap.get(key);
                    resultDto = new DuplicateCheckResultDto(String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()), documentId, similarDocId, similarity);
                    this.resultCollection.put(key, resultDto);
                }
                DuplicateCheckSimilarSentenceDto similarSentenceDto = this.toSimilarSentence(similarResult, resultDto, sentenceDto);
                similarSentenceList.add(similarSentenceDto);
                if (Double.compare(sentenceSimilarity, similarResult.getSimilarty()) < 0) {
                    sentenceSimilarity = similarResult.getSimilarty();
                }
                SimilarCalculator similarCalculator = this.docSimilarityMap.computeIfAbsent(key, k -> new SimilarCalculator());
                similarCalculator.add(similarResult.getSimilarty(), sentenceDto.getId());
            }
            if (CollectionUtils.isNotEmpty(similarSentenceList)) {
                sentenceDto.addSimilarSentenceList(similarSentenceList);
                this.sentenceList.add(sentenceDto);
            }
            this.docSimilarity = this.docSimilarity.add(BigDecimal.valueOf(sentenceSimilarity));
            if (Double.compare(this.maxSimilarity, sentenceSimilarity) >= 0) continue;
            this.maxSimilarity = sentenceSimilarity;
        }
        this.docSimilarity = BigDecimal.valueOf(this.docSimilarity.doubleValue() / (double)info.getCandidateSentenceNum());
    }

    private boolean isFilter(DuplicateCheckSentenceResult sentenceResult, DuplicateCheckSimilarResult similarResult) {
        String sentence = sentenceResult.getSentence();
        String similarSentence = similarResult.getSentence();
        boolean sNumberFlag = NUMBER_PATTERN.matcher(sentence).matches();
        boolean ssNumberFlag = NUMBER_PATTERN.matcher(similarSentence).matches();
        if (sNumberFlag && ssNumberFlag && Objects.equals(sentence, similarSentence)) {
            return true;
        }
        if ((sNumberFlag || ssNumberFlag) && !similarSentence.contains(sentence) && !sentence.contains(similarSentence)) {
            return true;
        }
        if (this.regMatcher(ID_CARD_PATTERN, sentence, similarSentence)) {
            return true;
        }
        if (this.regMatcher(PHONE_PATTERN, sentence, similarSentence)) {
            return true;
        }
        if (this.regMatcher(EMAIL_PATTERN, sentence, similarSentence)) {
            return true;
        }
        if (sentence.length() < 25 && similarSentence.length() < 25) {
            Matcher sCompany = COMPANY_PATTERN.matcher(sentence);
            Matcher ssCompany = COMPANY_PATTERN.matcher(similarSentence);
            String sCompanyName = null;
            String ssCompanyName = null;
            if (sCompany.find()) {
                sCompanyName = sCompany.group(1);
            }
            if (ssCompany.find()) {
                ssCompanyName = ssCompany.group(1);
            }
            if (sCompanyName != null && ssCompanyName != null && !Objects.equals(sCompanyName, ssCompanyName)) {
                return true;
            }
        }
        return false;
    }

    private boolean regMatcher(Pattern pattern, String sentence, String similarSentence) {
        Matcher ssPhoneMatcher;
        String sPhoneNum = null;
        String ssPhoneNum = null;
        Matcher sPhoneMatcher = pattern.matcher(sentence);
        if (sPhoneMatcher.find()) {
            sPhoneNum = sPhoneMatcher.group(1);
        }
        if ((ssPhoneMatcher = pattern.matcher(similarSentence)).find()) {
            ssPhoneNum = ssPhoneMatcher.group(1);
        }
        if (sPhoneNum != null && ssPhoneNum != null) {
            return !Objects.equals(ssPhoneNum, sPhoneNum);
        }
        return false;
    }

    private Set<String> getBaseDocIdSet(DuplicateCheckInfo info, DuplicateCheckDocDto docInfo, String docId, String projectId) {
        HashSet<String> baseDocSet = new HashSet<String>();
        DuplicateCheckGroupInfo infoGroup = info.getGroupInfo();
        List choseIdList = info.getAttachment("choseIdList", List.class);
        if (CollectionUtils.isEmpty((Collection)choseIdList)) {
            List<DuplicateCheckDocDto> maybeSimiDocList = this.docService.listByProjectId(projectId);
            if (CollectionUtils.isEmpty(maybeSimiDocList)) {
                log.error("\u4ece\u8be5\u6587\u6863\u5e93\u4e2d\u6ca1\u6709\u67e5\u8be2\u5230\u57fa\u7840\u6587\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u89e3\u6790");
                return null;
            }
            for (DuplicateCheckDocDto maybeSimiDoc : maybeSimiDocList) {
                if (Objects.equals(maybeSimiDoc.getId(), docId)) continue;
                baseDocSet.add(maybeSimiDoc.getId());
            }
        } else {
            baseDocSet.addAll(choseIdList);
        }
        if (infoGroup != null && infoGroup.getExcludeDocumentIdList() != null) {
            return baseDocSet.stream().filter(k -> !infoGroup.getExcludeDocumentIdList().contains(k)).collect(Collectors.toSet());
        }
        return baseDocSet;
    }

    private DuplicateCheckSimilarSentenceDto toSimilarSentence(DuplicateCheckSimilarResult similarResult, DuplicateCheckResultDto resultDto, DuplicateCheckSentenceDto sentenceDto) {
        Object index;
        String similarSentenceStr = similarResult.getSentence();
        DuplicateCheckSimilarSentenceDto similarSentence = new DuplicateCheckSimilarSentenceDto();
        similarSentence.setId(String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
        similarSentence.setResultId(resultDto.getId());
        similarSentence.setSentenceId(sentenceDto.getId());
        similarSentence.setSentence(similarSentenceStr);
        similarSentence.setFileName((String)similarResult.getAttachment("fileName"));
        Object location = similarResult.getAttachment("location");
        Object belongChapter = similarResult.getAttachment("belongChapter");
        if (belongChapter != null) {
            similarSentence.setBelongChapter((String)belongChapter);
        }
        if (location != null) {
            similarSentence.setLocation(location.toString());
        }
        if ((index = similarResult.getAttachment("index")) != null) {
            similarSentence.setSentenceIndex(Integer.valueOf(Integer.parseInt(index.toString())));
        }
        similarSentence.setSimilarity(similarResult.getSimilarty());
        return similarSentence;
    }

    private DuplicateCheckSentenceDto toSentence(DuplicateCheckSentenceResult sentenceResult) {
        Object belongChapter;
        Object index;
        String documentId = sentenceResult.getDocument_id();
        String sentenceStr = sentenceResult.getSentence();
        DuplicateCheckSentenceDto sentenceDto = new DuplicateCheckSentenceDto();
        sentenceDto.setId(String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
        sentenceDto.setDocId(documentId);
        sentenceDto.setSentence(sentenceStr);
        Object location = sentenceResult.getAttachment("location");
        if (location != null) {
            sentenceDto.setLocation(location.toString());
        }
        if ((index = sentenceResult.getAttachment("index")) != null) {
            sentenceDto.setSentenceIndex(Integer.valueOf(Integer.parseInt(index.toString())));
        }
        if ((belongChapter = sentenceResult.getAttachment("belongChapter")) != null) {
            sentenceDto.setBelongChapter((String)belongChapter);
        }
        sentenceDto.setConfirmFlag("0");
        sentenceDto.setIgnoreFlag("1");
        return sentenceDto;
    }

    private void similarityListForMap(List<DuplicateCheckSimilarityResult> similarityList) {
        if (CollectionUtils.isEmpty(similarityList)) {
            return;
        }
        for (DuplicateCheckSimilarityResult similarityResult : similarityList) {
            this.similarityMap.put(similarityResult.getUpload_document_id() + "_" + similarityResult.getDocument_id(), similarityResult.getSimilarity());
        }
    }

    private void updateDocInfo(String docId, String taskStatus, DuplicateCheckInfo checkInfo) {
        DuplicateCheckDocDto docDto = new DuplicateCheckDocDto();
        docDto.setId(docId);
        docDto.setUpdateLib("");
        docDto.setTaskStatus(taskStatus);
        docDto.setEndTime(LocalDateTime.now());
        docDto.setCandidateSentenceNum(checkInfo.getCandidateSentenceNum());
        docDto.setMaxSimilarity(this.maxSimilarity);
        docDto.setDocSimilarity(DoubleUtils.towDecimal((Double)this.docSimilarity.doubleValue()));
        this.docService.updateById(docDto);
    }

    private class SimilarCalculator {
        private BigDecimal bigDecimal = BigDecimal.valueOf(0L);
        private Map<String, Double> sentenceWithSimilarity = new HashMap<String, Double>();
        int count = 0;
        private Set<String> sentenceId;

        private SimilarCalculator() {
        }

        public void add(double value, String id) {
            Double similarity = this.sentenceWithSimilarity.getOrDefault(id, 0.0);
            if (similarity < value) {
                this.sentenceWithSimilarity.put(id, value);
            }
        }

        public double getSimilarity(int candidateSentenceNum) {
            this.sentenceWithSimilarity.values().forEach(k -> {
                this.bigDecimal = this.bigDecimal.add(BigDecimal.valueOf(k));
            });
            return this.bigDecimal.divide(BigDecimal.valueOf(candidateSentenceNum), 2, RoundingMode.HALF_UP).doubleValue();
        }
    }
}

