/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.executor.task.impl;

import com.jxdinfo.idp.icpac.core.context.DuplicateCheckContext;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckResult;
import com.jxdinfo.idp.icpac.core.executor.document.DuplicateCheckDocumentExecutor;
import com.jxdinfo.idp.icpac.core.executor.task.impl.AbstractDuplicateCheckTaskExecutor;
import com.jxdinfo.idp.icpac.core.executor.task.impl.DuplicateCheckDeleteTaskExecutor;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckResultHandler;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckUpdateModelEnum;
import com.jxdinfo.idp.icpac.core.rmi.resp.DuplicateCheckResponse;
import com.jxdinfo.idp.icpac.core.rmi.resp.DuplicateCheckVectorizatioResult;
import com.jxdinfo.idp.icpac.utils.DuplicateCheckProgress;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCheckCheckTaskExecutor
extends AbstractDuplicateCheckTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckCheckTaskExecutor.class);

    @Override
    public void runCheckTask() {
        DuplicateCheckContext checkContext = this.checkInfo.getContext();
        DuplicateCheckResultHandler resultHandler = this.checkInfo.getResultHandler();
        try {
            DuplicateCheckDocumentExecutor checkDocExecutor = this.checkInfo.getCheckDocumentExecutor();
            this.vectorization(checkDocExecutor);
            DuplicateCheckResult checkResult = this.executeCheck(this.checkInfo);
            if (resultHandler != null) {
                resultHandler.handleResult(checkResult);
            }
            DuplicateCheckProgress.setProgress(this.checkInfo.getDocumentId(), 100);
        }
        catch (Exception ex) {
            DuplicateCheckProgress.setFail(this.checkInfo.getDocumentId());
            DuplicateCheckResult checkResult = new DuplicateCheckResult();
            checkResult.setInfo(this.checkInfo);
            checkResult.setError(ex);
            if (resultHandler != null) {
                resultHandler.handleResult(checkResult);
            }
            log.info(this.checkInfo.getFileName() + "\u67e5\u91cd\u51fa\u73b0\u9519\u8bef", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void vectorization(DuplicateCheckDocumentExecutor checkDocExecutor) throws Exception {
        try {
            if (this.checkInfo.getUpdateModel() != DuplicateCheckUpdateModelEnum.NO_UPDATE) {
                DuplicateCheckVectorizatioResult vectorization;
                log.info(this.checkInfo.getFileName() + "\u5f00\u59cb\u5411\u91cf\u5316");
                if (this.checkInfo.isExecuteFailure()) {
                    DuplicateCheckDeleteTaskExecutor deleteTaskExecutor = new DuplicateCheckDeleteTaskExecutor();
                    DuplicateCheckInfo delCheckInfo = new DuplicateCheckInfo("mn_checkId", this.checkInfo.getLibId());
                    delCheckInfo.addAttachment("uploadIds", Collections.singletonList(this.checkInfo.getDocumentId()));
                    deleteTaskExecutor.init(delCheckInfo);
                    deleteTaskExecutor.run();
                }
                if ((vectorization = checkDocExecutor.vectorization(this.checkInfo)) != null) {
                    log.info(this.checkInfo.getFileName() + "\u5411\u91cf\u5316\u7ed3\u675f\uff0c\u5411\u91cf\u5316\u7684\u7ed3\u679c\u4e3a\uff1a" + vectorization.toString());
                }
            }
        }
        finally {
            DuplicateCheckContext context = this.checkInfo.getContext();
            context.waitOthers();
        }
    }

    private DuplicateCheckResult executeCheck(DuplicateCheckInfo checkInfo) throws Exception {
        DuplicateCheckResult checkResult = new DuplicateCheckResult();
        checkInfo.setCheckResult(checkResult);
        DuplicateCheckDocumentExecutor documentExecutor = checkInfo.getCheckDocumentExecutor();
        log.info(checkInfo.getFileName() + "\u5f00\u59cb\u8fdb\u884c\u67e5\u91cd");
        checkResult.setInfo(checkInfo);
        DuplicateCheckUpdateModelEnum updateModel = checkInfo.getUpdateModel();
        DuplicateCheckResponse response = null;
        response = updateModel == DuplicateCheckUpdateModelEnum.NO_UPDATE ? documentExecutor.checkRepeat(checkInfo) : documentExecutor.checkRepeatNoVectorization(checkInfo);
        checkResult.setExecutionResult(response);
        return checkResult;
    }
}

