/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.context;

import com.jxdinfo.idp.common.entity.util.docparse.word.WordChapterInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordElementInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordParagraphInfo;
import com.jxdinfo.idp.icpac.core.dochandler.DocumentHandler;
import com.jxdinfo.idp.icpac.core.dochandler.DocumentHandlerFactory;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class DuplicateCheckContext {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckContext.class);
    private final DuplicateCheckTask task;
    private volatile CyclicBarrier cyclicBarrier;
    private volatile CountDownLatch countDownLatch;
    private List<MultipartFile> templateFileList;
    private Map<String, List<String>> templateSentenceCollection;
    private int minWordLen;

    public DuplicateCheckContext(DuplicateCheckTask task) {
        this.task = task;
    }

    public void waitOthers() {
        try {
            this.cyclicBarrier.await();
        }
        catch (Exception e) {
            log.error("\u7b49\u5f85\u5176\u4ed6\u7ebf\u7a0b\u5411\u91cf\u5316\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
        log.info("\u5f53\u524d\u5b8c\u6210\u4efb\u52a1\u7684\u7ebf\u7a0b\u4e3a\uff1a{}", (Object)Thread.currentThread().getName());
    }

    public void completeOperation() {
        this.countDownLatch.countDown();
    }

    public void waitCompleteByOperation() {
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            log.error("\u7b49\u5f85\u5168\u90e8\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\u8d85\u65f6", (Throwable)e);
        }
    }

    public void init() {
        int needCheckCount = this.task.getNeedCheckCount();
        this.cyclicBarrier = new CyclicBarrier(needCheckCount);
        log.info("\u963b\u585e\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u5f53\u524d\u9700\u8981\u67e5\u91cd\u7684\u6570\u91cf\u4e3a\uff1a{}", (Object)needCheckCount);
        this.templateSentenceCollection = new HashMap<String, List<String>>();
        this.countDownLatch = new CountDownLatch(needCheckCount);
        this.handleTemplateFile();
    }

    private void handleTemplateFile() {
        if (CollectionUtils.isEmpty(this.templateFileList)) {
            return;
        }
        for (MultipartFile file : this.templateFileList) {
            StringBuilder sb = new StringBuilder();
            DocumentHandler handler = DocumentHandlerFactory.getDocumentHandler(file);
            try {
                List<WordChapterInfo> wordChapterList = handler.structuredDoc(file);
                this.mergeText(sb, wordChapterList);
                this.templateSentenceCollection.computeIfAbsent(file.getOriginalFilename(), k -> new ArrayList()).add(sb.toString());
            }
            catch (Exception e) {
                log.error("\u6a21\u7248\u6587\u4ef6\u89e3\u6790\u51fa\u9519", (Throwable)e);
            }
        }
    }

    private void mergeText(StringBuilder textContainer, List<WordChapterInfo> wordChapterList) {
        if (wordChapterList == null || wordChapterList.size() == 0) {
            return;
        }
        for (WordChapterInfo wordChapterInfo : wordChapterList) {
            List eInfoList = wordChapterInfo.getChildParagraphList();
            if (CollectionUtils.isNotEmpty((Collection)eInfoList)) {
                for (WordElementInfo info : eInfoList) {
                    if (!"para".equals(info.getType())) continue;
                    WordParagraphInfo pInfo = (WordParagraphInfo)info;
                    textContainer.append(pInfo.getText());
                }
            }
            this.mergeText(textContainer, wordChapterInfo.getChildChapterList());
        }
    }

    public List<String> getTemplateTextList() {
        ArrayList<String> templateTextList = new ArrayList<String>();
        for (Map.Entry<String, List<String>> tsc : this.templateSentenceCollection.entrySet()) {
            templateTextList.addAll((Collection<String>)tsc.getValue());
        }
        return templateTextList;
    }

    public DuplicateCheckTask getTask() {
        return this.task;
    }

    public CyclicBarrier getCyclicBarrier() {
        return this.cyclicBarrier;
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    public List<MultipartFile> getTemplateFileList() {
        return this.templateFileList;
    }

    public Map<String, List<String>> getTemplateSentenceCollection() {
        return this.templateSentenceCollection;
    }

    public int getMinWordLen() {
        return this.minWordLen;
    }

    public void setCyclicBarrier(CyclicBarrier cyclicBarrier) {
        this.cyclicBarrier = cyclicBarrier;
    }

    public void setCountDownLatch(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public void setTemplateFileList(List<MultipartFile> templateFileList) {
        this.templateFileList = templateFileList;
    }

    public void setTemplateSentenceCollection(Map<String, List<String>> templateSentenceCollection) {
        this.templateSentenceCollection = templateSentenceCollection;
    }

    public void setMinWordLen(int minWordLen) {
        this.minWordLen = minWordLen;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DuplicateCheckContext)) {
            return false;
        }
        DuplicateCheckContext other = (DuplicateCheckContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMinWordLen() != other.getMinWordLen()) {
            return false;
        }
        DuplicateCheckTask this$task = this.getTask();
        DuplicateCheckTask other$task = other.getTask();
        if (this$task == null ? other$task != null : !((Object)this$task).equals(other$task)) {
            return false;
        }
        CyclicBarrier this$cyclicBarrier = this.getCyclicBarrier();
        CyclicBarrier other$cyclicBarrier = other.getCyclicBarrier();
        if (this$cyclicBarrier == null ? other$cyclicBarrier != null : !this$cyclicBarrier.equals(other$cyclicBarrier)) {
            return false;
        }
        CountDownLatch this$countDownLatch = this.getCountDownLatch();
        CountDownLatch other$countDownLatch = other.getCountDownLatch();
        if (this$countDownLatch == null ? other$countDownLatch != null : !this$countDownLatch.equals(other$countDownLatch)) {
            return false;
        }
        List<MultipartFile> this$templateFileList = this.getTemplateFileList();
        List<MultipartFile> other$templateFileList = other.getTemplateFileList();
        if (this$templateFileList == null ? other$templateFileList != null : !((Object)this$templateFileList).equals(other$templateFileList)) {
            return false;
        }
        Map<String, List<String>> this$templateSentenceCollection = this.getTemplateSentenceCollection();
        Map<String, List<String>> other$templateSentenceCollection = other.getTemplateSentenceCollection();
        return !(this$templateSentenceCollection == null ? other$templateSentenceCollection != null : !((Object)this$templateSentenceCollection).equals(other$templateSentenceCollection));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DuplicateCheckContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMinWordLen();
        DuplicateCheckTask $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : ((Object)$task).hashCode());
        CyclicBarrier $cyclicBarrier = this.getCyclicBarrier();
        result = result * 59 + ($cyclicBarrier == null ? 43 : $cyclicBarrier.hashCode());
        CountDownLatch $countDownLatch = this.getCountDownLatch();
        result = result * 59 + ($countDownLatch == null ? 43 : $countDownLatch.hashCode());
        List<MultipartFile> $templateFileList = this.getTemplateFileList();
        result = result * 59 + ($templateFileList == null ? 43 : ((Object)$templateFileList).hashCode());
        Map<String, List<String>> $templateSentenceCollection = this.getTemplateSentenceCollection();
        result = result * 59 + ($templateSentenceCollection == null ? 43 : ((Object)$templateSentenceCollection).hashCode());
        return result;
    }

    public String toString() {
        return "DuplicateCheckContext(task=" + this.getTask() + ", cyclicBarrier=" + this.getCyclicBarrier() + ", countDownLatch=" + this.getCountDownLatch() + ", templateFileList=" + this.getTemplateFileList() + ", templateSentenceCollection=" + this.getTemplateSentenceCollection() + ", minWordLen=" + this.getMinWordLen() + ")";
    }
}

