/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.dio.service.DocInfoIoService;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckViewQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.SentenceQuery;
import com.jxdinfo.idp.duplicatecheck.api.service.IDuplicateCheckViewService;
import com.jxdinfo.idp.icpac.api.IDuplicateCheckDataServiceImpl;
import com.jxdinfo.idp.icpac.core.view.FrontViewHandler;
import com.jxdinfo.idp.icpac.core.view.FrontViewHandlerFactory;
import com.jxdinfo.idp.icpac.service.DuplicateCheckDocService;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public class IDuplicateCheckViewServiceImpl
implements IDuplicateCheckViewService {
    @Resource
    private DuplicateCheckDocService docService;
    @Resource
    private IDuplicateCheckDataServiceImpl dataService;
    @Resource
    private DocInfoIoService ioService;

    public byte[] getStream(DuplicateCheckViewQuery viewQuery) throws Exception {
        return new byte[0];
    }

    public void getStreamToHttp(DuplicateCheckViewQuery viewQuery, HttpServletResponse response) throws Exception {
        Page<DuplicateCheckSentenceDto> page;
        SentenceQuery sentenceQuery;
        DuplicateCheckDocDto documentInfo = null;
        List docLocationList = null;
        String documentId = viewQuery.getDocumentId();
        if (StringUtils.isEmpty((String)viewQuery.getSimilarDocumentId())) {
            documentInfo = this.docService.simpleDetail(documentId);
            sentenceQuery = new SentenceQuery();
            sentenceQuery.setDocumentId(documentId);
            sentenceQuery.setSimilarity(Double.valueOf(viewQuery.getSimilarity()));
            sentenceQuery.setPageFlag(false);
            page = this.dataService.getSentence(sentenceQuery);
            docLocationList = page.getRecords();
        } else {
            documentInfo = this.docService.simpleDetail(viewQuery.getSimilarDocumentId());
            sentenceQuery = new SentenceQuery();
            sentenceQuery.setDocumentId(documentId);
            sentenceQuery.setSimilarDocIdList(Arrays.asList(viewQuery.getSimilarDocumentId()));
            sentenceQuery.setSimilarity(Double.valueOf(viewQuery.getSimilarity()));
            sentenceQuery.setPageFlag(false);
            page = this.dataService.getSimilaritySentence(sentenceQuery);
            docLocationList = page.getRecords();
        }
        Long fileId = documentInfo.getFileId();
        FileBytesInfo fileBytesInfo = this.ioService.getFileBytesInfo(fileId);
        String fileName = fileBytesInfo.getFileName() + "." + fileBytesInfo.getFileFormat();
        MockMultipartFile file = new MockMultipartFile(fileName, fileName, null, fileBytesInfo.getFileBytes());
        FrontViewHandler frontViewHandler = FrontViewHandlerFactory.getHandler((MultipartFile)file);
        frontViewHandler.handleView(response, docLocationList, (MultipartFile)file);
    }
}

