/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.custom.sentencefilter;

import com.jxdinfo.idp.icpac.core.context.DuplicateCheckContext;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckCandidateSentence;
import com.jxdinfo.idp.icpac.core.handler.CandidateSentenceFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultCandidateSentenceFilter
implements CandidateSentenceFilter {
    private static final String DATE_REG = "\\d{4}[-/\u5e74]\\d{1,2}[-/\u6708]\\d{1,2}[\u65e5]?";
    private static final List<String> PUNCTUATION_LIST;
    private static final List<Pattern> PATTERN_LIST;

    @Override
    public List<DuplicateCheckCandidateSentence> filter(List<DuplicateCheckCandidateSentence> candidateSentenceList, DuplicateCheckContext context) {
        Iterator<DuplicateCheckCandidateSentence> csIter = candidateSentenceList.iterator();
        List<String> templateTextList = context.getTemplateTextList();
        if (CollectionUtils.isEmpty(templateTextList)) {
            return candidateSentenceList;
        }
        int minWordLen = context.getMinWordLen();
        ArrayList<DuplicateCheckCandidateSentence> newCandidateSentenceList = new ArrayList<DuplicateCheckCandidateSentence>();
        for (String templateText : templateTextList) {
            templateText = templateText.replaceAll(" ", "");
            while (csIter.hasNext()) {
                DuplicateCheckCandidateSentence cs = csIter.next();
                String csText = cs.getText();
                csText = csText.replaceAll(" ", "");
                if ((csText = csText.replaceAll(DATE_REG, " ")).endsWith(" ")) {
                    cs.setText(csText.trim());
                } else if (csText.contains(" ")) {
                    String[] csTextList;
                    for (String tmpCsText : csTextList = csText.split(" ")) {
                        if (tmpCsText.length() < minWordLen || templateText.contains(tmpCsText)) continue;
                        newCandidateSentenceList.add(new DuplicateCheckCandidateSentence(tmpCsText, new HashMap<String, Object>()));
                    }
                    csIter.remove();
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)csText) || csText.length() < minWordLen) {
                    csIter.remove();
                }
                if (!templateText.contains(csText)) continue;
                csIter.remove();
            }
        }
        return candidateSentenceList;
    }

    static {
        PATTERN_LIST = new ArrayList<Pattern>();
        PUNCTUATION_LIST = new ArrayList<String>();
        PUNCTUATION_LIST.add("\uff0c");
        PUNCTUATION_LIST.add("\u3002");
        PUNCTUATION_LIST.add("\uff1f");
    }
}

