/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.executor.task;

import com.jxdinfo.hutool.core.collection.CollectionUtil;
import com.jxdinfo.idp.duplicatecheck.api.call.DuplicatecheckOverInterface;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckGroupInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicatecheckCallTaskExecutor
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DuplicatecheckCallTaskExecutor.class);
    private List<DuplicateCheckGroupInfo> checkInfoGroupList;
    private List<DuplicatecheckOverInterface> censorOverInterfaces;
    private DuplicateCheckTask task;

    public DuplicatecheckCallTaskExecutor(DuplicateCheckTask task) {
        this.task = task;
        this.censorOverInterfaces = task.getCensorOverInterfaces();
        this.checkInfoGroupList = task.getGroupInfoList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.task.getCheckContext().waitCompleteByOperation();
            if (CollectionUtils.isNotEmpty(this.censorOverInterfaces)) {
                ArrayList<String> successGroupInfoIdList = new ArrayList<String>();
                ArrayList<String> failedGroupInfoIdList = new ArrayList<String>();
                HashMap<String, Boolean> checkInfoMap = new HashMap<String, Boolean>();
                for (DuplicateCheckGroupInfo groupInfo : this.checkInfoGroupList) {
                    for (DuplicateCheckInfo checkInfo : groupInfo.getInfoList()) {
                        checkInfoMap.put(checkInfo.getDocumentId(), checkInfo.isCheck());
                        log.info("\u7ec4\u67e5\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0c\u7ec4ID\u4e3a\uff1a{}\uff0c\u6587\u6863ID\u4e3a\uff1a{}", (Object)groupInfo.getGroupId(), (Object)checkInfo.getDocumentId());
                        if (checkInfo.getCheckResult().isSuccess()) {
                            successGroupInfoIdList.add(groupInfo.getGroupId());
                            continue;
                        }
                        failedGroupInfoIdList.add(groupInfo.getGroupId());
                    }
                }
                log.info("\u6c47\u603b\u5b8c\u6bd5");
                log.info("\u5f00\u59cb\u89e6\u53d1\u56de\u8c03");
                if (CollectionUtil.isNotEmpty(successGroupInfoIdList)) {
                    this.censorOverInterfaces.forEach(a -> a.successCall(successGroupInfoIdList, checkInfoMap));
                } else {
                    this.censorOverInterfaces.forEach(a -> a.failCall(failedGroupInfoIdList));
                }
                log.info("\u5f00\u59cb\u89e6\u53d1\u56de\u8c03\u7ed3\u675f");
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u56de\u8c03\u51fd\u6570\u51fa\u9519,\u9519\u8bef\u4e3a\uff1a", (Throwable)e);
        }
        finally {
            log.info("\u7ec4\u67e5\u91cd\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0c\u8017\u65f6\u4e3a\uff1a{}\u79d2", (Object)((System.currentTimeMillis() - this.task.getStartTime()) / 1000L));
            this.task.clear();
        }
    }
}

