/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.utils;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class DuplicateCheckProgress {
    private static final int PROCESS_PROGRESS = 100;
    private static StringRedisTemplate REDIS_TEMPLATE;
    private static final String PREFIX = "compare:process:";

    public DuplicateCheckProgress(@Autowired StringRedisTemplate redisTemplate) {
        REDIS_TEMPLATE = redisTemplate;
    }

    public static int getProgress(String key) {
        String processStr = (String)REDIS_TEMPLATE.opsForValue().get((Object)(PREFIX + key));
        if (processStr == null || StringUtils.isEmpty((CharSequence)processStr)) {
            return 100;
        }
        int process = Integer.parseInt(processStr);
        if (process == 100) {
            REDIS_TEMPLATE.delete((Object)(PREFIX + key));
        }
        return process;
    }

    public static void setFail(String key) {
        REDIS_TEMPLATE.opsForValue().set((Object)(PREFIX + key), (Object)"-1", 60L, TimeUnit.SECONDS);
    }

    public static void setProgress(String key, Integer speed) {
        REDIS_TEMPLATE.opsForValue().set((Object)(PREFIX + key), (Object)String.valueOf(speed), 1L, TimeUnit.HOURS);
    }

    public static void clear(List<String> ids) {
    }
}

