/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckChapterDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckChapter;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckChapterQuery;
import com.jxdinfo.idp.icpac.listen.baseinfo.DuplicateCheckProjectListener;
import com.jxdinfo.idp.icpac.listen.baseinfo.DuplicateCheckProjectListenerManger;
import com.jxdinfo.idp.icpac.listen.event.DuplicateCheckEvent;
import com.jxdinfo.idp.icpac.listen.event.MultiSimilarityEventType;
import com.jxdinfo.idp.icpac.mapper.DuplicateCheckChapterMapper;
import com.jxdinfo.idp.icpac.service.DuplicateCheckChapterService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DuplicateCheckChapterServiceImpl
extends ServiceImpl<DuplicateCheckChapterMapper, DuplicateCheckChapter>
implements DuplicateCheckChapterService,
DuplicateCheckProjectListener {
    @Resource
    private DuplicateCheckChapterMapper mapper;

    public DuplicateCheckChapterServiceImpl() {
        DuplicateCheckProjectListenerManger.register(this);
    }

    @Override
    public boolean insert(List<? extends DuplicateCheckChapter> chapterDtoList, String projectId) {
        if (CollectionUtils.isEmpty(chapterDtoList)) {
            return true;
        }
        List chapterList = DuplicateCheckChapter.toChapterEntity(chapterDtoList);
        chapterList.forEach(t -> {
            t.setId(String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
            t.setProjectId(projectId);
        });
        return this.saveBatch(chapterList);
    }

    @Override
    public void update(List<? extends DuplicateCheckChapter> chapterDtoList, String projectId, String belongUser) {
        if (chapterDtoList == null || chapterDtoList.isEmpty()) {
            return;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DuplicateCheckChapter::getProjectId, (Object)projectId);
        List chapterList = this.list((Wrapper)wrapper);
        Set idSet = chapterList.stream().map(DuplicateCheckChapter::getId).collect(Collectors.toSet());
        ArrayList<DuplicateCheckChapter> updateCollection = new ArrayList<DuplicateCheckChapter>();
        ArrayList<DuplicateCheckChapter> insertCollection = new ArrayList<DuplicateCheckChapter>();
        for (DuplicateCheckChapter duplicateCheckChapter : chapterDtoList) {
            String id = duplicateCheckChapter.getId();
            if (StringUtils.isEmpty((CharSequence)id)) {
                duplicateCheckChapter.setId(String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
                duplicateCheckChapter.setProjectId(projectId);
                insertCollection.add(duplicateCheckChapter);
                continue;
            }
            updateCollection.add(duplicateCheckChapter);
            idSet.remove(id);
        }
        this.removeByIds(idSet);
        if (CollectionUtils.isNotEmpty(updateCollection)) {
            this.updateBatchById(updateCollection);
        }
        if (CollectionUtils.isNotEmpty(insertCollection)) {
            this.saveBatch(insertCollection);
        }
    }

    @Override
    public void deleteByProjectIds(List<String> projectIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(DuplicateCheckChapter::getProjectId, projectIds);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public List<DuplicateCheckChapterDto> getByProjectId(String projectId) {
        DuplicateCheckChapterQuery chapterQuery = new DuplicateCheckChapterQuery(projectId);
        return this.mapper.list(chapterQuery);
    }

    @Override
    public void onEvent(DuplicateCheckEvent event) {
        if (event.getEventType() != MultiSimilarityEventType.DELETE) {
            return;
        }
        Object data = event.getData();
        if (data instanceof List) {
            List projectIds = (List)data;
            this.deleteByProjectIds(projectIds);
        }
    }
}

