/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.executor.pool;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ThreadPoolManager {
    private static final List<ThreadPoolExecutor> POOL_EXECUTOR_LIST = new ArrayList<ThreadPoolExecutor>();
    private static final ReentrantLock LOCK = new ReentrantLock();

    public static void addThreadPool(ThreadPoolExecutor poolExecutor) {
        LOCK.lock();
        try {
            POOL_EXECUTOR_LIST.add(poolExecutor);
        }
        finally {
            LOCK.unlock();
        }
    }

    @Scheduled(cron="0 0 */1 * * ?")
    public void clear() {
        LOCK.lock();
        LOCK.unlock();
    }
}

