/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.paramconfig;

import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckConfig;
import com.jxdinfo.idp.icpac.core.paramconfig.DuplicateCheckConfigService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DefaultParamConfig {
    public static String url = "http://192.168.2.21:8906";
    private String tmpUrl;
    private static final String URL_CODE = "1";
    public static double defaultSimilarity = 80.0;
    private static final String DEFAULT_SIMILARITY_CODE = "2";
    public static int wordLength = 10;
    public static String WORD_LENGTH_CODE = "3";
    public static int tableWordLength = 15;
    public static String TABLE_WORD_LENGTH_CODE = "4";
    public static int maxWordLength = 70;
    public static String MAX_WORD_LENGTH_CODE = "5";
    private final DuplicateCheckConfigService checkConfigService;

    public DefaultParamConfig(DuplicateCheckConfigService checkConfigService, @Value(value="${duplicatecheck.url:http://192.168.2.21:8906}") String tmpUrl) {
        this.checkConfigService = checkConfigService;
        url = tmpUrl;
        this.setDefaultParam();
    }

    public void refresh() {
        this.setDefaultParam();
    }

    private void setDefaultParam() {
        DuplicateCheckConfig config = this.checkConfigService.getConfigByCode(URL_CODE);
        if (config != null) {
            url = config.getContent();
        }
        if ((config = this.checkConfigService.getConfigByCode(DEFAULT_SIMILARITY_CODE)) != null) {
            defaultSimilarity = Double.parseDouble(config.getContent());
        }
        if ((config = this.checkConfigService.getConfigByCode(WORD_LENGTH_CODE)) != null) {
            wordLength = Integer.parseInt(config.getContent());
        }
        if ((config = this.checkConfigService.getConfigByCode(TABLE_WORD_LENGTH_CODE)) != null) {
            tableWordLength = Integer.parseInt(config.getContent());
        }
        if ((config = this.checkConfigService.getConfigByCode(MAX_WORD_LENGTH_CODE)) != null) {
            defaultSimilarity = Integer.parseInt(config.getContent());
        }
    }

    public void setDefaultSimilarity(double similarity) {
        this.checkConfigService.setConfig(DEFAULT_SIMILARITY_CODE, String.valueOf(similarity));
        this.refresh();
    }

    public void setWordLength(int wordLength) {
        this.checkConfigService.setConfig(WORD_LENGTH_CODE, String.valueOf(wordLength));
        this.refresh();
    }

    public void setTableWordLength(int tableWordLength) {
        this.checkConfigService.setConfig(TABLE_WORD_LENGTH_CODE, String.valueOf(tableWordLength));
        this.refresh();
    }

    public void setMaxWordLength(int maxWordLength) {
        this.checkConfigService.setConfig(MAX_WORD_LENGTH_CODE, String.valueOf(maxWordLength));
        this.refresh();
    }

    public void setUrl(String url) {
        this.checkConfigService.setConfig(URL_CODE, String.valueOf(url));
        this.refresh();
    }
}

