/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.entity;

import cn.hutool.core.util.IdUtil;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckOperationEnum;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.multipart.MultipartFile;

public class DuplicateCheckGroupInfo {
    private String groupId;
    private List<DuplicateCheckInfo> infoList = new ArrayList<DuplicateCheckInfo>();
    private List<String> excludeDocumentIdList;
    private DuplicateCheckOperationEnum operationEnum;
    private List<MultipartFile> templateFileList;

    public DuplicateCheckGroupInfo(String groupId, List<DuplicateCheckInfo> infoList, List<String> excludeDocumentIdList, DuplicateCheckOperationEnum operationEnum) {
        this.groupId = groupId;
        this.infoList = infoList;
        this.excludeDocumentIdList = excludeDocumentIdList;
        this.operationEnum = operationEnum;
        infoList.forEach(k -> k.setGroupInfo(this));
    }

    public DuplicateCheckGroupInfo(List<DuplicateCheckInfo> infoList, DuplicateCheckOperationEnum operationEnum) {
        this(IdUtil.simpleUUID(), infoList, new ArrayList<String>(), operationEnum);
    }

    public DuplicateCheckGroupInfo() {
        this.groupId = IdUtil.simpleUUID();
    }

    public void setInfoList(List<DuplicateCheckInfo> infoList) {
        infoList.forEach(k -> k.setGroupInfo(this));
        this.infoList = infoList;
    }

    public void addCheckInfo(DuplicateCheckInfo checkInfo) {
        this.infoList.add(checkInfo);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public List<DuplicateCheckInfo> getInfoList() {
        return this.infoList;
    }

    public List<String> getExcludeDocumentIdList() {
        return this.excludeDocumentIdList;
    }

    public DuplicateCheckOperationEnum getOperationEnum() {
        return this.operationEnum;
    }

    public List<MultipartFile> getTemplateFileList() {
        return this.templateFileList;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setExcludeDocumentIdList(List<String> excludeDocumentIdList) {
        this.excludeDocumentIdList = excludeDocumentIdList;
    }

    public void setOperationEnum(DuplicateCheckOperationEnum operationEnum) {
        this.operationEnum = operationEnum;
    }

    public void setTemplateFileList(List<MultipartFile> templateFileList) {
        this.templateFileList = templateFileList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DuplicateCheckGroupInfo)) {
            return false;
        }
        DuplicateCheckGroupInfo other = (DuplicateCheckGroupInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        List<DuplicateCheckInfo> this$infoList = this.getInfoList();
        List<DuplicateCheckInfo> other$infoList = other.getInfoList();
        if (this$infoList == null ? other$infoList != null : !((Object)this$infoList).equals(other$infoList)) {
            return false;
        }
        List<String> this$excludeDocumentIdList = this.getExcludeDocumentIdList();
        List<String> other$excludeDocumentIdList = other.getExcludeDocumentIdList();
        if (this$excludeDocumentIdList == null ? other$excludeDocumentIdList != null : !((Object)this$excludeDocumentIdList).equals(other$excludeDocumentIdList)) {
            return false;
        }
        DuplicateCheckOperationEnum this$operationEnum = this.getOperationEnum();
        DuplicateCheckOperationEnum other$operationEnum = other.getOperationEnum();
        if (this$operationEnum == null ? other$operationEnum != null : !((Object)((Object)this$operationEnum)).equals((Object)other$operationEnum)) {
            return false;
        }
        List<MultipartFile> this$templateFileList = this.getTemplateFileList();
        List<MultipartFile> other$templateFileList = other.getTemplateFileList();
        return !(this$templateFileList == null ? other$templateFileList != null : !((Object)this$templateFileList).equals(other$templateFileList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DuplicateCheckGroupInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        List<DuplicateCheckInfo> $infoList = this.getInfoList();
        result = result * 59 + ($infoList == null ? 43 : ((Object)$infoList).hashCode());
        List<String> $excludeDocumentIdList = this.getExcludeDocumentIdList();
        result = result * 59 + ($excludeDocumentIdList == null ? 43 : ((Object)$excludeDocumentIdList).hashCode());
        DuplicateCheckOperationEnum $operationEnum = this.getOperationEnum();
        result = result * 59 + ($operationEnum == null ? 43 : ((Object)((Object)$operationEnum)).hashCode());
        List<MultipartFile> $templateFileList = this.getTemplateFileList();
        result = result * 59 + ($templateFileList == null ? 43 : ((Object)$templateFileList).hashCode());
        return result;
    }

    public String toString() {
        return "DuplicateCheckGroupInfo(groupId=" + this.getGroupId() + ", infoList=" + this.getInfoList() + ", excludeDocumentIdList=" + this.getExcludeDocumentIdList() + ", operationEnum=" + (Object)((Object)this.getOperationEnum()) + ", templateFileList=" + this.getTemplateFileList() + ")";
    }
}

