/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.api;

import cn.hutool.core.util.IdUtil;
import com.jxdinfo.idp.common.dtobase.IDPApiResponseDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocumentCollection;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocumentGroup;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckProcess;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckRequestDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckDoc;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckDocQuery;
import com.jxdinfo.idp.duplicatecheck.api.service.DuplicateCheckOperationService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckMonitorService;
import com.jxdinfo.idp.icpac.utils.DuplicateCheckProgress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
public class DuplicateCheckOperationServiceImpl
implements DuplicateCheckOperationService {
    @Resource
    private DuplicateCheckMonitorService duplicateCheckMonitorService;
    @Resource
    private DuplicateCheckDocService docService;

    public List<? extends DuplicateCheckDoc> initLibDocument(DuplicateCheckDocumentCollection documentCollection) {
        return this.duplicateCheckMonitorService.initLibDocument(documentCollection);
    }

    public void checkDuplicate(List<DuplicateCheckDocumentGroup> taskGroupList, DuplicateCheckRequestDto duplicateCheckRequestDto) throws Exception {
        this.duplicateCheckMonitorService.checkDuplicate(taskGroupList, duplicateCheckRequestDto);
    }

    public void checkDuplicate(List<DuplicateCheckDocumentGroup> taskGroupList) throws Exception {
        this.checkDuplicate(taskGroupList, new DuplicateCheckRequestDto(null, Boolean.valueOf(false)));
    }

    public void checkDuplicate(String projectId) throws Exception {
        List<DuplicateCheckDocDto> checkDocList = this.docService.listByProjectId(projectId);
        ArrayList<DuplicateCheckDocumentGroup> taskGroupList = new ArrayList<DuplicateCheckDocumentGroup>();
        for (DuplicateCheckDocDto checkDoc : checkDocList) {
            DuplicateCheckDocumentGroup documentGroup = new DuplicateCheckDocumentGroup();
            documentGroup.setGroupId(IdUtil.simpleUUID());
            documentGroup.setSegmentation(true);
            documentGroup.setDocumentIdList(Collections.singletonList(checkDoc.getId()));
            taskGroupList.add(documentGroup);
        }
        this.checkDuplicate(taskGroupList);
    }

    public List<DuplicateCheckDocDto> getStatus(String projectId, String documentId) {
        DuplicateCheckDocQuery docQuery = new DuplicateCheckDocQuery();
        docQuery.setProjectId(projectId);
        docQuery.setDocumentId(documentId);
        docQuery.setPageFlag(false);
        return this.docService.list(docQuery).getRecords();
    }

    public IDPApiResponseDto addIgnoreSentence(String sentenceId, String globalIgnoreFlag) {
        this.duplicateCheckMonitorService.addIgnoreSentence(sentenceId, globalIgnoreFlag);
        return new IDPApiResponseDto();
    }

    public IDPApiResponseDto cancelIgnoreSentence(String sentenceId) {
        this.duplicateCheckMonitorService.cancelIgnoreSentence(sentenceId);
        return new IDPApiResponseDto();
    }

    public IDPApiResponseDto<DuplicateCheckProcess> getProcess(String documentId) {
        Integer progress = DuplicateCheckProgress.getProgress(documentId);
        DuplicateCheckProcess duplicateCheckProcess = new DuplicateCheckProcess();
        duplicateCheckProcess.setProcess(progress.intValue());
        return duplicateCheckProcess;
    }
}

