/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.context;

import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckTask;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCheckContext {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckContext.class);
    private final DuplicateCheckTask task;
    private volatile CyclicBarrier cyclicBarrier;
    private final List<Thread> waitThread;
    private volatile AtomicInteger vectorizationCount = new AtomicInteger(0);

    public DuplicateCheckContext(DuplicateCheckTask task) {
        this.task = task;
        this.waitThread = new CopyOnWriteArrayList<Thread>();
    }

    public void waitOthers() {
        try {
            this.cyclicBarrier.await();
        }
        catch (Exception e) {
            log.error("\u7b49\u5f85\u5176\u4ed6\u7ebf\u7a0b\u5411\u91cf\u5316\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
        log.info("\u5f53\u524d\u7ebf\u7a0b\u7b49\u5f85\u5176\u4ed6\u7ebf\u7a0b\u521d\u59cb\u5316\u5b8c\u6bd5\uff1a{}", (Object)Thread.currentThread().getName());
    }

    public void init() {
        int needCheckCount = this.task.getNeedCheckCount();
        this.cyclicBarrier = new CyclicBarrier(needCheckCount);
        log.info("\u963b\u585e\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u5f53\u524d\u9700\u8981\u67e5\u91cd\u7684\u6570\u91cf\u4e3a\uff1a{}", (Object)needCheckCount);
    }
}

