/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.api.third;

import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hutool.core.date.LocalDateTimeUtil;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckResultDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSimilarSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSimilarityInfo;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckDocQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSimilarityInfoQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.SentenceQuery;
import com.jxdinfo.idp.duplicatecheck.api.service.DuplicateCheckDocumentService;
import com.jxdinfo.idp.duplicatecheck.api.service.IDuplicateCheckDataService;
import com.jxdinfo.idp.duplicatecheck.api.third.DuplicateCheckThirdDataService;
import com.jxdinfo.idp.duplicatecheck.api.third.emtity.query.SimilarityDataQuery;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.springframework.stereotype.Component;

@Component
public class DuplicateCheckThirdDataServiceImpl
implements DuplicateCheckThirdDataService {
    @Resource
    IDuplicateCheckDataService dataService;
    @Resource
    DuplicateCheckDocumentService documentService;

    public Page<DuplicateCheckSentenceDto> getSentenceWithMaxSimiSentence(SimilarityDataQuery dataQuery) {
        List documentIdList = dataQuery.getDocumentIdList();
        Double similarity = dataQuery.getSimilarity();
        ArrayList sentenceDtoList = new ArrayList();
        for (String documentId : documentIdList) {
            SentenceQuery sentenceQuery = new SentenceQuery();
            if (similarity != null) {
                sentenceQuery.setSimilarity(similarity);
            }
            if (StringUtils.isNotEmpty((CharSequence)dataQuery.getIgnoreFlag())) {
                sentenceQuery.setIgnoreFlag(dataQuery.getIgnoreFlag());
            }
            if (CollectionUtils.isNotEmpty((Collection)dataQuery.getSimilarityDocumentIdList())) {
                sentenceQuery.setSimilarDocIdList(dataQuery.getSimilarityDocumentIdList());
            }
            sentenceQuery.setDocumentId(documentId);
            sentenceQuery.setPageFlag(false);
            Page sentence = this.dataService.getSentenceWithMaxSimiSentence(sentenceQuery);
            List records = sentence.getRecords();
            if (!CollectionUtils.isNotEmpty((Collection)records)) continue;
            sentenceDtoList.addAll(records);
        }
        Page page = new Page();
        page.setRecords(sentenceDtoList);
        page.setTotal((long)sentenceDtoList.size());
        return page;
    }

    @Deprecated
    private List<DuplicateCheckSentenceDto> filter(List<DuplicateCheckSentenceDto> records, List<String> similarityDocumentIdList) {
        if (CollectionUtils.isEmpty(similarityDocumentIdList)) {
            return records;
        }
        Iterator<DuplicateCheckSentenceDto> recordIter = records.iterator();
        while (recordIter.hasNext()) {
            DuplicateCheckSentenceDto sentenceDto = recordIter.next();
            List similarSentenceList = sentenceDto.getSimilarSentenceList();
            Iterator sentenceDtoIterator = similarSentenceList.iterator();
            while (sentenceDtoIterator.hasNext()) {
                DuplicateCheckSimilarSentenceDto similarSentenceDto = (DuplicateCheckSimilarSentenceDto)sentenceDtoIterator.next();
                String similarityDocId = similarSentenceDto.getSimilarityDocId();
                if (!similarityDocumentIdList.contains(similarityDocId)) continue;
                sentenceDtoIterator.remove();
            }
            if (!CollectionUtils.isEmpty((Collection)similarSentenceList)) continue;
            recordIter.remove();
        }
        return records;
    }

    public void downloadCheckDuplicateReportToHttp(HttpServletResponse response, SimilarityDataQuery dataQuery) throws IOException {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\u67e5\u91cd\u62a5\u544a.docx");
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write(this.downloadCheckDuplicateReport(dataQuery));
        outputStream.flush();
    }

    public List<Map<String, Object>> getGroupSimilarityInfo(SimilarityDataQuery dataQuery) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List groupInfoList = dataQuery.getGroupInfoList();
        HashMap map = new HashMap();
        for (SimilarityDataQuery.GroupInfo groupInfo : groupInfoList) {
            List documentIdList = groupInfo.getDocumentIdList();
            documentIdList.forEach(k -> map.put(k, groupInfo));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("groupId", groupInfo.getGroupId());
            hashMap.put("similarity", 0.0);
            hashMap.put("groupName", groupInfo.getGroupName());
            result.add(hashMap);
        }
        List documentIdList = dataQuery.getDocumentIdList();
        HashMap<String, Map> groupMap = new HashMap<String, Map>();
        for (String string : documentIdList) {
            DuplicateCheckDocQuery docQuery = new DuplicateCheckDocQuery();
            docQuery.setDocumentId(string);
            Page similarityDocument = this.dataService.getSimilarityDocument(docQuery);
            List sdList = similarityDocument.getRecords();
            for (DuplicateCheckResultDto resultDto : sdList) {
                String similarDocId = resultDto.getSimilarDocId();
                SimilarityDataQuery.GroupInfo groupInfo = (SimilarityDataQuery.GroupInfo)map.get(similarDocId);
                if (groupInfo == null) continue;
                List groupResultList = groupMap.computeIfAbsent(groupInfo.getGroupId(), k -> new HashMap()).computeIfAbsent(string, k -> new ArrayList());
                groupResultList.add(resultDto);
            }
        }
        for (Map map2 : result) {
            String groupId = (String)map2.get("groupId");
            Map documentSimiMap = (Map)groupMap.get(groupId);
            if (documentSimiMap == null) continue;
            BigDecimal bigDecimal = new BigDecimal(0);
            Collection documentSimiList = documentSimiMap.values();
            for (List duplicateCheckResultList : documentSimiList) {
                BigDecimal tempDocumentSimiSum = new BigDecimal(0);
                for (DuplicateCheckResultDto resultDto : duplicateCheckResultList) {
                    Double similarity = resultDto.getSimilarity();
                    tempDocumentSimiSum = tempDocumentSimiSum.add(BigDecimal.valueOf(similarity));
                }
                bigDecimal = bigDecimal.add(tempDocumentSimiSum.divide(BigDecimal.valueOf(duplicateCheckResultList.size()), 6, RoundingMode.HALF_UP));
            }
            double similarity = bigDecimal.divide(BigDecimal.valueOf(documentSimiMap.size()), 6, RoundingMode.HALF_UP).doubleValue();
            map2.put("similarity", this.format(similarity));
        }
        return result;
    }

    private String format(double value) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        return decimalFormat.format(value);
    }

    public Page<DuplicateCheckDocDto> getDocumentInfo(List<String> documentIdList) {
        ArrayList<DuplicateCheckDocDto> documentInfoList = new ArrayList<DuplicateCheckDocDto>();
        for (String documentId : documentIdList) {
            String fileSize;
            DuplicateCheckDocDto documentInfo = this.documentService.detail(documentId);
            String fileUnit = documentInfo.getFileUnit();
            if (Objects.equals(fileUnit, "MB")) {
                fileSize = documentInfo.getFileSize();
                documentInfo.setFileSize(String.valueOf(Double.parseDouble(fileSize) * 1024.0 * 1024.0));
                documentInfo.setFileUnit("B");
            } else if (Objects.equals(fileUnit, "KB")) {
                fileSize = documentInfo.getFileSize();
                documentInfo.setFileSize(String.valueOf(Double.parseDouble(fileSize) * 1024.0));
                documentInfo.setFileUnit("B");
            }
            documentInfoList.add(documentInfo);
        }
        Page page = new Page();
        page.setTotal((long)documentIdList.size());
        page.setRecords(documentInfoList);
        return page;
    }

    public DuplicateCheckSimilarityInfo getSimilarityInfo(List<String> documentIdList) {
        DuplicateCheckSimilarityInfo similarityInfo = new DuplicateCheckSimilarityInfo();
        BigDecimal docSimilaritySum = BigDecimal.valueOf(0L);
        for (String documentId : documentIdList) {
            DuplicateCheckSimilarityInfoQuery similarityInfoQuery = new DuplicateCheckSimilarityInfoQuery();
            similarityInfoQuery.setDocumentId(documentId);
            DuplicateCheckSimilarityInfo tempSimilarity = this.dataService.getSimilarityInfo(similarityInfoQuery);
            double docSimilarity = tempSimilarity.getDocSimilarity() == null ? 0.0 : tempSimilarity.getDocSimilarity();
            docSimilaritySum = docSimilaritySum.add(BigDecimal.valueOf(docSimilarity));
            Double maxSimilarity = tempSimilarity.getMaxSimilarity();
            if (similarityInfo.getMaxSimilarity() == null || Double.compare(maxSimilarity, similarityInfo.getMaxSimilarity()) > 0) {
                similarityInfo.setMaxSimilarity(maxSimilarity);
            }
            similarityInfo.setCandidateSentenceNum(similarityInfo.getCandidateSentenceNum() + tempSimilarity.getCandidateSentenceNum());
            similarityInfo.setIgnoreSentenceCount(similarityInfo.getIgnoreSentenceCount() + tempSimilarity.getIgnoreSentenceCount());
            similarityInfo.setLe80PreCount(similarityInfo.getLe80PreCount() + tempSimilarity.getLe80PreCount());
            similarityInfo.setRepeatDocCount(similarityInfo.getRepeatDocCount() + tempSimilarity.getRepeatDocCount());
        }
        similarityInfo.setLe80PreProportion(similarityInfo.getLe80PreCount() + "/" + similarityInfo.getCandidateSentenceNum());
        if (documentIdList.size() != 0) {
            similarityInfo.setDocSimilarity(Double.valueOf(docSimilaritySum.divide(BigDecimal.valueOf(documentIdList.size()), 6, RoundingMode.HALF_UP).doubleValue()));
        }
        return similarityInfo;
    }

    private byte[] getWord(Map<String, Object> reportInfo) throws IOException {
        try (XWPFDocument document = new XWPFDocument();){
            XWPFParagraph paragraph = document.createParagraph();
            DuplicateCheckDocDto docInfo = (DuplicateCheckDocDto)reportInfo.get("docInfo");
            paragraph.setAlignment(ParagraphAlignment.CENTER);
            XWPFRun titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("\u53ef\u7814\u67e5\u91cd\u5de5\u5177");
            titleParagraphRun.setFontSize(14);
            titleParagraphRun.setBold(true);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.CENTER);
            titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("\u67e5\u91cd\u62a5\u544a");
            titleParagraphRun.setFontSize(14);
            titleParagraphRun.setBold(true);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            List sentenceList = (List)reportInfo.get("topSentence");
            DuplicateCheckSimilarityInfo similarityInfo = (DuplicateCheckSimilarityInfo)reportInfo.get("similarityInfo");
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("\u57fa\u672c\u4fe1\u606f\uff1a");
            titleParagraphRun.setFontSize(12);
            titleParagraphRun.setBold(true);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            XWPFTable table = document.createTable();
            table.setWidth("96%");
            XWPFTableRow headerRow = table.getRow(0);
            headerRow.getCell(0).setText("\u62a5\u544a\u7f16\u53f7");
            headerRow.getCell(0).setWidth("25%");
            headerRow.addNewTableCell().setText((String)reportInfo.get("reportNo"));
            headerRow.getCell(1).setWidth("75%");
            XWPFTableRow dataRow = table.createRow();
            dataRow.getCell(0).setText("\u6587\u6863\u6807\u9898");
            dataRow.getCell(0).setWidth("25%");
            dataRow.getCell(1).setText(docInfo.getFileName());
            dataRow.getCell(1).setWidth("75%");
            dataRow = table.createRow();
            dataRow.getCell(0).setText("\u68c0\u6d4b\u65f6\u95f4");
            dataRow.getCell(0).setWidth("25%");
            dataRow.getCell(1).setText(LocalDateTimeUtil.format((LocalDateTime)docInfo.getStartTime(), (String)"yyyy-MM-dd"));
            dataRow.getCell(1).setWidth("75%");
            dataRow = table.createRow();
            dataRow.getCell(0).setText("\u68c0\u6d4b\u5927\u5c0f");
            dataRow.getCell(0).setWidth("25%");
            dataRow.getCell(1).setText(docInfo.getFileSize() + docInfo.getFileUnit());
            dataRow.getCell(1).setWidth("75%");
            paragraph = document.createParagraph();
            XWPFRun brRun = paragraph.createRun();
            brRun.addBreak();
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("\u76f8\u4f3c\u6027\u68c0\u6d4b\u7ed3\u679c\uff1a");
            titleParagraphRun.setFontSize(12);
            titleParagraphRun.setBold(true);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            titleParagraphRun = paragraph.createRun();
            String complain = String.format("\u76f8\u4f3c\u8bed\u53e5\u6570\u91cf\uff1a%s\uff1b\u91cd\u590d\u6587\u6863\u6570\u91cf\uff1a%s\uff1b\u6700\u9ad8\u76f8\u4f3c\u5ea6\uff1a%s\uff1b\u67e5\u91cd\u7387\uff1a%s\uff1b\u5927\u4e8e80\u7684\u76f8\u4f3c\u5ea6\u5360\u6bd4\uff1a%s", sentenceList.size(), similarityInfo.getRepeatDocCount(), similarityInfo.getMaxSimilarity(), similarityInfo.getDocSimilarity(), similarityInfo.getLe80PreCount());
            titleParagraphRun.setText(complain);
            titleParagraphRun.setFontSize(12);
            titleParagraphRun.setBold(true);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            paragraph = document.createParagraph();
            brRun = paragraph.createRun();
            brRun.addBreak();
            for (DuplicateCheckSentenceDto sentenceDto : sentenceList) {
                DuplicateCheckSimilarSentenceDto similarSentence = (DuplicateCheckSimilarSentenceDto)sentenceDto.getSimilarSentenceList().get(0);
                XWPFTable table1 = document.createTable();
                table1.setWidth("96%");
                headerRow = table1.getRow(0);
                headerRow.getCell(0).setText("\u539f\u6587\u6863");
                headerRow.getCell(0).setWidth("50%");
                headerRow.addNewTableCell().setText("\u5bf9\u6bd4\u6587\u6863");
                headerRow.getCell(1).setWidth("50%");
                XWPFTableRow row = table1.createRow();
                row.getCell(0).setText("\u300a" + sentenceDto.getFileName() + "\u300b");
                row.getCell(0).setWidth("50%");
                row.getCell(1).setText("\u300a" + similarSentence.getFileName() + "\u300b");
                row.getCell(1).setWidth("50%");
                row = table1.createRow();
                XWPFTableCell cell = row.getCell(0);
                cell.getCTTc().addNewTcPr().addNewHMerge().setVal(STMerge.RESTART);
                cell.setText("\u76f8\u4f3c\u5ea6:" + similarSentence.getSimilarity() + "%");
                cell.setWidth("100%");
                XWPFTableCell cell1 = row.getCell(1);
                cell1.getCTTc().addNewTcPr().addNewHMerge().setVal(STMerge.CONTINUE);
                row = table1.createRow();
                row.getCell(0).setText(sentenceDto.getSentence());
                row.getCell(0).setWidth("50%");
                row.getCell(1).setText(similarSentence.getSentence());
                row.getCell(1).setWidth("50%");
                paragraph = document.createParagraph();
                brRun = paragraph.createRun();
                brRun.addBreak();
            }
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("\u67e5\u91cd\u5de5\u5177\u4fe1\u606f\uff1a");
            titleParagraphRun.setFontSize(12);
            titleParagraphRun.setBold(true);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            XWPFTable table2 = document.createTable();
            table2.setWidth("96%");
            headerRow = table2.getRow(0);
            headerRow.getCell(0).setText("\u67e5\u91cd\u5de5\u5177");
            headerRow.addNewTableCell().setText("\u5b89\u5fbd\u53ef\u7814\u67e5\u91cd\u5de5\u5177");
            headerRow.getCell(0).setWidth("25%");
            headerRow.getCell(1).setWidth("75%");
            dataRow = table2.createRow();
            dataRow.getCell(0).setText("\u7248\u672c\u4fe1\u606f");
            dataRow.getCell(0).setWidth("25%");
            dataRow.getCell(1).setText("V1.0.0");
            dataRow.getCell(1).setWidth("75%");
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("\u9690\u79c1\u4e0e\u7248\u6743\u58f0\u660e\uff1a");
            titleParagraphRun.setFontSize(12);
            titleParagraphRun.setBold(true);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("1\u3001\u62a5\u544a\u7f16\u53f7\u7cfb\u9001\u68c0\u6587\u6863\u67e5\u91cd\u62a5\u544a\u5728\u672c\u7cfb\u7edf\u4e2d\u7684\u552f\u4e00\u7f16\u53f7\u3002");
            titleParagraphRun.setFontSize(12);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("2\u3001\u672c\u62a5\u544a\u4e3a\u7cfb\u7edf\u7b97\u6cd5\u81ea\u52a8\u751f\u6210\uff0c\u4ec5\u5bf9\u60a8\u6240\u9009\u62e9\u6bd4\u5bf9\u8d44\u6e90\u8303\u56f4\u5185\u68c0\u9a8c\u7ed3\u679c\u8d1f\u8d23\uff0c\u4ec5\u4f9b\u53c2\u8003\u3002");
            titleParagraphRun.setFontSize(12);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("3\u3001\u300a\u67e5\u91cd\u62a5\u544a\u300b\u5c0a\u91cd\u5e76\u4fdd\u62a4\u6240\u6709\u4f7f\u7528\u670d\u52a1\u7528\u6237\u7684\u4e2a\u4eba\u9690\u79c1\u6743\u3002\u4e3a\u4e86\u7ed9\u60a8\u63d0\u4f9b\u66f4\u51c6\u786e\u3001\u66f4\u6709\u4e2a\u6027\u5316\u7684\u670d\u52a1\uff0c\u300a\u67e5\u91cd\u62a5\u544a\u300b\u4f1a\u6309\u7167\u672c\u9690\u79c1\u6743\u653f\u7b56\u7684\u89c4\u5b9a\u4f7f\u7528\u548c\u62ab\u9732\u60a8\u7684\u4e2a\u4eba\u4fe1\u606f\u3002\u4f46\u300a\u67e5\u91cd\u62a5\u544a\u300b\u5c06\u4ee5\u9ad8\u5ea6\u7684\u52e4\u52c9\u3001\u5ba1\u614e\u4e49\u52a1\u5bf9\u5f85\u8fd9\u4e9b\u4fe1\u606f\u3002\u9664\u672c\u9690\u79c1\u6743\u653f\u7b56\u53e6\u6709\u89c4\u5b9a\u5916\uff0c\u5728\u672a\u5f81\u5f97\u60a8\u4e8b\u5148\u8bb8\u53ef\u7684\u60c5\u51b5\u4e0b\uff0c\u300a\u67e5\u91cd\u62a5\u544a\u300b\u4e0d\u4f1a\u5c06\u8fd9\u4e9b\u4fe1\u606f\u5bf9\u5916\u62ab\u9732\u6216\u5411\u7b2c\u4e09\u65b9\u63d0\u4f9b\u3002\u300a\u67e5\u91cd\u62a5\u544a\u300b\u4f1a\u4e0d\u65f6\u66f4\u65b0\u672c\u9690\u79c1\u6743\u653f\u7b56\u3002\u60a8\u5728\u540c\u610f\u300a\u67e5\u91cd\u62a5\u544a\u300b\u670d\u52a1\u4f7f\u7528\u534f\u8bae\u4e4b\u65f6\uff0c\u5373\u89c6\u4e3a\u60a8\u5df2\u7ecf\u540c\u610f\u672c\u9690\u79c1\u6743\u653f\u7b56\u5168\u90e8\u5185\u5bb9\u3002\u672c\u9690\u79c1\u6743\u653f\u7b56\u5c5e\u4e8e\u300a\u67e5\u91cd\u62a5\u544a\u300b\u670d\u52a1\u4f7f\u7528\u534f\u8bae\u4e0d\u53ef\u5206\u5272\u7684\u4e00\u90e8\u5206\u3002");
            titleParagraphRun.setFontSize(12);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            document.write((OutputStream)baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public byte[] downloadCheckDuplicateReport(SimilarityDataQuery dataQuery) throws IOException {
        HashMap<String, Object> reportInfo = new HashMap<String, Object>();
        reportInfo.put("reportNo", IdUtil.simpleUUID());
        DuplicateCheckDocDto docInfo = new DuplicateCheckDocDto();
        List documentInfoList = this.getDocumentInfo(dataQuery.getDocumentIdList()).getRecords();
        StringBuilder sb = new StringBuilder();
        BigDecimal fileSize = BigDecimal.valueOf(0L);
        for (DuplicateCheckDocDto tempDocInfo : documentInfoList) {
            fileSize = fileSize.add(BigDecimal.valueOf(Double.parseDouble(tempDocInfo.getFileSize())));
            sb.append(tempDocInfo.getFileName()).append(";");
        }
        docInfo.setFileName(sb.substring(0, sb.length() - 1));
        docInfo.setFileSize(this.format(fileSize.divide(BigDecimal.valueOf(0x100000L), 6, RoundingMode.HALF_UP).doubleValue()));
        docInfo.setStartTime(((DuplicateCheckDocDto)documentInfoList.get(0)).getStartTime());
        docInfo.setTaskStatus("1");
        docInfo.setId(IdUtil.simpleUUID());
        reportInfo.put("docInfo", docInfo);
        List allSentence = this.getSentenceWithMaxSimiSentence(dataQuery).getRecords();
        reportInfo.put("topSentence", CollectionUtils.isEmpty((Collection)allSentence) ? new ArrayList() : allSentence);
        reportInfo.put("sentenceCount", allSentence.size());
        DuplicateCheckSimilarityInfo similarityInfo = this.getSimilarityInfo(dataQuery.getDocumentIdList());
        reportInfo.put("similarityInfo", similarityInfo);
        return this.getWord(reportInfo);
    }
}

