/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.executor.document;

import com.jxdinfo.idp.common.util.SpringUtils;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckCandidateSentence;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.executor.document.DuplicateCheckDocumentExecutor;
import com.jxdinfo.idp.icpac.core.executor.document.DuplicateCheckExecutorRegister;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckUpdateModelEnum;
import com.jxdinfo.idp.icpac.core.rmi.DefaultDuplicateCheckRmi;
import com.jxdinfo.idp.icpac.core.rmi.resp.DuplicateCheckIgnoreResponse;
import com.jxdinfo.idp.icpac.core.rmi.resp.DuplicateCheckResponse;
import com.jxdinfo.idp.icpac.core.rmi.resp.DuplicateCheckVectorizatioResult;
import com.jxdinfo.idp.icpac.utils.DuplicateCheckProgress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

public abstract class AbstractDuplicateCheckDocumentExecutor
implements DuplicateCheckDocumentExecutor {
    private static final Logger log = LoggerFactory.getLogger(AbstractDuplicateCheckDocumentExecutor.class);
    private static final int CHECK_TIME = 5;
    private static final String PREFIX = "check:";
    private StringRedisTemplate redisTemplate;
    @Resource
    private DefaultDuplicateCheckRmi defaultCheckRmi;

    public AbstractDuplicateCheckDocumentExecutor() {
        DuplicateCheckExecutorRegister.register(this);
        this.redisTemplate = (StringRedisTemplate)SpringUtils.getBean(StringRedisTemplate.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DuplicateCheckResponse checkRepeat(DuplicateCheckInfo checkInfo) throws Exception {
        DuplicateCheckProgress.setProgress(checkInfo.getDocumentId(), 5);
        this.wait(checkInfo);
        try {
            List<DuplicateCheckCandidateSentence> candidateSentenceList = this.getCandidateSentence(checkInfo);
            if (CollectionUtils.isEmpty(candidateSentenceList)) {
                log.info(checkInfo.getFileName() + "\uff1a\u83b7\u53d6\u5f85\u67e5\u91cd\u7684\u53e5\u5b50\u6761\u6570\u4e3a0,\u65e0\u6cd5\u8fdb\u884c\u67e5\u91cd\uff0c\u67e5\u91cd\u7ed3\u675f");
                DuplicateCheckResponse duplicateCheckResponse = null;
                return duplicateCheckResponse;
            }
            checkInfo.setCandidateSentenceList(candidateSentenceList);
            checkInfo.setCandidateSentenceNum(candidateSentenceList.size());
            DuplicateCheckResponse duplicateCheckResponse = this.defaultCheckRmi.checkRepeat(checkInfo);
            return duplicateCheckResponse;
        }
        finally {
            this.notify(checkInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DuplicateCheckResponse checkRepeatNoVectorization(DuplicateCheckInfo checkInfo) throws Exception {
        DuplicateCheckProgress.setProgress(checkInfo.getDocumentId(), 5);
        this.wait(checkInfo);
        try {
            List<DuplicateCheckCandidateSentence> candidateSentenceList = checkInfo.getCandidateSentenceList();
            if (CollectionUtils.isEmpty(candidateSentenceList)) {
                candidateSentenceList = this.getCandidateSentence(checkInfo);
                if (CollectionUtils.isEmpty(candidateSentenceList)) {
                    log.info(checkInfo.getFileName() + "\uff1a\u83b7\u53d6\u5f85\u67e5\u91cd\u7684\u53e5\u5b50\u6761\u6570\u4e3a0,\u65e0\u6cd5\u8fdb\u884c\u67e5\u91cd\uff0c\u67e5\u91cd\u7ed3\u675f");
                    DuplicateCheckResponse duplicateCheckResponse = null;
                    return duplicateCheckResponse;
                }
                checkInfo.setCandidateSentenceList(candidateSentenceList);
                checkInfo.setCandidateSentenceNum(candidateSentenceList.size());
            }
            DuplicateCheckResponse duplicateCheckResponse = this.defaultCheckRmi.checkRepeatNoVectorization(checkInfo);
            return duplicateCheckResponse;
        }
        finally {
            this.notify(checkInfo);
        }
    }

    private void notify(DuplicateCheckInfo checkInfo) {
        Long decrement;
        ValueOperations valueOperations;
        String documentCountStr;
        DuplicateCheckUpdateModelEnum updateLib = checkInfo.getUpdateModel();
        String redisKey = PREFIX + checkInfo.getLibId();
        if (updateLib != DuplicateCheckUpdateModelEnum.NO_UPDATE && StringUtils.isNotEmpty((CharSequence)(documentCountStr = (String)(valueOperations = this.redisTemplate.opsForValue()).get((Object)redisKey))) && (decrement = valueOperations.decrement((Object)redisKey)) != null && decrement == 0L) {
            this.redisTemplate.delete((Object)redisKey);
        }
    }

    private void wait(DuplicateCheckInfo checkInfo) {
        DuplicateCheckUpdateModelEnum updateLib = checkInfo.getUpdateModel();
        String redisKey = PREFIX + checkInfo.getLibId();
        if (updateLib != DuplicateCheckUpdateModelEnum.NO_UPDATE) {
            ValueOperations valueOperations = this.redisTemplate.opsForValue();
            valueOperations.setIfAbsent((Object)redisKey, (Object)"0", 1L, TimeUnit.HOURS);
            valueOperations.increment((Object)redisKey);
            this.redisTemplate.expire((Object)redisKey, 1L, TimeUnit.HOURS);
            return;
        }
        while (true) {
            ValueOperations valueOperations;
            String documentCountStr;
            int documentCount;
            int n = documentCount = (documentCountStr = (String)(valueOperations = this.redisTemplate.opsForValue()).get((Object)redisKey)) == null ? 0 : Integer.parseInt(documentCountStr);
            if (documentCount <= 0) {
                return;
            }
            try {
                log.info(checkInfo.getFileName() + "\u6b63\u5728\u7b49\u5f85");
                Thread.sleep((long)(documentCount * 5) * 1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DuplicateCheckVectorizatioResult vectorization(DuplicateCheckInfo checkInfo) throws Exception {
        this.wait(checkInfo);
        try {
            List<DuplicateCheckCandidateSentence> candidateSentenceList = this.getCandidateSentence(checkInfo);
            if (CollectionUtils.isEmpty(candidateSentenceList)) {
                log.warn(checkInfo.getFileName() + "\uff1a\u83b7\u53d6\u5f85\u67e5\u91cd\u7684\u53e5\u5b50\u6761\u6570\u4e3a0,\u65e0\u6cd5\u8fdb\u884c\u5411\u91cf\u5316");
                DuplicateCheckVectorizatioResult duplicateCheckVectorizatioResult = null;
                return duplicateCheckVectorizatioResult;
            }
            checkInfo.setCandidateSentenceList(candidateSentenceList);
            checkInfo.setCandidateSentenceNum(candidateSentenceList.size());
            DuplicateCheckVectorizatioResult duplicateCheckVectorizatioResult = this.defaultCheckRmi.vectorization(checkInfo);
            return duplicateCheckVectorizatioResult;
        }
        finally {
            this.notify(checkInfo);
        }
    }

    protected abstract List<DuplicateCheckCandidateSentence> getCandidateSentence(DuplicateCheckInfo var1) throws Exception;

    @Override
    public DuplicateCheckIgnoreResponse addIgnoreSentence(DuplicateCheckInfo info) {
        return this.defaultCheckRmi.addIgnoreSentence(info);
    }

    @Override
    public DuplicateCheckIgnoreResponse cancelIgnoreSentence(DuplicateCheckInfo checkInfo) {
        return this.defaultCheckRmi.cancelIgnoreSentence(checkInfo);
    }

    @Override
    public void deleteRemoteDoc(DuplicateCheckInfo checkInfo) {
        this.defaultCheckRmi.deleteRemoteDoc(checkInfo);
    }
}

