/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.api;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckBidDocument;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckBidRecord;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocument;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocumentCollection;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckProcess;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckProjectDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckResultDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckDoc;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckProject;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckResult;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckTemplateDoc;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckTemplateProject;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckBidDocumentQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckBidRecordQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckDocQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckProjectQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckResultQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckTemplateDocQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckTemplateProjectQuery;
import com.jxdinfo.idp.duplicatecheck.api.service.DuplicateCheckBidDocumentManagerService;
import com.jxdinfo.idp.duplicatecheck.api.service.DuplicateCheckDocumentService;
import com.jxdinfo.idp.duplicatecheck.api.service.DuplicateCheckOperationService;
import com.jxdinfo.idp.duplicatecheck.api.service.DuplicateCheckTemplateManagementService;
import com.jxdinfo.idp.duplicatecheck.api.service.IDuplicateCheckLibService;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckUpdateModelEnum;
import com.jxdinfo.idp.icpac.service.DuplicateCheckResultService;
import com.jxdinfo.idp.icpac.utils.DuplicateCheckProgress;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DuplicateCheckBidDocumentManagerServiceImpl
implements DuplicateCheckBidDocumentManagerService {
    @Resource
    private IDuplicateCheckLibService libService;
    @Resource
    private DuplicateCheckTemplateManagementService templateManagementService;
    @Resource
    private DuplicateCheckDocumentService documentService;
    @Resource
    private DuplicateCheckOperationService operationService;
    @Resource
    private DuplicateCheckResultService resultService;

    public ApiResponse<DuplicateCheckProcess> getBidProcess(String projectId) {
        ApiResponse docResponse = this.documentService.listDocumentByProjectIdList(Arrays.asList(projectId));
        Page docPage = (Page)docResponse.getData();
        List documentList = docPage.getRecords();
        DuplicateCheckProcess duplicateCheckProcess = new DuplicateCheckProcess();
        BigDecimal progressSum = BigDecimal.valueOf(0L);
        if (CollectionUtil.isEmpty((Collection)documentList)) {
            duplicateCheckProcess.setProcess(100);
            return ApiResponse.data((Object)duplicateCheckProcess);
        }
        int failCount = 0;
        for (DuplicateCheckDoc checkDoc : documentList) {
            int progress = DuplicateCheckProgress.getProgress(checkDoc.getId());
            if (progress == -1) {
                ++failCount;
                progress = 100;
            }
            progressSum = progressSum.add(BigDecimal.valueOf(progress));
        }
        if (failCount == documentList.size()) {
            duplicateCheckProcess.setProcess(-1);
            return ApiResponse.data((Object)duplicateCheckProcess);
        }
        int process = (int)progressSum.divide(BigDecimal.valueOf(documentList.size()), 2, RoundingMode.CEILING).doubleValue();
        duplicateCheckProcess.setProcess(process);
        return ApiResponse.data((Object)duplicateCheckProcess);
    }

    public ApiResponse<Void> delete(List<String> projectIdList) {
        this.libService.delete(projectIdList);
        ApiResponse tempProResponse = this.templateManagementService.listTemplateProjectByProjectIdList(projectIdList);
        Page tempProPage = (Page)tempProResponse.getData();
        if (tempProPage == null) {
            return ApiResponse.success();
        }
        List tempProList = tempProPage.getRecords();
        if (CollectionUtil.isEmpty((Collection)tempProList)) {
            return ApiResponse.success();
        }
        this.templateManagementService.deleteTemplateProject(tempProList.stream().map(DuplicateCheckTemplateProject::getId).collect(Collectors.toList()));
        return ApiResponse.success();
    }

    public ApiResponse<Page<DuplicateCheckBidDocument>> list(DuplicateCheckBidDocumentQuery bidDocumentQuery) {
        ApiResponse docResponse;
        Page docPage;
        List documentList;
        DuplicateCheckProjectQuery projectQuery = new DuplicateCheckProjectQuery();
        projectQuery.setProjectName(bidDocumentQuery.getProjectName());
        projectQuery.setProjectId(bidDocumentQuery.getProjectId());
        projectQuery.setPageFlag(bidDocumentQuery.isPageFlag());
        projectQuery.setCurrent(bidDocumentQuery.getCurrent());
        projectQuery.setSize(bidDocumentQuery.getSize());
        Page projectPage = this.libService.list(projectQuery);
        Page bidDocumentPage = new Page();
        List projectList = projectPage.getRecords();
        if (CollectionUtil.isEmpty((Collection)projectList)) {
            return ApiResponse.data((Object)bidDocumentPage);
        }
        bidDocumentPage.setCurrent(projectPage.getCurrent());
        bidDocumentPage.setTotal(projectPage.getTotal());
        bidDocumentPage.setSize(projectPage.getSize());
        HashMap<String, DuplicateCheckBidDocument> proIdWithBidEntityMap = new HashMap<String, DuplicateCheckBidDocument>();
        ArrayList<String> projectIdList = new ArrayList<String>();
        ArrayList<DuplicateCheckBidDocument> bidDocumentList = new ArrayList<DuplicateCheckBidDocument>();
        for (DuplicateCheckProject project : projectList) {
            DuplicateCheckBidDocument bidDocumentEntity = new DuplicateCheckBidDocument();
            bidDocumentEntity.setProjectId(project.getId());
            bidDocumentEntity.setProjectName(project.getProjectName());
            bidDocumentEntity.setSimilarityBounds(project.getSimilarityBounds());
            bidDocumentEntity.setWordLength(project.getWordLength().intValue());
            bidDocumentList.add(bidDocumentEntity);
            projectIdList.add(project.getId());
            proIdWithBidEntityMap.put(project.getId(), bidDocumentEntity);
        }
        ApiResponse response = this.templateManagementService.listTemplateDocByProjectIdList(projectIdList);
        Page templateDocPage = (Page)response.getData();
        List templateDocList = templateDocPage.getRecords();
        if (CollectionUtil.isNotEmpty((Collection)templateDocList)) {
            for (DuplicateCheckTemplateDoc templateDoc : templateDocList) {
                DuplicateCheckBidDocument bidDocument = (DuplicateCheckBidDocument)proIdWithBidEntityMap.get(templateDoc.getProjectId());
                if (bidDocument == null) continue;
                bidDocument.setInviteTendersCount(bidDocument.getInviteTendersCount() + 1);
                bidDocument.addTemplateDoc(templateDoc);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(documentList = (docPage = (Page)(docResponse = this.documentService.listDocumentByProjectIdList(projectIdList)).getData()).getRecords()))) {
            for (DuplicateCheckDoc checkDoc : documentList) {
                int currentTaskStatusInt;
                DuplicateCheckBidDocument bidDocument = (DuplicateCheckBidDocument)proIdWithBidEntityMap.get(checkDoc.getProjectId());
                if (bidDocument == null) continue;
                bidDocument.setBidCount(bidDocument.getBidCount() + 1);
                bidDocument.addDocument(checkDoc);
                String taskStatus = bidDocument.getTaskStatus();
                if (StringUtils.isEmpty((String)taskStatus)) {
                    bidDocument.setTaskStatus(checkDoc.getTaskStatus());
                    continue;
                }
                int oldTaskStatusInt = Integer.parseInt(taskStatus);
                if (oldTaskStatusInt <= (currentTaskStatusInt = Integer.parseInt(checkDoc.getTaskStatus()))) continue;
                bidDocument.setTaskStatus(checkDoc.getTaskStatus());
            }
        }
        bidDocumentPage.setRecords(bidDocumentList);
        return ApiResponse.data((Object)bidDocumentPage);
    }

    public ApiResponse<DuplicateCheckBidDocument> checkDuplicate(DuplicateCheckBidDocument bidDocument) throws Exception {
        DuplicateCheckProjectDto libProject = this.createLibInfo(bidDocument);
        libProject = this.libService.insertOrUpdate(libProject);
        bidDocument.setProjectId(libProject.getId());
        this.handleTemplateDocument(bidDocument);
        this.handleDocument(bidDocument);
        this.operationService.checkDuplicate(bidDocument.getProjectId());
        return ApiResponse.data((Object)bidDocument);
    }

    public ApiResponse<Page<DuplicateCheckBidRecord>> listCheckRecord(DuplicateCheckBidRecordQuery bidRecordQuery) {
        String projectId = bidRecordQuery.getProjectId();
        ArrayList<DuplicateCheckBidRecord> bidRecordList = new ArrayList<DuplicateCheckBidRecord>();
        ApiResponse documentResponse = this.documentService.listDocumentByProjectIdList(Arrays.asList(projectId));
        Page pageDocument = (Page)documentResponse.getData();
        List documentList = pageDocument.getRecords();
        if (CollectionUtils.isEmpty((Collection)documentList)) {
            return ApiResponse.data((Object)new Page());
        }
        List documentIdList = documentList.stream().map(DuplicateCheckDoc::getId).collect(Collectors.toList());
        DuplicateCheckResultQuery resultQuery = new DuplicateCheckResultQuery();
        resultQuery.setUploadDocIds(documentIdList);
        List<DuplicateCheckResultDto> resultList = this.resultService.list(resultQuery);
        Map<String, Double> resultMap = resultList.stream().collect(Collectors.toMap(k -> k.getUploadDocId() + "_" + k.getSimilarDocId(), DuplicateCheckResult::getSimilarity));
        int size = documentList.size();
        for (int i = 0; i < size; ++i) {
            DuplicateCheckDoc document1 = (DuplicateCheckDoc)documentList.get(i);
            if (document1.getTaskStatus().equals("2")) {
                DuplicateCheckBidRecord bidRecord = new DuplicateCheckBidRecord();
                bidRecord.setDocument1Id(document1.getId());
                bidRecord.setDocument1(document1.getFileName());
                bidRecord.setTaskStatus(document1.getTaskStatus());
                bidRecordList.add(bidRecord);
                continue;
            }
            for (int j = i + 1; j < size; ++j) {
                DuplicateCheckDoc document2 = (DuplicateCheckDoc)documentList.get(j);
                DuplicateCheckBidRecord bidRecord = new DuplicateCheckBidRecord();
                bidRecord.setDocument1Id(document1.getId());
                bidRecord.setDocument1(document1.getFileName());
                bidRecord.setTaskStatus(document1.getTaskStatus());
                bidRecord.setDocument2Id(document2.getId());
                bidRecord.setDocument2(document2.getFileName());
                Double orDefault = resultMap.get(document1.getId() + "_" + document2.getId());
                if (orDefault == null) continue;
                bidRecord.setSimilarity(orDefault);
                bidRecordList.add(bidRecord);
            }
        }
        Page page = new Page();
        page.setRecords(bidRecordList);
        return ApiResponse.data((Object)page);
    }

    private DuplicateCheckProjectDto createLibInfo(DuplicateCheckBidDocument bidDocument) {
        DuplicateCheckProjectDto libProject = new DuplicateCheckProjectDto();
        libProject.setProjectName(bidDocument.getProjectName());
        libProject.setSimilarityBounds(bidDocument.getSimilarityBounds());
        libProject.setWordLength(Integer.valueOf(bidDocument.getWordLength()));
        libProject.setLibResource("0");
        libProject.setId(bidDocument.getProjectId());
        return libProject;
    }

    private void handleDocument(DuplicateCheckBidDocument bidDocument) {
        List documentList = bidDocument.getDocumentList();
        if (CollectionUtil.isEmpty((Collection)documentList)) {
            throw new RuntimeException("\u4f20\u5165\u7684\u5f85\u67e5\u91cd\u6807\u4e66\u6570\u91cf\u4e3a0,\u65e0\u6cd5\u8fdb\u884c\u6807\u4e66\u67e5\u91cd");
        }
        DuplicateCheckDocQuery docQuery = new DuplicateCheckDocQuery();
        docQuery.setPageFlag(false);
        docQuery.setProjectId(bidDocument.getProjectId());
        Page docPage = this.documentService.list(docQuery);
        List oldDocumentList = docPage.getRecords();
        DuplicateCheckDocumentCollection collectionCollection = new DuplicateCheckDocumentCollection();
        collectionCollection.setProjectId(bidDocument.getProjectId());
        ArrayList<DuplicateCheckDocument> insertedDocumentList = new ArrayList<DuplicateCheckDocument>();
        if (CollectionUtil.isEmpty((Collection)oldDocumentList)) {
            for (DuplicateCheckDoc checkDocument : documentList) {
                DuplicateCheckDocument cd = new DuplicateCheckDocument();
                cd.setFileId(checkDocument.getFileId());
                cd.setUpdateLib(DuplicateCheckUpdateModelEnum.CHECK_UPDATE.getFlag());
                insertedDocumentList.add(cd);
            }
            collectionCollection.setPendingInfoList(insertedDocumentList);
            this.operationService.initLibDocument(collectionCollection);
            return;
        }
        Map<String, DuplicateCheckDocDto> oldDocumentMap = oldDocumentList.stream().collect(Collectors.toMap(DuplicateCheckDoc::getId, d -> d));
        for (DuplicateCheckDoc checkDoc : documentList) {
            if (StringUtils.isBlank((CharSequence)checkDoc.getId())) {
                DuplicateCheckDocument cd = new DuplicateCheckDocument();
                cd.setFileId(checkDoc.getFileId());
                cd.setUpdateLib(DuplicateCheckUpdateModelEnum.CHECK_UPDATE.getFlag());
                insertedDocumentList.add(cd);
                continue;
            }
            oldDocumentMap.remove(checkDoc.getId());
        }
        collectionCollection.setPendingInfoList(insertedDocumentList);
        this.operationService.initLibDocument(collectionCollection);
        this.documentService.delete(new ArrayList<String>(oldDocumentMap.keySet()));
    }

    private void handleTemplateDocument(DuplicateCheckBidDocument bidDocument) {
        List templateDocList = bidDocument.getTemplateDocList();
        List oldTemplateDocList = new ArrayList();
        DuplicateCheckTemplateProject templateProject = null;
        String projectId = bidDocument.getProjectId();
        DuplicateCheckTemplateProjectQuery projectQuery = new DuplicateCheckTemplateProjectQuery(projectId, false);
        Page templateProjectPage = this.templateManagementService.listTemplateProject(projectQuery);
        List templateProjectList = templateProjectPage.getRecords();
        if (CollectionUtil.isNotEmpty((Collection)templateProjectList) && templateProjectList.size() > 1) {
            throw new RuntimeException("\u67e5\u91cd\u6a21\u677f\u5e93\uff0c\u5173\u8054\u7684projectId:{} \u4e0d\u552f\u4e00");
        }
        if (CollectionUtil.isNotEmpty((Collection)templateProjectList)) {
            templateProject = (DuplicateCheckTemplateProject)templateProjectList.get(0);
            Page templateDocPage = this.templateManagementService.listTemplateDoc(new DuplicateCheckTemplateDocQuery(templateProject.getId(), null, false));
            oldTemplateDocList = templateDocPage.getRecords();
        }
        if (CollectionUtil.isEmpty((Collection)templateDocList)) {
            if (CollectionUtil.isNotEmpty(oldTemplateDocList)) {
                List templateDocumentIdList = oldTemplateDocList.stream().map(DuplicateCheckTemplateDoc::getId).collect(Collectors.toList());
                this.templateManagementService.removeTemplateDoc(templateDocumentIdList);
            }
            return;
        }
        if (CollectionUtil.isEmpty((Collection)templateProjectList)) {
            templateProject = new DuplicateCheckTemplateProject();
            templateProject.setProjectId(bidDocument.getProjectId());
            templateProject.setIsUse("1");
            templateProject.setCreateTime(LocalDateTime.now());
            templateProject.setId(String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
            this.templateManagementService.createTemplateProject(templateProject);
        }
        for (DuplicateCheckTemplateDoc templateDoc : templateDocList) {
            templateDoc.setTemplateProjectId(templateProject.getId());
            templateDoc.setCreateTime(LocalDateTime.now());
        }
        if (CollectionUtil.isEmpty(oldTemplateDocList)) {
            this.templateManagementService.batchAddTemplateDoc(templateDocList);
            return;
        }
        ArrayList<DuplicateCheckTemplateDoc> insertTemplateDocList = new ArrayList<DuplicateCheckTemplateDoc>();
        Map<String, DuplicateCheckTemplateDoc> oldTemplateDocMap = oldTemplateDocList.stream().collect(Collectors.toMap(DuplicateCheckTemplateDoc::getId, k -> k));
        for (DuplicateCheckTemplateDoc templateDoc : templateDocList) {
            if (StringUtils.isEmpty((String)templateDoc.getId())) {
                insertTemplateDocList.add(templateDoc);
                continue;
            }
            oldTemplateDocMap.remove(templateDoc.getId());
        }
        Set<String> deletedTemplateDocIdList = oldTemplateDocMap.keySet();
        this.templateManagementService.batchAddTemplateDoc(insertTemplateDocList);
        this.templateManagementService.removeTemplateDoc(new ArrayList<String>(deletedTemplateDocIdList));
    }
}

