/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.dio.model.po.DocInfoPo;
import com.jxdinfo.idp.dio.service.impl.DocInfoIoServiceImpl;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckTemplateDoc;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckTemplateDocQueryQuery;
import com.jxdinfo.idp.icpac.mapper.DuplicateCheckTemplateDocMapper;
import com.jxdinfo.idp.icpac.service.DuplicateCheckTemplateDocService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DuplicateCheckTemplateDocServiceImpl
extends ServiceImpl<DuplicateCheckTemplateDocMapper, DuplicateCheckTemplateDoc>
implements DuplicateCheckTemplateDocService {
    @Resource
    private DuplicateCheckTemplateDocMapper mapper;
    @Resource
    private DocInfoIoServiceImpl ioService;

    @Override
    public void removeByTempProjectId(List<String> templateProjectIdList) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(DuplicateCheckTemplateDoc::getTemplateProjectId, templateProjectIdList);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public DuplicateCheckTemplateDoc insert(DuplicateCheckTemplateDoc duplicateCheckTemplateDoc) {
        duplicateCheckTemplateDoc.setId(String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
        duplicateCheckTemplateDoc.setCreateTime(LocalDateTime.now());
        DocInfoPo docInfoPo = (DocInfoPo)this.ioService.getById((Serializable)duplicateCheckTemplateDoc.getFileId());
        if (docInfoPo != null) {
            duplicateCheckTemplateDoc.setFileName(docInfoPo.getName() + "." + docInfoPo.getFormat());
        }
        this.save(duplicateCheckTemplateDoc);
        return duplicateCheckTemplateDoc;
    }

    @Override
    public List<DuplicateCheckTemplateDoc> listByTemplateProjectId(List<String> templateProjectIdList) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(DuplicateCheckTemplateDoc::getTemplateProjectId, templateProjectIdList);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public Page<DuplicateCheckTemplateDoc> list(DuplicateCheckTemplateDocQueryQuery templateDocQueryQuery) {
        boolean pageFlag = templateDocQueryQuery.isPageFlag();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DuplicateCheckTemplateDoc::getTemplateProjectId, (Object)templateDocQueryQuery.getTemplateProjectId());
        if (StringUtils.isNotEmpty((String)templateDocQueryQuery.getFileName())) {
            wrapper.like(DuplicateCheckTemplateDoc::getFileName, (Object)templateDocQueryQuery.getFileName());
        }
        Page page = templateDocQueryQuery.getPage(DuplicateCheckTemplateDoc.class);
        if (pageFlag) {
            return (Page)this.page((IPage)page, (Wrapper)wrapper);
        }
        List list = this.list((Wrapper)wrapper);
        page.setTotal((long)list.size());
        page.setRecords(list);
        return page;
    }
}

