/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckResultDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSimilarSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSimilarityInfo;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.GroupDuplicateCheckResponseDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.GroupDuplicateRequestDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.GroupQueryDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckResult;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckDocQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckResultQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSentenceQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSimilarSentenceQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSimilarityInfoQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.SentenceQuery;
import com.jxdinfo.idp.duplicatecheck.api.service.IDuplicateCheckDataService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckResultService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSentenceService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSimilarSentenceService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
public class IDuplicateCheckDataServiceImpl
implements IDuplicateCheckDataService {
    @Resource
    private DuplicateCheckSentenceService sentenceService;
    @Resource
    private DuplicateCheckDocService docService;
    @Resource
    private DuplicateCheckSentenceService duplicateCheckSentenceService;
    @Resource
    private DuplicateCheckResultService resultService;
    @Resource
    private DuplicateCheckSimilarSentenceService similarSentenceService;

    public DuplicateCheckSimilarityInfo getSimilarityInfo(DuplicateCheckSimilarityInfoQuery checkInfoQuery) {
        String documentId = checkInfoQuery.getDocumentId();
        if (StringUtils.isEmpty((CharSequence)documentId)) {
            return new DuplicateCheckSimilarityInfo();
        }
        DuplicateCheckSimilarityInfo similarityInfo = new DuplicateCheckSimilarityInfo();
        DuplicateCheckDocDto detail = this.docService.detail(documentId);
        similarityInfo.setMaxSimilarity(detail.getMaxSimilarity());
        similarityInfo.setDocSimilarity(detail.getDocSimilarity());
        similarityInfo.setCandidateSentenceNum(detail.getCandidateSentenceNum());
        List resultList = detail.getResultList();
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            similarityInfo.setRepeatDocCount(0);
        } else {
            similarityInfo.setRepeatDocCount(resultList.size());
        }
        DuplicateCheckSentenceQuery sentenceDataQuery = new DuplicateCheckSentenceQuery();
        sentenceDataQuery.setDocumentId(documentId);
        sentenceDataQuery.setIgnoreFlag("0");
        sentenceDataQuery.setPageFlag(false);
        Page<DuplicateCheckSentenceDto> sentencePage = this.sentenceService.getSentenceList(sentenceDataQuery);
        List records = sentencePage.getRecords();
        similarityInfo.setIgnoreSentenceCount(records == null ? 0 : records.size());
        sentenceDataQuery = new DuplicateCheckSentenceQuery();
        sentenceDataQuery.setDocumentId(documentId);
        sentenceDataQuery.setSimilarity(Double.valueOf(checkInfoQuery.getSimilarity()));
        sentenceDataQuery.setIgnoreFlag("1");
        sentenceDataQuery.setPageFlag(false);
        List sentenceList = this.sentenceService.getSentenceList(sentenceDataQuery).getRecords();
        sentenceList = CollectionUtils.isEmpty((Collection)sentenceList) ? Collections.emptyList() : sentenceList;
        similarityInfo.setLe80PreCount(sentenceList.size());
        similarityInfo.setLe80PreProportion(sentenceList.size() + "/" + detail.getCandidateSentenceNum());
        return similarityInfo;
    }

    private List<String> getResultIdList(SentenceQuery query) {
        List resultIdList = null;
        List similarDocIdList = query.getSimilarDocIdList();
        if (CollectionUtils.isNotEmpty((Collection)similarDocIdList)) {
            DuplicateCheckResultQuery resultQuery = new DuplicateCheckResultQuery();
            resultQuery.setUploadDocIds(Collections.singletonList(query.getDocumentId()));
            resultQuery.setSimilarDocIds(similarDocIdList);
            List<DuplicateCheckResultDto> resultDtoList = this.resultService.list(resultQuery);
            if (CollectionUtils.isEmpty(resultDtoList)) {
                return new ArrayList<String>();
            }
            resultIdList = resultDtoList.stream().map(DuplicateCheckResult::getId).collect(Collectors.toList());
        }
        return resultIdList;
    }

    public Page<DuplicateCheckSentenceDto> getSentence(SentenceQuery sentenceQuery) {
        DuplicateCheckSentenceQuery sentenceDataQuery = new DuplicateCheckSentenceQuery();
        sentenceDataQuery.setDocumentId(sentenceQuery.getDocumentId());
        sentenceDataQuery.setSimilarity(sentenceQuery.getSimilarity());
        sentenceDataQuery.setResultIdList(this.getResultIdList(sentenceQuery));
        sentenceDataQuery.setIgnoreFlag(sentenceQuery.getIgnoreFlag());
        sentenceDataQuery.setPageFlag(sentenceQuery.isPageFlag());
        sentenceDataQuery.setCurrent(sentenceQuery.getCurrent());
        sentenceDataQuery.setSize(sentenceQuery.getSize());
        return this.sentenceService.getSentenceList(sentenceDataQuery);
    }

    public Page<DuplicateCheckSentenceDto> getSimilaritySentenceWithTopn(SentenceQuery sentenceQuery) {
        DuplicateCheckSentenceQuery sentenceDataQuery = new DuplicateCheckSentenceQuery();
        sentenceDataQuery.setDocumentId(sentenceQuery.getDocumentId());
        sentenceDataQuery.setSimilarity(sentenceQuery.getSimilarity());
        sentenceDataQuery.setResultIdList(this.getResultIdList(sentenceQuery));
        sentenceDataQuery.setPageFlag(sentenceQuery.isPageFlag());
        sentenceDataQuery.setCurrent(sentenceQuery.getCurrent());
        sentenceDataQuery.setSize(sentenceQuery.getSize());
        sentenceDataQuery.setTopN(sentenceQuery.getTopN());
        sentenceDataQuery.setDocumentIdList(sentenceQuery.getDocumentIds());
        sentenceDataQuery.setIgnoreFlag(sentenceQuery.getIgnoreFlag());
        return this.sentenceService.getSentenceListWithTopn(sentenceDataQuery);
    }

    public List<GroupDuplicateCheckResponseDto> getSimilarityWithGroup(GroupDuplicateRequestDto requestDto) {
        List groupQueryList = requestDto.getGroupQueryDtoList();
        HashMap documentIdWithGroupIdMap = new HashMap();
        ArrayList allDocumentIdList = new ArrayList();
        for (GroupQueryDto groupQueryDto : groupQueryList) {
            String groupId = groupQueryDto.getGroupId();
            List docIdList = groupQueryDto.getDocIds();
            docIdList.forEach(k -> documentIdWithGroupIdMap.put(k, groupId));
            allDocumentIdList.addAll(docIdList);
        }
        DuplicateCheckResultQuery resultQuery = new DuplicateCheckResultQuery();
        resultQuery.setUploadDocIds(allDocumentIdList);
        List<DuplicateCheckResultDto> similarityResultList = this.resultService.list(resultQuery);
        HashMap<String, GroupSimilarity> groupSimilarityMap = new HashMap<String, GroupSimilarity>();
        for (DuplicateCheckResultDto similarityResult : similarityResultList) {
            String documentId = similarityResult.getUploadDocId();
            String similarDocId = similarityResult.getSimilarDocId();
            String simiGroupId = (String)documentIdWithGroupIdMap.get(similarDocId);
            if (simiGroupId == null) continue;
            GroupSimilarity groupSimilarity = groupSimilarityMap.computeIfAbsent(documentId + "_" + simiGroupId, k -> new GroupSimilarity(documentId, simiGroupId));
            groupSimilarity.addSimilarity(similarityResult.getSimilarity());
        }
        ArrayList<GroupDuplicateCheckResponseDto> responseList = new ArrayList<GroupDuplicateCheckResponseDto>();
        for (GroupQueryDto groupQueryDto : groupQueryList) {
            List documentIdList = groupQueryDto.getDocIds();
            GroupDuplicateCheckResponseDto response = new GroupDuplicateCheckResponseDto();
            response.setGroupId(groupQueryDto.getGroupId());
            responseList.add(response);
            for (GroupQueryDto queryDto : groupQueryList) {
                BigDecimal similarity = new BigDecimal(0);
                String similarityGroupId = queryDto.getGroupId();
                if (Objects.equals(similarityGroupId, groupQueryDto.getGroupId())) continue;
                for (String documentId : documentIdList) {
                    GroupSimilarity groupSimilarity = (GroupSimilarity)groupSimilarityMap.get(documentId + "_" + similarityGroupId);
                    if (groupSimilarity == null) continue;
                    BigDecimal similarityBig = groupSimilarity.getSimilarity();
                    similarity = similarity.add(similarityBig);
                }
                response.addSimilarityByGroup(similarityGroupId, similarity, documentIdList.size());
            }
        }
        return responseList;
    }

    public Page<DuplicateCheckSentenceDto> getSentenceWithMaxSimiSentence(SentenceQuery sentenceQuery) {
        DuplicateCheckSentenceQuery sentenceDataQuery = new DuplicateCheckSentenceQuery();
        sentenceDataQuery.setDocumentId(sentenceQuery.getDocumentId());
        sentenceDataQuery.setSimilarity(sentenceQuery.getSimilarity());
        sentenceDataQuery.setResultIdList(this.getResultIdList(sentenceQuery));
        sentenceDataQuery.setIgnoreFlag(sentenceQuery.getIgnoreFlag());
        sentenceDataQuery.setPageFlag(sentenceQuery.isPageFlag());
        sentenceDataQuery.setCurrent(sentenceQuery.getCurrent());
        sentenceDataQuery.setSize(sentenceQuery.getSize());
        return this.sentenceService.getSentenceWithMaxSimiSentence(sentenceDataQuery);
    }

    public Page<DuplicateCheckResultDto> getSimilarityDocument(DuplicateCheckDocQuery docQuery) {
        List<DuplicateCheckResultDto> resultList = this.resultService.getSimilarityDoc(docQuery.getDocumentId());
        Page page = new Page();
        page.setRecords(resultList);
        page.setTotal((long)resultList.size());
        return page;
    }

    public Page<DuplicateCheckSimilarSentenceDto> getSimilaritySentence(SentenceQuery sentenceQuery) {
        DuplicateCheckSimilarSentenceQuery ssQuery = new DuplicateCheckSimilarSentenceQuery();
        ssQuery.setSentenceId(sentenceQuery.getSentenceId());
        ssQuery.setSimilarity(sentenceQuery.getSimilarity());
        List<String> resultIdList = this.getResultIdList(sentenceQuery);
        ssQuery.setResultIdList(resultIdList);
        ssQuery.setPageFlag(sentenceQuery.isPageFlag());
        ssQuery.setCurrent(sentenceQuery.getCurrent());
        ssQuery.setSize(sentenceQuery.getSize());
        return this.similarSentenceService.getSimilaritySentence(ssQuery);
    }

    private class GroupSimilarity {
        private String documentId;
        private String groupId;
        private BigDecimal similaritySum = new BigDecimal(0);
        private int simiDocumentSize = 0;

        public GroupSimilarity(String documentId, String groupId) {
            this.documentId = documentId;
            this.groupId = groupId;
        }

        public void addSimilarity(Double similarity) {
            ++this.simiDocumentSize;
            this.similaritySum = this.similaritySum.add(BigDecimal.valueOf(similarity));
        }

        public BigDecimal getSimilarity() {
            if (this.simiDocumentSize == 0) {
                return BigDecimal.ZERO;
            }
            return this.similaritySum.divide(BigDecimal.valueOf(this.simiDocumentSize), 6, RoundingMode.HALF_UP);
        }

        public String getDocumentId() {
            return this.documentId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public BigDecimal getSimilaritySum() {
            return this.similaritySum;
        }

        public int getSimiDocumentSize() {
            return this.simiDocumentSize;
        }

        public void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public void setSimilaritySum(BigDecimal similaritySum) {
            this.similaritySum = similaritySum;
        }

        public void setSimiDocumentSize(int simiDocumentSize) {
            this.simiDocumentSize = simiDocumentSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupSimilarity)) {
                return false;
            }
            GroupSimilarity other = (GroupSimilarity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSimiDocumentSize() != other.getSimiDocumentSize()) {
                return false;
            }
            String this$documentId = this.getDocumentId();
            String other$documentId = other.getDocumentId();
            if (this$documentId == null ? other$documentId != null : !this$documentId.equals(other$documentId)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            BigDecimal this$similaritySum = this.getSimilaritySum();
            BigDecimal other$similaritySum = other.getSimilaritySum();
            return !(this$similaritySum == null ? other$similaritySum != null : !((Object)this$similaritySum).equals(other$similaritySum));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GroupSimilarity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSimiDocumentSize();
            String $documentId = this.getDocumentId();
            result = result * 59 + ($documentId == null ? 43 : $documentId.hashCode());
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            BigDecimal $similaritySum = this.getSimilaritySum();
            result = result * 59 + ($similaritySum == null ? 43 : ((Object)$similaritySum).hashCode());
            return result;
        }

        public String toString() {
            return "IDuplicateCheckDataServiceImpl.GroupSimilarity(documentId=" + this.getDocumentId() + ", groupId=" + this.getGroupId() + ", similaritySum=" + this.getSimilaritySum() + ", simiDocumentSize=" + this.getSimiDocumentSize() + ")";
        }

        public GroupSimilarity(String documentId, String groupId, BigDecimal similaritySum, int simiDocumentSize) {
            this.documentId = documentId;
            this.groupId = groupId;
            this.similaritySum = similaritySum;
            this.simiDocumentSize = simiDocumentSize;
        }

        public GroupSimilarity() {
        }
    }
}

