/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckTemplateDoc;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckTemplateProject;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckTemplateDocQueryQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckTemplateProjectQuery;
import com.jxdinfo.idp.duplicatecheck.api.service.DuplicateCheckTemplateManagementService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckMonitorService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckTemplateDocService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckTemplateProjectService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class DuplicateCheckTemplateManagementServiceImpl
implements DuplicateCheckTemplateManagementService {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckTemplateManagementServiceImpl.class);
    @Resource
    private DuplicateCheckTemplateProjectService tempProjectService;
    @Resource
    private DuplicateCheckTemplateDocService tempDocService;
    @Resource
    private DuplicateCheckMonitorService monitorService;

    public DuplicateCheckTemplateProject createTemplateProject(DuplicateCheckTemplateProject duplicateCheckTemplateProject) {
        return this.tempProjectService.insert(duplicateCheckTemplateProject);
    }

    public Page<DuplicateCheckTemplateProject> listTemplateProject(DuplicateCheckTemplateProjectQuery templateProjectQuery) {
        return this.tempProjectService.list(templateProjectQuery);
    }

    public boolean deleteTemplateProject(List<String> templateProjectIdList) {
        if (CollectionUtils.isEmpty(templateProjectIdList)) {
            log.warn("\u5220\u9664\u67e5\u91cd\u6a21\u7248\u5e93\uff0c\u4f20\u5165\u7684templateProjectIdList is empty");
            return true;
        }
        this.tempProjectService.removeByIds(templateProjectIdList);
        List<DuplicateCheckTemplateDoc> checkTemplateDocs = this.tempDocService.listByTemplateProjectId(templateProjectIdList);
        if (CollectionUtils.isNotEmpty(checkTemplateDocs)) {
            List<String> templateDocIdList = checkTemplateDocs.stream().map(DuplicateCheckTemplateDoc::getTemplateProjectId).collect(Collectors.toList());
            this.removeTemplateDoc(templateDocIdList);
        }
        return true;
    }

    public DuplicateCheckTemplateDoc addTemplateDoc(DuplicateCheckTemplateDoc duplicateCheckTemplateDoc) {
        DuplicateCheckTemplateDoc templateDoc = this.tempDocService.insert(duplicateCheckTemplateDoc);
        this.monitorService.addTemplateDoc(duplicateCheckTemplateDoc);
        return templateDoc;
    }

    public boolean removeTemplateDoc(List<String> templateDocumentIdList) {
        if (CollectionUtils.isEmpty(templateDocumentIdList)) {
            log.warn("\u5220\u9664\u67e5\u91cd\u6a21\u7248\u5e93\uff0c\u4f20\u5165\u7684templateDocumentIdList is empty");
            return true;
        }
        List templateDocList = this.tempDocService.listByIds(templateDocumentIdList);
        this.tempDocService.removeByIds(templateDocumentIdList);
        this.monitorService.deleteTemplateDocument(templateDocList);
        return true;
    }

    public Page<DuplicateCheckTemplateDoc> listTemplateDoc(DuplicateCheckTemplateDocQueryQuery templateDocQueryQuery) {
        return this.tempDocService.list(templateDocQueryQuery);
    }
}

