/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.context;

import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckTask;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCheckContext {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckContext.class);
    private final DuplicateCheckTask task;
    private final List<Thread> waitThread;
    private volatile AtomicInteger vectorizationCount = new AtomicInteger(0);

    public DuplicateCheckContext(DuplicateCheckTask task) {
        this.task = task;
        this.waitThread = new CopyOnWriteArrayList<Thread>();
    }

    public void increment() {
        int vectorizationCountInt;
        boolean isContinue;
        while (isContinue = !this.vectorizationCount.compareAndSet(vectorizationCountInt = this.vectorizationCount.get(), vectorizationCountInt + 1)) {
        }
    }

    public void decrement() {
        int vectorizationCountInt;
        boolean isContinue;
        log.info("\u5f53\u524d\u53ef\u80fd\u9700\u8981\u7b49\u5f85\u7684\u7ebf\u7a0b\u4e3a\uff1a{}", (Object)Thread.currentThread().getName());
        this.waitThread.add(Thread.currentThread());
        while (isContinue = !this.vectorizationCount.compareAndSet(vectorizationCountInt = this.vectorizationCount.get(), vectorizationCountInt - 1)) {
        }
        vectorizationCountInt = this.vectorizationCount.get();
        if (vectorizationCountInt == 0) {
            this.notifyWait();
        }
    }

    public boolean isCheck() {
        this.decrement();
        int vectorizationCountInt = this.vectorizationCount.get();
        if (vectorizationCountInt == 0) {
            return true;
        }
        log.info("\u5f53\u524d\u7ebf\u7a0b\u963b\u585e");
        LockSupport.parkNanos(10800000000000L);
        return true;
    }

    private void notifyWait() {
        for (Thread thread : this.waitThread) {
            if (thread != null) {
                log.info("\u5f53\u524d\u7ebf\u7a0b\u88ab\u5524\u9192{}", (Object)thread.getName());
                LockSupport.unpark(thread);
                continue;
            }
            log.error("\u5f53\u524d\u7ebf\u7a0b\u7684\u4e3a\u7a7a\uff1f");
        }
    }
}

