/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBody;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public class TextToWord {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MultipartFile strToWord(String str) throws IOException {
        try (XWPFDocument document = new XWPFDocument();){
            XWPFStyles styles = document.createStyles();
            CTBody body = document.getDocument().getBody();
            body.setSectPr(body.addNewSectPr());
            XWPFParagraph paragraph = document.createParagraph();
            CTP ctp = paragraph.getCTP();
            CTPPr ppr = ctp.addNewPPr();
            ppr.setSectPr(ppr.addNewSectPr());
            ctp.setPPr(ppr);
            XWPFRun titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText(str);
            titleParagraphRun.setFontSize(14);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            document.write((OutputStream)baos);
            String filename = "tpm_" + System.currentTimeMillis() + ".docx";
            MockMultipartFile mockMultipartFile = new MockMultipartFile(filename, filename, null, baos.toByteArray());
            return mockMultipartFile;
        }
    }
}

