/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.executor.document.impl;

import com.jxdinfo.idp.icpac.core.dochandler.impl.TextDocumentHandler;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckCandidateSentence;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.executor.document.AbstractDuplicateCheckDocumentExecutor;
import com.jxdinfo.idp.icpac.core.utils.TextToWord;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TextDuplicateCheckExecutor
extends AbstractDuplicateCheckDocumentExecutor {
    private static final Logger log = LoggerFactory.getLogger(TextDuplicateCheckExecutor.class);

    @Override
    public boolean support(DuplicateCheckInfo info) {
        MultipartFile file = info.getFile();
        if (file == null) {
            return false;
        }
        String fileSuffix = info.getFormat();
        return Objects.equals(fileSuffix, "txt");
    }

    @Override
    protected List<DuplicateCheckCandidateSentence> getCandidateSentence(DuplicateCheckInfo checkInfo) throws Exception {
        MultipartFile file = checkInfo.getFile();
        byte[] bytes = file.getBytes();
        String text = new String(bytes, StandardCharsets.UTF_8);
        file = TextToWord.strToWord(text);
        checkInfo.setFile(file);
        TextDocumentHandler wordDocHandler = new TextDocumentHandler();
        List<DuplicateCheckCandidateSentence> candidateSentenceList = wordDocHandler.handleDoc(checkInfo);
        if (candidateSentenceList == null) {
            log.info("\u6ca1\u6709\u83b7\u53d6\u4efb\u4f55\u7684\u5e26\u5019\u9009\u53e5\u5b50");
        } else {
            log.info("\u83b7\u53d6\u5e26\u5019\u9009\u53e5\u5b50\u7684\u603b\u6761\u6570\u4e3a\uff1a{}", (Object)candidateSentenceList.size());
        }
        return candidateSentenceList;
    }
}

