/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import cn.hutool.core.util.IdUtil;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.util.DoubleUtils;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.dio.service.DocInfoIoService;
import com.jxdinfo.idp.docmanger.file.dto.DocumentUploadRequestDto;
import com.jxdinfo.idp.docmanger.file.dto.UploadDocumentResponseDto;
import com.jxdinfo.idp.docmanger.file.service.IDPDocMangerFileService;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocument;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocumentCollection;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocumentGroup;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckIgnoreLibraryDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckRequestDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckDoc;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckIgnoreLibrary;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckSentence;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSentenceQuery;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckUpdateModelEnum;
import com.jxdinfo.idp.icpac.custom.resulthandler.IgnoreResultHandler;
import com.jxdinfo.idp.icpac.listen.baseinfo.DuplicateCheckDocumentListener;
import com.jxdinfo.idp.icpac.listen.event.DuplicateCheckEvent;
import com.jxdinfo.idp.icpac.listen.event.MultiSimilarityEventType;
import com.jxdinfo.idp.icpac.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckExecutorService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckIgnoreLibraryService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckMonitorService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSentenceService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DuplicateCheckMonitorServiceImpl
implements DuplicateCheckMonitorService,
DuplicateCheckDocumentListener {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckMonitorServiceImpl.class);
    protected static final long B = 1024L;
    protected static final int KB = 0x100000;
    @Resource
    private DuplicateCheckExecutorService executorService;
    @Resource
    private DuplicateCheckDocService docService;
    @Resource
    private DocInfoIoService ioService;
    @Resource
    private IDPDocMangerFileService fileService;
    @Resource
    private DuplicateCheckIgnoreLibraryService ignoreLibraryService;
    @Resource
    private DuplicateCheckSentenceService sentenceService;
    private static final String GLOBAL_IGNORE = "1";
    private static final String ONCE_IGNORE = "0";

    @Override
    public List<DuplicateCheckDocDto> initLibDocument(DuplicateCheckDocumentCollection documentCollection) throws Exception {
        List pendingInfoList = documentCollection.getPendingInfoList();
        if (CollectionUtils.isEmpty((Collection)pendingInfoList)) {
            return new ArrayList<DuplicateCheckDocDto>();
        }
        Iterator pendingInfoIter = pendingInfoList.iterator();
        while (pendingInfoIter.hasNext()) {
            DuplicateCheckDocument pendingInfo = (DuplicateCheckDocument)pendingInfoIter.next();
            Long fileId = pendingInfo.getFileId();
            MultipartFile file = pendingInfo.getFile();
            String text = pendingInfo.getText();
            if (fileId != null) {
                MultipartFile transToFile = this.fileIdTransToFile(fileId);
                if (transToFile == null) {
                    pendingInfoIter.remove();
                }
                pendingInfo.setFile(transToFile);
                continue;
            }
            if (file != null) {
                Long saveFileId = this.saveFileInfo(file);
                if (saveFileId == null) {
                    pendingInfoIter.remove();
                }
                pendingInfo.setFileId(fileId);
                continue;
            }
            if (StringUtils.isNotEmpty((String)text)) {
                String textFilename = IdUtil.simpleUUID() + ".txt";
                MockMultipartFile textFile = new MockMultipartFile(textFilename, textFilename, null, text.getBytes());
                pendingInfo.setFile((MultipartFile)textFile);
                Long saveFileId = this.saveFileInfo((MultipartFile)textFile);
                if (saveFileId == null) {
                    pendingInfoIter.remove();
                }
                pendingInfo.setFileId(saveFileId);
                continue;
            }
            pendingInfoIter.remove();
        }
        return this.saveDocInfoToCheckDuplicateLib(documentCollection);
    }

    private Long saveFileInfo(MultipartFile file) {
        DocumentUploadRequestDto du = new DocumentUploadRequestDto();
        du.setFile(file);
        UploadDocumentResponseDto response = this.fileService.uploadDocument(du);
        Boolean status = response.getStatus();
        if (status != null && status.booleanValue()) {
            return response.getDocumentId();
        }
        log.error("\u5f53\u524d\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25\uff0c\u4fdd\u5b58\u7684\u6587\u4ef6\u4e3a\uff1a{}\uff1b\u5931\u8d25\u539f\u56e0\u4e3a\uff1a" + file.getOriginalFilename(), (Object)response.getErrorMessage());
        return null;
    }

    private List<DuplicateCheckDocDto> saveDocInfoToCheckDuplicateLib(DuplicateCheckDocumentCollection duplicateCheckDocument) {
        ArrayList<DuplicateCheckDocDto> docInfoList = new ArrayList<DuplicateCheckDocDto>();
        List pendingInfoList = duplicateCheckDocument.getPendingInfoList();
        String projectId = duplicateCheckDocument.getProjectId();
        for (DuplicateCheckDocument pendingInfo : pendingInfoList) {
            DuplicateCheckDocDto docInfo = new DuplicateCheckDocDto();
            docInfo.setProjectId(projectId);
            docInfo.setFileId(pendingInfo.getFileId());
            docInfo.setUpdateLib(pendingInfo.getUpdateLib());
            docInfo.setAttachment(pendingInfo.getAttachment());
            this.cacFileSize(pendingInfo.getFile(), (DuplicateCheckDoc)docInfo);
            docInfo.setFileName(pendingInfo.getFile().getOriginalFilename());
            docInfoList.add(docInfo);
        }
        return this.docService.saveDocInfo(docInfoList);
    }

    public void cacFileSize(MultipartFile file, DuplicateCheckDoc doc) {
        double size = file.getSize();
        if (size < 1024.0) {
            doc.setFileSize(String.valueOf(size));
            doc.setFileUnit("B");
        } else if (size < 1048576.0) {
            doc.setFileSize(String.valueOf(DoubleUtils.towDecimal((Double)(size / 1024.0))));
            doc.setFileUnit("KB");
        } else {
            doc.setFileSize(String.valueOf(DoubleUtils.towDecimal((Double)(size / 1048576.0))));
            doc.setFileUnit("MB");
        }
    }

    private MultipartFile fileIdTransToFile(Long fileId) {
        try {
            FileBytesInfo fileBytesInfo = this.ioService.getFileBytesInfo(fileId);
            String fileName = fileBytesInfo.getFileName();
            String fileFormat = fileBytesInfo.getFileFormat();
            if (!fileName.endsWith(fileFormat)) {
                fileName = fileName + "." + fileFormat;
            }
            return new MockMultipartFile(fileName, fileName, null, fileBytesInfo.getFileBytes());
        }
        catch (BusinessException ex) {
            log.info("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6id\u4e3a\uff1a{}", (Object)fileId, (Object)ex);
            return null;
        }
    }

    @Override
    public void checkDuplicate(List<DuplicateCheckDocumentGroup> taskGroupList, DuplicateCheckRequestDto duplicateCheckRequestDto) throws Exception {
        this.executorService.batchCheckDuplicate(taskGroupList, duplicateCheckRequestDto.getImmediate());
    }

    @Override
    public void addIgnoreSentence(String sentenceId, String globalIgnoreFlag) {
        DuplicateCheckSentence sentenceInfo = this.sentenceService.updateIgnoreSentence(sentenceId, ONCE_IGNORE);
        String docId = sentenceInfo.getDocId();
        DuplicateCheckDocDto documentInfo = this.docService.simpleDetail(docId);
        String projectId = documentInfo.getProjectId();
        if (Objects.equals(globalIgnoreFlag, GLOBAL_IGNORE)) {
            DuplicateCheckIgnoreLibraryDto ignoreLibraryDto = new DuplicateCheckIgnoreLibraryDto();
            ignoreLibraryDto.setProjectId(projectId);
            ignoreLibraryDto.setDocId(docId);
            ignoreLibraryDto.setSentenceId(sentenceId);
            ignoreLibraryDto.setSentence(sentenceInfo.getSentence());
            this.ignoreLibraryService.insert(ignoreLibraryDto);
            this.executorService.addIgnoreSentence(ignoreLibraryDto, new IgnoreResultHandler(this.ignoreLibraryService));
        }
        this.calcSimilarityAfterChange(Collections.singletonList(this.docService.simpleDetail(sentenceInfo.getDocId())));
    }

    @Override
    public void cancelIgnoreSentence(String sentenceId) {
        DuplicateCheckIgnoreLibrary ignoreLibrary = this.ignoreLibraryService.cancel(sentenceId);
        DuplicateCheckSentence sentenceInfo = this.sentenceService.updateIgnoreSentence(sentenceId, GLOBAL_IGNORE);
        this.executorService.cancelIgnoreSentence(ignoreLibrary, new IgnoreResultHandler(this.ignoreLibraryService));
        this.calcSimilarityAfterChange(Collections.singletonList(this.docService.simpleDetail(sentenceInfo.getDocId())));
    }

    @Override
    public void onEvent(DuplicateCheckEvent event) {
        if (event == null) {
            return;
        }
        if (event.getEventType() != MultiSimilarityEventType.DELETE) {
            return;
        }
        Object data = event.getData();
        if (data == null) {
            return;
        }
        List documentInfoList = (List)data;
        this.deleteDocument(documentInfoList);
    }

    private void deleteDocument(List<? extends DuplicateCheckDoc> documentInfoList) {
        this.executorService.deleteDocument(documentInfoList);
        for (DuplicateCheckDoc duplicateCheckDoc : documentInfoList) {
            String projectId = duplicateCheckDoc.getProjectId();
            List<DuplicateCheckDocDto> remainDocumentInfoList = this.docService.listByProjectId(projectId);
            this.calcSimilarityAfterChange(remainDocumentInfoList);
        }
    }

    private void calcSimilarityAfterChange(List<DuplicateCheckDocDto> remainDocumentInfoList) {
        ArrayList<String> remainDocumentIdList = new ArrayList<String>();
        Iterator<DuplicateCheckDocDto> documentIter = remainDocumentInfoList.iterator();
        while (documentIter.hasNext()) {
            DuplicateCheckDocDto documentInfo = documentIter.next();
            if (DuplicateCheckUpdateModelEnum.getUpdateModel(documentInfo.getUpdateLib()) != DuplicateCheckUpdateModelEnum.NO_CHECK_UPDATE) {
                remainDocumentIdList.add(documentInfo.getId());
                continue;
            }
            documentIter.remove();
        }
        if (CollectionUtils.isEmpty(remainDocumentInfoList)) {
            return;
        }
        DuplicateCheckSentenceQuery sentenceQuery = new DuplicateCheckSentenceQuery();
        sentenceQuery.setDocumentIdList(remainDocumentIdList);
        sentenceQuery.setIgnoreFlag(GLOBAL_IGNORE);
        sentenceQuery.setPageFlag(false);
        List sentenceDtoList = this.sentenceService.getSentenceList(sentenceQuery).getRecords();
        HashMap<String, List> docIdListMap = new HashMap<String, List>();
        for (DuplicateCheckSentenceDto sentenceDto : sentenceDtoList) {
            docIdListMap.computeIfAbsent(sentenceDto.getDocId(), k -> new ArrayList()).add(sentenceDto);
        }
        ArrayList<DuplicateCheckDoc> updateDoc = new ArrayList<DuplicateCheckDoc>();
        for (DuplicateCheckDocDto documentInfo : remainDocumentInfoList) {
            DuplicateCheckDoc checkDocumentInfo = this.calcSimilarity(documentInfo.getId(), documentInfo.getCandidateSentenceNum(), (Collection)docIdListMap.get(documentInfo.getId()));
            checkDocumentInfo.setUpdateLib(documentInfo.getUpdateLib());
            updateDoc.add(checkDocumentInfo);
        }
        this.docService.updateBatchById(updateDoc);
    }

    private DuplicateCheckDoc calcSimilarity(String docId, int candidateSentenceNum, Collection<DuplicateCheckSentenceDto> sentenceList) {
        double maxSimilarity = 0.0;
        double docSimilarity = 0.0;
        if (CollectionUtils.isNotEmpty(sentenceList)) {
            BigDecimal docSimilarityD = new BigDecimal(0);
            for (DuplicateCheckSentenceDto sentenceInfo : sentenceList) {
                if (Double.compare(maxSimilarity, sentenceInfo.getSimilarity()) < 0) {
                    maxSimilarity = sentenceInfo.getSimilarity();
                }
                docSimilarityD = docSimilarityD.add(BigDecimal.valueOf(sentenceInfo.getSimilarity()));
            }
            docSimilarity = DoubleUtils.towDecimal((Double)(docSimilarityD.doubleValue() / (double)candidateSentenceNum));
        }
        DuplicateCheckDoc doc = new DuplicateCheckDoc();
        doc.setId(docId);
        doc.setMaxSimilarity(Double.valueOf(maxSimilarity));
        doc.setDocSimilarity(Double.valueOf(docSimilarity));
        doc.setCandidateSentenceNum(candidateSentenceNum);
        return doc;
    }
}

