/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckResultDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckDoc;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckDocQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckResultQuery;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckStatusEnum;
import com.jxdinfo.idp.icpac.listen.baseinfo.DuplicateCheckDocumentListenerManger;
import com.jxdinfo.idp.icpac.listen.baseinfo.DuplicateCheckProjectListener;
import com.jxdinfo.idp.icpac.listen.baseinfo.DuplicateCheckProjectListenerManger;
import com.jxdinfo.idp.icpac.listen.event.DuplicateCheckEvent;
import com.jxdinfo.idp.icpac.listen.event.MultiSimilarityEventType;
import com.jxdinfo.idp.icpac.mapper.DuplicateCheckDocMapper;
import com.jxdinfo.idp.icpac.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckResultService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSentenceService;
import com.jxdinfo.idp.icpac.utils.DuplicateCheckProgress;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DuplicateCheckDocServiceImpl
extends ServiceImpl<DuplicateCheckDocMapper, DuplicateCheckDoc>
implements DuplicateCheckDocService,
DuplicateCheckProjectListener {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckDocServiceImpl.class);
    @Resource
    private DuplicateCheckDocMapper mapper;
    @Resource
    private DuplicateCheckResultService resultService;
    @Resource
    private DuplicateCheckSentenceService sentenceService;

    public DuplicateCheckDocServiceImpl() {
        DuplicateCheckProjectListenerManger.register(this);
    }

    @Override
    public void onEvent(DuplicateCheckEvent event) {
        if (event.getEventType() == MultiSimilarityEventType.DELETE) {
            List projectIds = (List)event.getData();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(DuplicateCheckDoc::getProjectId, (Collection)projectIds);
            List docInfoList = this.list((Wrapper)wrapper);
            List<String> ids = docInfoList.stream().map(DuplicateCheckDoc::getId).collect(Collectors.toList());
            this.delete(ids);
        }
    }

    @Override
    public Page<DuplicateCheckDocDto> list(DuplicateCheckDocQuery query) {
        boolean pageFlag = query.isPageFlag();
        Page page = query.getPage(DuplicateCheckDocDto.class);
        if (pageFlag) {
            List<DuplicateCheckDocDto> docInfoList = this.mapper.list(query, (Page<DuplicateCheckDocDto>)page);
            page.setRecords(docInfoList);
        } else {
            List<DuplicateCheckDocDto> docInfoList = this.mapper.list(query, null);
            page.setRecords(docInfoList);
        }
        return page;
    }

    @Override
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        DuplicateCheckProgress.clear(ids);
        DuplicateCheckDoc checkDoc = (DuplicateCheckDoc)this.getById((Serializable)((Object)ids.get(0)));
        if (checkDoc == null) {
            return;
        }
        List checkDocList = this.listByIds(ids);
        Set<String> projectIdSet = checkDocList.stream().map(DuplicateCheckDoc::getProjectId).collect(Collectors.toSet());
        this.removeByIds(ids);
        this.cascadeDelete(ids, projectIdSet);
        DuplicateCheckDocumentListenerManger.publish(new DuplicateCheckEvent(checkDocList, MultiSimilarityEventType.DELETE));
    }

    @Override
    public List<DuplicateCheckDocDto> saveDocInfo(List<DuplicateCheckDocDto> docInfoList) {
        ArrayList<DuplicateCheckDoc> saveDocList = new ArrayList<DuplicateCheckDoc>();
        for (DuplicateCheckDocDto docInfo : docInfoList) {
            this.fillInfo(docInfo);
            saveDocList.add(new DuplicateCheckDoc((DuplicateCheckDoc)docInfo));
        }
        this.saveBatch(saveDocList);
        return docInfoList;
    }

    private void cascadeDelete(List<String> ids, Set<String> projectIdSet) {
        this.sentenceService.deleteByDocIds(ids);
        this.resultService.deleteByDocIds(ids);
        if (projectIdSet.size() != 1) {
            return;
        }
        String projectId = null;
        Iterator<String> iterator = projectIdSet.iterator();
        while (iterator.hasNext()) {
            String tmpProjectId;
            projectId = tmpProjectId = iterator.next();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DuplicateCheckDoc::getProjectId, (Object)projectId);
        List checkDocList = this.list((Wrapper)wrapper);
        List<String> remainIdList = checkDocList.stream().map(DuplicateCheckDoc::getId).collect(Collectors.toList());
        DuplicateCheckResultQuery resultQuery = new DuplicateCheckResultQuery();
        resultQuery.setUploadDocIds(remainIdList);
        List<DuplicateCheckResultDto> resultDtos = this.resultService.list(resultQuery);
        if (CollectionUtils.isEmpty(resultDtos)) {
            this.sentenceService.deleteByDocIds(remainIdList);
        } else {
            for (DuplicateCheckResultDto resultDto : resultDtos) {
                remainIdList.remove(resultDto.getUploadDocId());
            }
            this.sentenceService.deleteByDocIds(remainIdList);
        }
    }

    @Override
    public DuplicateCheckDocDto detail(String id) {
        DuplicateCheckDoc docInfo = (DuplicateCheckDoc)this.getById((Serializable)((Object)id));
        if (docInfo == null) {
            return new DuplicateCheckDocDto();
        }
        DuplicateCheckDocDto docInfoDto = DuplicateCheckDocDto.toDto((DuplicateCheckDoc)docInfo);
        Map<String, List<DuplicateCheckResultDto>> idObjMap = this.resultService.listByDocIdsForMap(Collections.singletonList(id));
        docInfoDto.setResultList(idObjMap.get(docInfoDto.getId()));
        return docInfoDto;
    }

    @Override
    public List<DuplicateCheckDocDto> listByProjectId(String projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DuplicateCheckDoc::getProjectId, (Object)projectId);
        List docInfos = this.list((Wrapper)wrapper);
        return DuplicateCheckDocDto.toDto((List)docInfos);
    }

    @Override
    public DuplicateCheckDoc insert(DuplicateCheckDocDto docInfoDto) throws Exception {
        String projectId = docInfoDto.getProjectId();
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            throw new IllegalArgumentException("\u6587\u6863\u4e0d\u77e5\u9053\u5bf9\u5e94\u7684\u57fa\u7840\u4fe1\u606fid\uff0c\u4f20\u5165\u7684\u57fa\u7840\u4fe1\u606fid\u4e3a\u7a7a");
        }
        this.fillInfo(docInfoDto);
        this.save(docInfoDto);
        return docInfoDto;
    }

    private void fillInfo(DuplicateCheckDocDto docDto) {
        docDto.setId(String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
        docDto.setTaskStatus(DuplicateCheckStatusEnum.PROCESSING.getStatus());
        docDto.setStartTime(LocalDateTime.now());
    }

    @Override
    public DuplicateCheckDocDto simpleDetail(String id) {
        DuplicateCheckDocQuery docQuery = new DuplicateCheckDocQuery();
        docQuery.setDocumentId(id);
        List<DuplicateCheckDocDto> docDtoList = this.mapper.list(docQuery, null);
        if (CollectionUtils.isEmpty(docDtoList)) {
            return new DuplicateCheckDocDto();
        }
        return docDtoList.get(0);
    }

    @Override
    public void insertCheckResult(DuplicateCheckDocDto docDto) {
        this.resultService.deleteByDocumentIds(Arrays.asList(docDto.getId()));
        this.resultService.saveBatch(docDto.getResultList());
        this.sentenceService.deleteByDocIds(Arrays.asList(docDto.getId()));
        this.sentenceService.saveBatch(docDto.getSentenceList());
    }
}

